/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.TimeoutObserver;
import org.apache.tools.ant.util.Watchdog;

public class ExecuteWatchdog
implements TimeoutObserver {
    private Process process;
    private volatile boolean watch = false;
    private Exception caught = null;
    private volatile boolean killedProcess = false;
    private Watchdog watchdog;

    public ExecuteWatchdog(long l) {
        this.watchdog = new Watchdog(l);
        this.watchdog.addTimeoutObserver(this);
    }

    public ExecuteWatchdog(int n) {
        this((long)n);
    }

    public synchronized void start(Process process) {
        if (process == null) {
            throw new NullPointerException("process is null.");
        }
        if (this.process != null) {
            throw new IllegalStateException("Already running.");
        }
        this.caught = null;
        this.killedProcess = false;
        this.watch = true;
        this.process = process;
        this.watchdog.start();
    }

    public synchronized void stop() {
        this.watchdog.stop();
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void timeoutOccured(Watchdog watchdog) {
        try {
            try {
                this.process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                if (this.watch) {
                    this.killedProcess = true;
                    this.process.destroy();
                }
            }
        }
        catch (Exception exception) {
            this.caught = exception;
        }
        finally {
            this.cleanUp();
        }
    }

    protected synchronized void cleanUp() {
        this.watch = false;
        this.process = null;
    }

    public synchronized void checkException() throws BuildException {
        if (this.caught != null) {
            throw new BuildException("Exception in ExecuteWatchdog.run: " + this.caught.getMessage(), this.caught);
        }
    }

    public boolean isWatching() {
        return this.watch;
    }

    public boolean killedProcess() {
        return this.killedProcess;
    }
}

