/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.util.DOMElementWriter;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.XMLFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EchoXML
extends XMLFragment {
    private File file;
    private boolean append;
    private static final String ERROR_NO_XML = "No nested XML specified";

    public void setFile(File file) {
        this.file = file;
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        DOMElementWriter dOMElementWriter = new DOMElementWriter(!this.append);
        OutputStream outputStream = null;
        try {
            outputStream = this.file != null ? new FileOutputStream(this.file.getAbsolutePath(), this.append) : new LogOutputStream(this, 2);
            Node node = this.getFragment().getFirstChild();
            if (node == null) {
                throw new BuildException(ERROR_NO_XML);
            }
            dOMElementWriter.write((Element)node, outputStream);
        }
        catch (BuildException buildException) {
            try {
                throw buildException;
                catch (Exception exception) {
                    throw new BuildException(exception);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(outputStream);
                throw throwable;
            }
        }
        FileUtils.close(outputStream);
    }
}

