/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.FileResourceIterator;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.Sort;
import org.apache.tools.ant.types.resources.comparators.FileSystem;
import org.apache.tools.ant.types.resources.comparators.ResourceComparator;
import org.apache.tools.ant.types.resources.comparators.Reverse;
import org.apache.tools.ant.types.resources.selectors.Exists;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.SizeSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.ModifiedSelector;

public class Delete
extends MatchingTask {
    private static final int DELETE_RETRY_SLEEP_MILLIS = 10;
    private static final ResourceComparator REVERSE_FILESYSTEM = new Reverse(new FileSystem());
    private static final ResourceSelector EXISTS = new Exists();
    protected File file = null;
    protected File dir = null;
    protected Vector filesets = new Vector();
    protected boolean usedMatchingTask = false;
    protected boolean includeEmpty = false;
    private int verbosity = 3;
    private boolean quiet = false;
    private boolean failonerror = true;
    private boolean deleteOnExit = false;
    private Resources rcs = null;

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File file) {
        this.dir = file;
        this.getImplicitFileSet().setDir(file);
    }

    public void setVerbose(boolean bl) {
        this.verbosity = bl ? 2 : 3;
    }

    public void setQuiet(boolean bl) {
        this.quiet = bl;
        if (bl) {
            this.failonerror = false;
        }
    }

    public void setFailOnError(boolean bl) {
        this.failonerror = bl;
    }

    public void setDeleteOnExit(boolean bl) {
        this.deleteOnExit = bl;
    }

    public void setIncludeEmptyDirs(boolean bl) {
        this.includeEmpty = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public void add(ResourceCollection resourceCollection) {
        if (resourceCollection == null) {
            return;
        }
        this.rcs = this.rcs == null ? new Resources() : this.rcs;
        this.rcs.add(resourceCollection);
    }

    @Override
    public PatternSet.NameEntry createInclude() {
        this.usedMatchingTask = true;
        return super.createInclude();
    }

    @Override
    public PatternSet.NameEntry createIncludesFile() {
        this.usedMatchingTask = true;
        return super.createIncludesFile();
    }

    @Override
    public PatternSet.NameEntry createExclude() {
        this.usedMatchingTask = true;
        return super.createExclude();
    }

    @Override
    public PatternSet.NameEntry createExcludesFile() {
        this.usedMatchingTask = true;
        return super.createExcludesFile();
    }

    @Override
    public PatternSet createPatternSet() {
        this.usedMatchingTask = true;
        return super.createPatternSet();
    }

    @Override
    public void setIncludes(String string) {
        this.usedMatchingTask = true;
        super.setIncludes(string);
    }

    @Override
    public void setExcludes(String string) {
        this.usedMatchingTask = true;
        super.setExcludes(string);
    }

    @Override
    public void setDefaultexcludes(boolean bl) {
        this.usedMatchingTask = true;
        super.setDefaultexcludes(bl);
    }

    @Override
    public void setIncludesfile(File file) {
        this.usedMatchingTask = true;
        super.setIncludesfile(file);
    }

    @Override
    public void setExcludesfile(File file) {
        this.usedMatchingTask = true;
        super.setExcludesfile(file);
    }

    @Override
    public void setCaseSensitive(boolean bl) {
        this.usedMatchingTask = true;
        super.setCaseSensitive(bl);
    }

    @Override
    public void setFollowSymlinks(boolean bl) {
        this.usedMatchingTask = true;
        super.setFollowSymlinks(bl);
    }

    @Override
    public void addSelector(SelectSelector selectSelector) {
        this.usedMatchingTask = true;
        super.addSelector(selectSelector);
    }

    @Override
    public void addAnd(AndSelector andSelector) {
        this.usedMatchingTask = true;
        super.addAnd(andSelector);
    }

    @Override
    public void addOr(OrSelector orSelector) {
        this.usedMatchingTask = true;
        super.addOr(orSelector);
    }

    @Override
    public void addNot(NotSelector notSelector) {
        this.usedMatchingTask = true;
        super.addNot(notSelector);
    }

    @Override
    public void addNone(NoneSelector noneSelector) {
        this.usedMatchingTask = true;
        super.addNone(noneSelector);
    }

    @Override
    public void addMajority(MajoritySelector majoritySelector) {
        this.usedMatchingTask = true;
        super.addMajority(majoritySelector);
    }

    @Override
    public void addDate(DateSelector dateSelector) {
        this.usedMatchingTask = true;
        super.addDate(dateSelector);
    }

    @Override
    public void addSize(SizeSelector sizeSelector) {
        this.usedMatchingTask = true;
        super.addSize(sizeSelector);
    }

    @Override
    public void addFilename(FilenameSelector filenameSelector) {
        this.usedMatchingTask = true;
        super.addFilename(filenameSelector);
    }

    @Override
    public void addCustom(ExtendSelector extendSelector) {
        this.usedMatchingTask = true;
        super.addCustom(extendSelector);
    }

    @Override
    public void addContains(ContainsSelector containsSelector) {
        this.usedMatchingTask = true;
        super.addContains(containsSelector);
    }

    @Override
    public void addPresent(PresentSelector presentSelector) {
        this.usedMatchingTask = true;
        super.addPresent(presentSelector);
    }

    @Override
    public void addDepth(DepthSelector depthSelector) {
        this.usedMatchingTask = true;
        super.addDepth(depthSelector);
    }

    @Override
    public void addDepend(DependSelector dependSelector) {
        this.usedMatchingTask = true;
        super.addDepend(dependSelector);
    }

    @Override
    public void addContainsRegexp(ContainsRegexpSelector containsRegexpSelector) {
        this.usedMatchingTask = true;
        super.addContainsRegexp(containsRegexpSelector);
    }

    @Override
    public void addModified(ModifiedSelector modifiedSelector) {
        this.usedMatchingTask = true;
        super.addModified(modifiedSelector);
    }

    @Override
    public void add(FileSelector fileSelector) {
        this.usedMatchingTask = true;
        super.add(fileSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        if (this.usedMatchingTask) {
            this.log("DEPRECATED - Use of the implicit FileSet is deprecated.  Use a nested fileset element instead.", this.quiet ? 3 : this.verbosity);
        }
        if (this.file == null && this.dir == null && this.filesets.size() == 0 && this.rcs == null) {
            throw new BuildException("At least one of the file or dir attributes, or a nested resource collection, must be set.");
        }
        if (this.quiet && this.failonerror) {
            throw new BuildException("quiet and failonerror cannot both be set to true", this.getLocation());
        }
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.file.isDirectory()) {
                    this.log("Directory " + this.file.getAbsolutePath() + " cannot be removed using the file attribute.  " + "Use dir instead.", this.quiet ? 3 : this.verbosity);
                } else {
                    this.log("Deleting: " + this.file.getAbsolutePath());
                    if (!this.delete(this.file)) {
                        this.handle("Unable to delete file " + this.file.getAbsolutePath());
                    }
                }
            } else {
                this.log("Could not find file " + this.file.getAbsolutePath() + " to delete.", this.quiet ? 3 : this.verbosity);
            }
        }
        if (this.dir != null && this.dir.exists() && this.dir.isDirectory() && !this.usedMatchingTask) {
            if (this.verbosity == 3) {
                this.log("Deleting directory " + this.dir.getAbsolutePath());
            }
            this.removeDir(this.dir);
        }
        Resources resources = new Resources();
        resources.setProject(this.getProject());
        Resources resources2 = new Resources();
        resources2.setProject(this.getProject());
        FileSet fileSet = null;
        if (this.usedMatchingTask && this.dir != null && this.dir.isDirectory()) {
            fileSet = this.getImplicitFileSet();
            fileSet.setProject(this.getProject());
            this.filesets.add(fileSet);
        }
        int n = this.filesets.size();
        for (int i = 0; i < n; ++i) {
            File file;
            FileSet fileSet2 = (FileSet)this.filesets.get(i);
            if (fileSet2.getProject() == null) {
                this.log("Deleting fileset with no project specified; assuming executing project", 3);
                fileSet2 = (FileSet)fileSet2.clone();
                fileSet2.setProject(this.getProject());
            }
            if ((file = fileSet2.getDir()) == null) {
                throw new BuildException("File or Resource without directory or file specified");
            }
            if (!file.isDirectory()) {
                this.handle("Directory does not exist:" + file);
                continue;
            }
            resources.add(fileSet2);
            if (!this.includeEmpty) continue;
            resources2.add(new ReverseDirs(file, fileSet2.getDirectoryScanner().getIncludedDirectories()));
        }
        resources.add(resources2);
        if (this.rcs != null) {
            Restrict restrict = new Restrict();
            restrict.add(EXISTS);
            restrict.add(this.rcs);
            Sort sort = new Sort();
            sort.add(REVERSE_FILESYSTEM);
            sort.add(restrict);
            resources.add(sort);
        }
        try {
            if (resources.isFilesystemOnly()) {
                Iterator iterator = resources.iterator();
                while (iterator.hasNext()) {
                    FileResource fileResource = (FileResource)iterator.next();
                    if (!fileResource.isExists() || fileResource.isDirectory() && fileResource.getFile().list().length != 0) continue;
                    this.log("Deleting " + fileResource, this.verbosity);
                    if (this.delete(fileResource.getFile()) || !this.failonerror) continue;
                    this.handle("Unable to delete " + (fileResource.isDirectory() ? "directory " : "file ") + fileResource);
                }
            } else {
                this.handle(this.getTaskName() + " handles only filesystem resources");
            }
        }
        catch (Exception exception) {
            this.handle(exception);
        }
        finally {
            if (fileSet != null) {
                this.filesets.remove(fileSet);
            }
        }
    }

    private void handle(String string) {
        this.handle(new BuildException(string));
    }

    private void handle(Exception exception) {
        if (this.failonerror) {
            throw exception instanceof BuildException ? (BuildException)exception : new BuildException(exception);
        }
        this.log(exception, this.quiet ? 3 : this.verbosity);
    }

    private boolean delete(File file) {
        if (!file.delete()) {
            if (Os.isFamily("windows")) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!file.delete()) {
                if (this.deleteOnExit) {
                    int n = this.quiet ? 3 : 2;
                    this.log("Failed to delete " + file + ", calling deleteOnExit." + " This attempts to delete the file when the Ant jvm" + " has exited and might not succeed.", n);
                    file.deleteOnExit();
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected void removeDir(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            File file2 = new File(file, string);
            if (file2.isDirectory()) {
                this.removeDir(file2);
                continue;
            }
            this.log("Deleting " + file2.getAbsolutePath(), this.quiet ? 3 : this.verbosity);
            if (this.delete(file2)) continue;
            this.handle("Unable to delete file " + file2.getAbsolutePath());
        }
        this.log("Deleting directory " + file.getAbsolutePath(), this.verbosity);
        if (!this.delete(file)) {
            this.handle("Unable to delete directory " + this.dir.getAbsolutePath());
        }
    }

    protected void removeFiles(File file, String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray.length > 0) {
            this.log("Deleting " + stringArray.length + " files from " + file.getAbsolutePath(), this.quiet ? 3 : this.verbosity);
            for (n = 0; n < stringArray.length; ++n) {
                File file2 = new File(file, stringArray[n]);
                this.log("Deleting " + file2.getAbsolutePath(), this.quiet ? 3 : this.verbosity);
                if (this.delete(file2)) continue;
                this.handle("Unable to delete file " + file2.getAbsolutePath());
            }
        }
        if (stringArray2.length > 0 && this.includeEmpty) {
            n = 0;
            for (int i = stringArray2.length - 1; i >= 0; --i) {
                File file3 = new File(file, stringArray2[i]);
                String[] stringArray3 = file3.list();
                if (stringArray3 != null && stringArray3.length != 0) continue;
                this.log("Deleting " + file3.getAbsolutePath(), this.quiet ? 3 : this.verbosity);
                if (!this.delete(file3)) {
                    this.handle("Unable to delete directory " + file3.getAbsolutePath());
                    continue;
                }
                ++n;
            }
            if (n > 0) {
                this.log("Deleted " + n + " director" + (n == 1 ? "y" : "ies") + " form " + file.getAbsolutePath(), this.quiet ? 3 : this.verbosity);
            }
        }
    }

    private static class ReverseDirs
    implements ResourceCollection {
        static final Comparator REVERSE = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Comparable)object).compareTo(object2) * -1;
            }
        };
        private File basedir;
        private String[] dirs;

        ReverseDirs(File file, String[] stringArray) {
            this.basedir = file;
            this.dirs = stringArray;
            Arrays.sort(this.dirs, REVERSE);
        }

        @Override
        public Iterator iterator() {
            return new FileResourceIterator(this.basedir, this.dirs);
        }

        @Override
        public boolean isFilesystemOnly() {
            return true;
        }

        @Override
        public int size() {
            return this.dirs.length;
        }
    }
}

