/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.AbstractFileSet;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.FlatFileNameMapper;
import org.apache.tools.ant.util.IdentityMapper;
import org.apache.tools.ant.util.ResourceUtils;
import org.apache.tools.ant.util.SourceFileScanner;

public class Copy
extends Task {
    static final File NULL_FILE_PLACEHOLDER = new File("/NULL_FILE");
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected File file = null;
    protected File destFile = null;
    protected File destDir = null;
    protected Vector rcs = new Vector();
    private boolean enableMultipleMappings = false;
    protected boolean filtering = false;
    protected boolean preserveLastModified = false;
    protected boolean forceOverwrite = false;
    protected boolean flatten = false;
    protected int verbosity = 3;
    protected boolean includeEmpty = true;
    protected boolean failonerror = true;
    protected Hashtable fileCopyMap = new Hashtable();
    protected Hashtable dirCopyMap = new Hashtable();
    protected Hashtable completeDirMap = new Hashtable();
    protected Mapper mapperElement = null;
    protected FileUtils fileUtils;
    private Vector filterChains = new Vector();
    private Vector filterSets = new Vector();
    private String inputEncoding = null;
    private String outputEncoding = null;
    private long granularity = 0L;

    public Copy() {
        this.fileUtils = FileUtils.getFileUtils();
        this.granularity = this.fileUtils.getFileTimestampGranularity();
    }

    protected FileUtils getFileUtils() {
        return this.fileUtils;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTofile(File file) {
        this.destFile = file;
    }

    public void setTodir(File file) {
        this.destDir = file;
    }

    public FilterChain createFilterChain() {
        FilterChain filterChain = new FilterChain();
        this.filterChains.addElement(filterChain);
        return filterChain;
    }

    public FilterSet createFilterSet() {
        FilterSet filterSet = new FilterSet();
        this.filterSets.addElement(filterSet);
        return filterSet;
    }

    public void setPreserveLastModified(String string) {
        this.setPreserveLastModified(Project.toBoolean(string));
    }

    public void setPreserveLastModified(boolean bl) {
        this.preserveLastModified = bl;
    }

    public boolean getPreserveLastModified() {
        return this.preserveLastModified;
    }

    protected Vector getFilterSets() {
        return this.filterSets;
    }

    protected Vector getFilterChains() {
        return this.filterChains;
    }

    public void setFiltering(boolean bl) {
        this.filtering = bl;
    }

    public void setOverwrite(boolean bl) {
        this.forceOverwrite = bl;
    }

    public void setFlatten(boolean bl) {
        this.flatten = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbosity = bl ? 2 : 3;
    }

    public void setIncludeEmptyDirs(boolean bl) {
        this.includeEmpty = bl;
    }

    public void setEnableMultipleMappings(boolean bl) {
        this.enableMultipleMappings = bl;
    }

    public boolean isEnableMultipleMapping() {
        return this.enableMultipleMappings;
    }

    public void setFailOnError(boolean bl) {
        this.failonerror = bl;
    }

    public void addFileset(FileSet fileSet) {
        this.add(fileSet);
    }

    public void add(ResourceCollection resourceCollection) {
        this.rcs.add(resourceCollection);
    }

    public Mapper createMapper() throws BuildException {
        if (this.mapperElement != null) {
            throw new BuildException("Cannot define more than one mapper", this.getLocation());
        }
        this.mapperElement = new Mapper(this.getProject());
        return this.mapperElement;
    }

    public void add(FileNameMapper fileNameMapper) {
        this.createMapper().add(fileNameMapper);
    }

    public void setEncoding(String string) {
        this.inputEncoding = string;
        if (this.outputEncoding == null) {
            this.outputEncoding = string;
        }
    }

    public String getEncoding() {
        return this.inputEncoding;
    }

    public void setOutputEncoding(String string) {
        this.outputEncoding = string;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setGranularity(long l) {
        this.granularity = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        block22: {
            File file = this.file;
            File file2 = this.destFile;
            File file3 = this.destDir;
            ResourceCollection resourceCollection = null;
            if (this.file == null && this.destFile != null && this.rcs.size() == 1) {
                resourceCollection = (ResourceCollection)this.rcs.elementAt(0);
            }
            this.validateAttributes();
            try {
                Object object;
                this.copySingleFile();
                HashMap hashMap = new HashMap();
                HashMap hashMap2 = new HashMap();
                HashSet<File> hashSet = new HashSet<File>();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 0; i < this.rcs.size(); ++i) {
                    Object object2;
                    Object object3;
                    File file4;
                    Object object4;
                    Object object5;
                    object = (ResourceCollection)this.rcs.elementAt(i);
                    if (object instanceof FileSet && object.isFilesystemOnly()) {
                        object5 = (FileSet)object;
                        object4 = null;
                        try {
                            object4 = ((AbstractFileSet)object5).getDirectoryScanner(this.getProject());
                        }
                        catch (BuildException buildException) {
                            if (this.failonerror || !this.getMessage(buildException).endsWith(" not found.")) {
                                throw buildException;
                            }
                            this.log("Warning: " + this.getMessage(buildException), 0);
                            continue;
                        }
                        file4 = ((AbstractFileSet)object5).getDir(this.getProject());
                        object3 = ((DirectoryScanner)object4).getIncludedFiles();
                        object2 = ((DirectoryScanner)object4).getIncludedDirectories();
                        if (!this.flatten && this.mapperElement == null && ((DirectoryScanner)object4).isEverythingIncluded() && !((AbstractFileSet)object5).hasPatterns()) {
                            this.completeDirMap.put(file4, this.destDir);
                        }
                        Copy.add(file4, object3, hashMap);
                        Copy.add(file4, (String[])object2, hashMap2);
                        hashSet.add(file4);
                        continue;
                    }
                    if (!object.isFilesystemOnly() && !this.supportsNonFileResources()) {
                        throw new BuildException("Only FileSystem resources are supported.");
                    }
                    object5 = object.iterator();
                    while (object5.hasNext()) {
                        object4 = (Resource)object5.next();
                        if (!((Resource)object4).isExists()) continue;
                        file4 = NULL_FILE_PLACEHOLDER;
                        object3 = ((Resource)object4).getName();
                        if (object4 instanceof FileResource) {
                            object2 = (FileResource)object4;
                            file4 = Copy.getKeyFile(((FileResource)object2).getBaseDir());
                            if (((FileResource)object2).getBaseDir() == null) {
                                object3 = ((FileResource)object2).getFile().getAbsolutePath();
                            }
                        }
                        if (((Resource)object4).isDirectory() || object4 instanceof FileResource) {
                            Copy.add(file4, (String)object3, ((Resource)object4).isDirectory() ? hashMap2 : hashMap);
                            hashSet.add(file4);
                            continue;
                        }
                        arrayList.add(object4);
                    }
                }
                this.iterateOverBaseDirs(hashSet, hashMap2, hashMap);
                try {
                    this.doFileOperations();
                }
                catch (BuildException buildException) {
                    if (!this.failonerror) {
                        this.log("Warning: " + this.getMessage(buildException), 0);
                    }
                    throw buildException;
                }
                if (arrayList.size() <= 0) break block22;
                Resource[] resourceArray = arrayList.toArray(new Resource[arrayList.size()]);
                object = this.scan(resourceArray, this.destDir);
                try {
                    this.doResourceOperations((Map)object);
                }
                catch (BuildException buildException) {
                    if (!this.failonerror) {
                        this.log("Warning: " + this.getMessage(buildException), 0);
                        break block22;
                    }
                    throw buildException;
                }
            }
            finally {
                this.file = file;
                this.destFile = file2;
                this.destDir = file3;
                if (resourceCollection != null) {
                    this.rcs.insertElementAt(resourceCollection, 0);
                }
                this.fileCopyMap.clear();
                this.dirCopyMap.clear();
                this.completeDirMap.clear();
            }
        }
    }

    private void copySingleFile() {
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.destFile == null) {
                    this.destFile = new File(this.destDir, this.file.getName());
                }
                if (this.forceOverwrite || !this.destFile.exists() || this.file.lastModified() - this.granularity > this.destFile.lastModified()) {
                    this.fileCopyMap.put(this.file.getAbsolutePath(), new String[]{this.destFile.getAbsolutePath()});
                } else {
                    this.log(this.file + " omitted as " + this.destFile + " is up to date.", 3);
                }
            } else {
                String string = "Warning: Could not find file " + this.file.getAbsolutePath() + " to copy.";
                if (!this.failonerror) {
                    this.log(string, 0);
                } else {
                    throw new BuildException(string);
                }
            }
        }
    }

    private void iterateOverBaseDirs(HashSet hashSet, HashMap hashMap, HashMap hashMap2) {
        for (File file : hashSet) {
            List list = (List)hashMap2.get(file);
            List list2 = (List)hashMap.get(file);
            String[] stringArray = new String[]{};
            if (list != null) {
                stringArray = list.toArray(stringArray);
            }
            String[] stringArray2 = new String[]{};
            if (list2 != null) {
                stringArray2 = list2.toArray(stringArray2);
            }
            this.scan(file == NULL_FILE_PLACEHOLDER ? null : file, this.destDir, stringArray, stringArray2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateAttributes() throws BuildException {
        if (this.file == null && this.rcs.size() == 0) {
            throw new BuildException("Specify at least one source--a file or a resource collection.");
        }
        if (this.destFile != null && this.destDir != null) {
            throw new BuildException("Only one of tofile and todir may be set.");
        }
        if (this.destFile == null && this.destDir == null) {
            throw new BuildException("One of tofile or todir must be set.");
        }
        if (this.file != null && this.file.isDirectory()) {
            throw new BuildException("Use a resource collection to copy directories.");
        }
        if (this.destFile != null && this.rcs.size() > 0) {
            if (this.rcs.size() > 1) {
                throw new BuildException("Cannot concatenate multiple files into a single file.");
            }
            ResourceCollection resourceCollection = (ResourceCollection)this.rcs.elementAt(0);
            if (!resourceCollection.isFilesystemOnly()) {
                throw new BuildException("Only FileSystem resources are supported when concatenating files.");
            }
            if (resourceCollection.size() == 0) {
                throw new BuildException("Cannot perform operation from directory to file.");
            }
            if (resourceCollection.size() != 1) throw new BuildException("Cannot concatenate multiple files into a single file.");
            FileResource fileResource = (FileResource)resourceCollection.iterator().next();
            if (this.file != null) throw new BuildException("Cannot concatenate multiple files into a single file.");
            this.file = fileResource.getFile();
            this.rcs.removeElementAt(0);
        }
        if (this.destFile == null) return;
        this.destDir = this.destFile.getParentFile();
    }

    protected void scan(File file, File file2, String[] stringArray, String[] stringArray2) {
        FileNameMapper fileNameMapper = this.getMapper();
        this.buildMap(file, file2, stringArray, fileNameMapper, this.fileCopyMap);
        if (this.includeEmpty) {
            this.buildMap(file, file2, stringArray2, fileNameMapper, this.dirCopyMap);
        }
    }

    protected Map scan(Resource[] resourceArray, File file) {
        return this.buildMap(resourceArray, file, this.getMapper());
    }

    protected void buildMap(File file, File file2, String[] stringArray, FileNameMapper fileNameMapper, Hashtable hashtable) {
        Object object;
        Object[] objectArray = null;
        if (this.forceOverwrite) {
            object = new Vector();
            for (int i = 0; i < stringArray.length; ++i) {
                if (fileNameMapper.mapFileName(stringArray[i]) == null) continue;
                ((Vector)object).addElement(stringArray[i]);
            }
            objectArray = new String[((Vector)object).size()];
            ((Vector)object).copyInto(objectArray);
        } else {
            object = new SourceFileScanner(this);
            objectArray = ((SourceFileScanner)object).restrict(stringArray, file, file2, fileNameMapper, this.granularity);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            File file3 = new File(file, (String)objectArray[i]);
            String[] stringArray2 = fileNameMapper.mapFileName((String)objectArray[i]);
            if (!this.enableMultipleMappings) {
                hashtable.put(file3.getAbsolutePath(), new String[]{new File(file2, stringArray2[0]).getAbsolutePath()});
                continue;
            }
            for (int j = 0; j < stringArray2.length; ++j) {
                stringArray2[j] = new File(file2, stringArray2[j]).getAbsolutePath();
            }
            hashtable.put(file3.getAbsolutePath(), stringArray2);
        }
    }

    protected Map buildMap(Resource[] resourceArray, final File file, FileNameMapper fileNameMapper) {
        HashMap<Object, String[]> hashMap = new HashMap<Object, String[]>();
        Object[] objectArray = null;
        if (this.forceOverwrite) {
            Vector<Resource> vector = new Vector<Resource>();
            for (int i = 0; i < resourceArray.length; ++i) {
                if (fileNameMapper.mapFileName(resourceArray[i].getName()) == null) continue;
                vector.addElement(resourceArray[i]);
            }
            objectArray = new Resource[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = ResourceUtils.selectOutOfDateSources((ProjectComponent)this, resourceArray, fileNameMapper, new ResourceFactory(){

                @Override
                public Resource getResource(String string) {
                    return new FileResource(file, string);
                }
            }, this.granularity);
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String[] stringArray = fileNameMapper.mapFileName(((Resource)objectArray[i]).getName());
            if (!this.enableMultipleMappings) {
                hashMap.put(objectArray[i], new String[]{new File(file, stringArray[0]).getAbsolutePath()});
                continue;
            }
            for (int j = 0; j < stringArray.length; ++j) {
                stringArray[j] = new File(file, stringArray[j]).getAbsolutePath();
            }
            hashMap.put(objectArray[i], stringArray);
        }
        return hashMap;
    }

    protected void doFileOperations() {
        Object object;
        int n;
        String[] stringArray;
        Enumeration<Object> enumeration;
        if (this.fileCopyMap.size() > 0) {
            this.log("Copying " + this.fileCopyMap.size() + " file" + (this.fileCopyMap.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            enumeration = this.fileCopyMap.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                stringArray = (String[])this.fileCopyMap.get(string);
                for (n = 0; n < stringArray.length; ++n) {
                    Object object2;
                    object = stringArray[n];
                    if (string.equals(object)) {
                        this.log("Skipping self-copy of " + string, this.verbosity);
                        continue;
                    }
                    try {
                        this.log("Copying " + string + " to " + (String)object, this.verbosity);
                        FilterSetCollection filterSetCollection = new FilterSetCollection();
                        if (this.filtering) {
                            filterSetCollection.addFilterSet(this.getProject().getGlobalFilterSet());
                        }
                        object2 = this.filterSets.elements();
                        while (object2.hasMoreElements()) {
                            filterSetCollection.addFilterSet((FilterSet)object2.nextElement());
                        }
                        this.fileUtils.copyFile(string, (String)object, filterSetCollection, this.filterChains, this.forceOverwrite, this.preserveLastModified, this.inputEncoding, this.outputEncoding, this.getProject());
                        continue;
                    }
                    catch (IOException iOException) {
                        object2 = "Failed to copy " + string + " to " + (String)object + " due to " + this.getDueTo(iOException);
                        File file = new File((String)object);
                        if (file.exists() && !file.delete()) {
                            object2 = (String)object2 + " and I couldn't delete the corrupt " + (String)object;
                        }
                        if (this.failonerror) {
                            throw new BuildException((String)object2, iOException, this.getLocation());
                        }
                        this.log((String)object2, 0);
                    }
                }
            }
        }
        if (this.includeEmpty) {
            enumeration = this.dirCopyMap.elements();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                stringArray = (String[])enumeration.nextElement();
                for (n = 0; n < stringArray.length; ++n) {
                    object = new File(stringArray[n]);
                    if (((File)object).exists()) continue;
                    if (!((File)object).mkdirs()) {
                        this.log("Unable to create directory " + ((File)object).getAbsolutePath(), 0);
                        continue;
                    }
                    ++n2;
                }
            }
            if (n2 > 0) {
                this.log("Copied " + this.dirCopyMap.size() + " empty director" + (this.dirCopyMap.size() == 1 ? "y" : "ies") + " to " + n2 + " empty director" + (n2 == 1 ? "y" : "ies") + " under " + this.destDir.getAbsolutePath());
            }
        }
    }

    protected void doResourceOperations(Map map) {
        if (map.size() > 0) {
            this.log("Copying " + map.size() + " resource" + (map.size() == 1 ? "" : "s") + " to " + this.destDir.getAbsolutePath());
            for (Resource resource : map.keySet()) {
                String[] stringArray = (String[])map.get(resource);
                for (int i = 0; i < stringArray.length; ++i) {
                    Object object;
                    String string = stringArray[i];
                    try {
                        this.log("Copying " + resource + " to " + string, this.verbosity);
                        FilterSetCollection filterSetCollection = new FilterSetCollection();
                        if (this.filtering) {
                            filterSetCollection.addFilterSet(this.getProject().getGlobalFilterSet());
                        }
                        object = this.filterSets.elements();
                        while (object.hasMoreElements()) {
                            filterSetCollection.addFilterSet((FilterSet)object.nextElement());
                        }
                        ResourceUtils.copyResource(resource, new FileResource(this.destDir, string), filterSetCollection, this.filterChains, this.forceOverwrite, this.preserveLastModified, this.inputEncoding, this.outputEncoding, this.getProject());
                        continue;
                    }
                    catch (IOException iOException) {
                        object = "Failed to copy " + resource + " to " + string + " due to " + this.getDueTo(iOException);
                        File file = new File(string);
                        if (file.exists() && !file.delete()) {
                            object = (String)object + " and I couldn't delete the corrupt " + string;
                        }
                        if (this.failonerror) {
                            throw new BuildException((String)object, iOException, this.getLocation());
                        }
                        this.log((String)object, 0);
                    }
                }
            }
        }
    }

    protected boolean supportsNonFileResources() {
        return this.getClass().equals(Copy.class);
    }

    private static void add(File file, String[] stringArray, Map map) {
        if (stringArray != null) {
            ArrayList<String> arrayList = (ArrayList<String>)map.get(file = Copy.getKeyFile(file));
            if (arrayList == null) {
                arrayList = new ArrayList<String>(stringArray.length);
                map.put(file, arrayList);
            }
            arrayList.addAll(Arrays.asList(stringArray));
        }
    }

    private static void add(File file, String string, Map map) {
        if (string != null) {
            Copy.add(file, new String[]{string}, map);
        }
    }

    private static File getKeyFile(File file) {
        return file == null ? NULL_FILE_PLACEHOLDER : file;
    }

    private FileNameMapper getMapper() {
        FileNameMapper fileNameMapper = null;
        fileNameMapper = this.mapperElement != null ? this.mapperElement.getImplementation() : (this.flatten ? new FlatFileNameMapper() : new IdentityMapper());
        return fileNameMapper;
    }

    private String getMessage(Exception exception) {
        return exception.getMessage() == null ? exception.toString() : exception.getMessage();
    }

    private String getDueTo(Exception exception) {
        boolean bl = exception.getClass() == IOException.class;
        StringBuffer stringBuffer = new StringBuffer();
        if (!bl || exception.getMessage() == null) {
            stringBuffer.append(exception.getClass().getName());
        }
        if (exception.getMessage() != null) {
            if (!bl) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(exception.getMessage());
        }
        if (exception.getClass().getName().indexOf("MalformedInput") != -1) {
            stringBuffer.append(LINE_SEPARATOR);
            stringBuffer.append("This is normally due to the input file containing invalid");
            stringBuffer.append(LINE_SEPARATOR);
            stringBuffer.append("bytes for the character encoding used : ");
            stringBuffer.append(this.inputEncoding == null ? this.fileUtils.getDefaultEncoding() : this.inputEncoding);
            stringBuffer.append(LINE_SEPARATOR);
        }
        return stringBuffer.toString();
    }
}

