/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.condition.Condition;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.types.resources.selectors.Type;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class Checksum
extends MatchingTask
implements Condition {
    private static final int NIBBLE = 4;
    private static final int WORD = 16;
    private static final int BUFFER_SIZE = 8192;
    private static final int BYTE_MASK = 255;
    private File file = null;
    private File todir;
    private String algorithm = "MD5";
    private String provider = null;
    private String fileext;
    private String property;
    private Map allDigests = new HashMap();
    private Map relativeFilePaths = new HashMap();
    private String totalproperty;
    private boolean forceOverwrite;
    private String verifyProperty;
    private FileUnion resources = null;
    private Hashtable includeFileMap = new Hashtable();
    private MessageDigest messageDigest;
    private boolean isCondition;
    private int readBufferSize = 8192;
    private MessageFormat format = FormatElement.getDefault().getFormat();

    public void setFile(File file) {
        this.file = file;
    }

    public void setTodir(File file) {
        this.todir = file;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public void setProvider(String string) {
        this.provider = string;
    }

    public void setFileext(String string) {
        this.fileext = string;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public void setTotalproperty(String string) {
        this.totalproperty = string;
    }

    public void setVerifyproperty(String string) {
        this.verifyProperty = string;
    }

    public void setForceOverwrite(boolean bl) {
        this.forceOverwrite = bl;
    }

    public void setReadBufferSize(int n) {
        this.readBufferSize = n;
    }

    public void setFormat(FormatElement formatElement) {
        this.format = formatElement.getFormat();
    }

    public void setPattern(String string) {
        this.format = new MessageFormat(string);
    }

    public void addFileset(FileSet fileSet) {
        this.add(fileSet);
    }

    public void add(ResourceCollection resourceCollection) {
        if (resourceCollection == null) {
            return;
        }
        this.resources = this.resources == null ? new FileUnion() : this.resources;
        this.resources.add(resourceCollection);
    }

    @Override
    public void execute() throws BuildException {
        this.isCondition = false;
        boolean bl = this.validateAndExecute();
        if (this.verifyProperty != null) {
            this.getProject().setNewProperty(this.verifyProperty, bl ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        }
    }

    @Override
    public boolean eval() throws BuildException {
        this.isCondition = true;
        return this.validateAndExecute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateAndExecute() throws BuildException {
        String string = this.fileext;
        if (this.file == null && (this.resources == null || this.resources.size() == 0)) {
            throw new BuildException("Specify at least one source - a file or a resource collection.");
        }
        if (this.resources != null && !this.resources.isFilesystemOnly()) {
            throw new BuildException("Can only calculate checksums for file-based resources.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Checksum cannot be generated for directories");
        }
        if (this.file != null && this.totalproperty != null) {
            throw new BuildException("File and Totalproperty cannot co-exist.");
        }
        if (this.property != null && this.fileext != null) {
            throw new BuildException("Property and FileExt cannot co-exist.");
        }
        if (this.property != null) {
            if (this.forceOverwrite) {
                throw new BuildException("ForceOverwrite cannot be used when Property is specified");
            }
            int n = 0;
            if (this.resources != null) {
                n += this.resources.size();
            }
            if (this.file != null) {
                ++n;
            }
            if (n > 1) {
                throw new BuildException("Multiple files cannot be used when Property is specified");
            }
        }
        if (this.verifyProperty != null) {
            this.isCondition = true;
        }
        if (this.verifyProperty != null && this.forceOverwrite) {
            throw new BuildException("VerifyProperty and ForceOverwrite cannot co-exist.");
        }
        if (this.isCondition && this.forceOverwrite) {
            throw new BuildException("ForceOverwrite cannot be used when conditions are being used.");
        }
        this.messageDigest = null;
        if (this.provider != null) {
            try {
                this.messageDigest = MessageDigest.getInstance(this.algorithm, this.provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new BuildException(noSuchAlgorithmException, this.getLocation());
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new BuildException(noSuchProviderException, this.getLocation());
            }
        }
        try {
            this.messageDigest = MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new BuildException(noSuchAlgorithmException, this.getLocation());
        }
        if (this.messageDigest == null) {
            throw new BuildException("Unable to create Message Digest", this.getLocation());
        }
        if (this.fileext == null) {
            this.fileext = "." + this.algorithm;
        } else if (this.fileext.trim().length() == 0) {
            throw new BuildException("File extension when specified must not be an empty string");
        }
        try {
            if (this.resources != null) {
                Iterator iterator = this.resources.iterator();
                while (iterator.hasNext()) {
                    FileResource fileResource = (FileResource)iterator.next();
                    File file = fileResource.getFile();
                    if (this.totalproperty != null || this.todir != null) {
                        this.relativeFilePaths.put(file, fileResource.getName().replace(File.separatorChar, '/'));
                    }
                    this.addToIncludeFileMap(file);
                }
            }
            if (this.file != null) {
                if (this.totalproperty != null || this.todir != null) {
                    this.relativeFilePaths.put(this.file, this.file.getName().replace(File.separatorChar, '/'));
                }
                this.addToIncludeFileMap(this.file);
            }
            boolean bl = this.generateChecksums();
            return bl;
        }
        finally {
            this.fileext = string;
            this.includeFileMap.clear();
        }
    }

    private void addToIncludeFileMap(File file) throws BuildException {
        if (file.exists()) {
            if (this.property == null) {
                File file2 = this.getChecksumFile(file);
                if (this.forceOverwrite || this.isCondition || file.lastModified() > file2.lastModified()) {
                    this.includeFileMap.put(file, file2);
                } else {
                    this.log(file + " omitted as " + file2 + " is up to date.", 3);
                    if (this.totalproperty != null) {
                        String string = this.readChecksum(file2);
                        byte[] byArray = Checksum.decodeHex(string.toCharArray());
                        this.allDigests.put(file, byArray);
                    }
                }
            } else {
                this.includeFileMap.put(file, this.property);
            }
        } else {
            String string = "Could not find file " + file.getAbsolutePath() + " to generate checksum for.";
            this.log(string);
            throw new BuildException(string, this.getLocation());
        }
    }

    private File getChecksumFile(File file) {
        File file2;
        Object object;
        if (this.todir != null) {
            object = (String)this.relativeFilePaths.get(file);
            if (object == null) {
                throw new BuildException("Internal error: relativeFilePaths could not match file" + file + "\n" + "please file a bug report on this");
            }
            file2 = new File(this.todir, (String)object).getParentFile();
            file2.mkdirs();
        } else {
            file2 = file.getParentFile();
        }
        object = new File(file2, file.getName() + this.fileext);
        return object;
    }

    private boolean generateChecksums() throws BuildException {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[this.readBufferSize];
        try {
            String string;
            Object object;
            Object object2;
            Object[] objectArray;
            Object object3 = this.includeFileMap.keys();
            while (object3.hasMoreElements()) {
                Object object4;
                this.messageDigest.reset();
                objectArray = (Object[])object3.nextElement();
                if (!this.isCondition) {
                    this.log("Calculating " + this.algorithm + " checksum for " + objectArray, 3);
                }
                fileInputStream = new FileInputStream((File)objectArray);
                DigestInputStream digestInputStream = new DigestInputStream(fileInputStream, this.messageDigest);
                while (digestInputStream.read(byArray, 0, this.readBufferSize) != -1) {
                }
                digestInputStream.close();
                fileInputStream.close();
                fileInputStream = null;
                object2 = this.messageDigest.digest();
                if (this.totalproperty != null) {
                    this.allDigests.put(objectArray, object2);
                }
                object = this.createDigestString((byte[])object2);
                string = this.includeFileMap.get(objectArray);
                if (string instanceof String) {
                    object4 = string;
                    if (this.isCondition) {
                        bl = bl && ((String)object).equals(this.property);
                        continue;
                    }
                    this.getProject().setNewProperty((String)object4, (String)object);
                    continue;
                }
                if (!(string instanceof File)) continue;
                if (this.isCondition) {
                    object4 = (File)((Object)string);
                    if (((File)object4).exists()) {
                        try {
                            String string2 = this.readChecksum((File)object4);
                            bl = bl && ((String)object).equals(string2);
                        }
                        catch (BuildException buildException) {
                            bl = false;
                        }
                        continue;
                    }
                    bl = false;
                    continue;
                }
                object4 = (File)((Object)string);
                fileOutputStream = new FileOutputStream((File)object4);
                fileOutputStream.write(this.format.format(new Object[]{object, objectArray.getName()}).getBytes());
                fileOutputStream.write(StringUtils.LINE_SEP.getBytes());
                fileOutputStream.close();
                fileOutputStream = null;
            }
            if (this.totalproperty != null) {
                object3 = this.allDigests.keySet();
                objectArray = object3.toArray();
                Arrays.sort(objectArray);
                this.messageDigest.reset();
                for (int i = 0; i < objectArray.length; ++i) {
                    object2 = (File)objectArray[i];
                    object = (byte[])this.allDigests.get(object2);
                    this.messageDigest.update((byte[])object);
                    string = (String)this.relativeFilePaths.get(object2);
                    this.messageDigest.update(string.getBytes());
                }
                String string3 = this.createDigestString(this.messageDigest.digest());
                this.getProject().setNewProperty(this.totalproperty, string3);
            }
        }
        catch (Exception exception) {
            throw new BuildException(exception, this.getLocation());
        }
        finally {
            FileUtils.close(fileInputStream);
            FileUtils.close(fileOutputStream);
        }
        return bl;
    }

    private String createDigestString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(0xFF & byArray[i]);
            if (string.length() < 2) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static byte[] decodeHex(char[] cArray) throws BuildException {
        int n = cArray.length;
        if ((n & 1) != 0) {
            throw new BuildException("odd number of characters.");
        }
        byte[] byArray = new byte[n >> 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            int n4 = Character.digit(cArray[n3++], 16) << 4;
            byArray[n2] = (byte)((n4 |= Character.digit(cArray[n3++], 16)) & 0xFF);
            ++n2;
        }
        return byArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readChecksum(File file) {
        String string;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            Object[] objectArray = this.format.parse(bufferedReader.readLine());
            if (objectArray == null || objectArray.length == 0 || objectArray[0] == null) {
                throw new BuildException("failed to find a checksum");
            }
            string = (String)objectArray[0];
        }
        catch (IOException iOException) {
            try {
                throw new BuildException("Couldn't read checksum file " + file, iOException);
                catch (ParseException parseException) {
                    throw new BuildException("Couldn't read checksum file " + file, parseException);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(bufferedReader);
                throw throwable;
            }
        }
        FileUtils.close(bufferedReader);
        return string;
    }

    public static class FormatElement
    extends EnumeratedAttribute {
        private static HashMap formatMap = new HashMap();
        private static final String CHECKSUM = "CHECKSUM";
        private static final String MD5SUM = "MD5SUM";
        private static final String SVF = "SVF";

        public static FormatElement getDefault() {
            FormatElement formatElement = new FormatElement();
            formatElement.setValue(CHECKSUM);
            return formatElement;
        }

        public MessageFormat getFormat() {
            return (MessageFormat)formatMap.get(this.getValue());
        }

        @Override
        public String[] getValues() {
            return new String[]{CHECKSUM, MD5SUM, SVF};
        }

        static {
            formatMap.put(CHECKSUM, new MessageFormat("{0}"));
            formatMap.put(MD5SUM, new MessageFormat("{0} *{1}"));
            formatMap.put(SVF, new MessageFormat("MD5 ({1}) = {0}"));
        }
    }

    private static class FileUnion
    extends Restrict {
        private Union u = new Union();

        FileUnion() {
            super.add(this.u);
            super.add(Type.FILE);
        }

        @Override
        public void add(ResourceCollection resourceCollection) {
            this.u.add(resourceCollection);
        }
    }
}

