/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Pack;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.bzip2.CBZip2OutputStream;

public class BZip2
extends Pack {
    @Override
    protected void pack() {
        CBZip2OutputStream cBZip2OutputStream = null;
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.zipFile));
            bufferedOutputStream.write(66);
            bufferedOutputStream.write(90);
            cBZip2OutputStream = new CBZip2OutputStream(bufferedOutputStream);
            this.zipResource(this.getSrcResource(), cBZip2OutputStream);
        }
        catch (IOException iOException) {
            try {
                String string = "Problem creating bzip2 " + iOException.getMessage();
                throw new BuildException(string, iOException, this.getLocation());
            }
            catch (Throwable throwable) {
                FileUtils.close(cBZip2OutputStream);
                throw throwable;
            }
        }
        FileUtils.close(cBZip2OutputStream);
    }

    @Override
    protected boolean supportsNonFileResources() {
        return this.getClass().equals(BZip2.class);
    }
}

