/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Unpack;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.bzip2.CBZip2InputStream;

public class BUnzip2
extends Unpack {
    private static final int BUFFER_SIZE = 8192;
    private static final String DEFAULT_EXTENSION = ".bz2";

    @Override
    protected String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected void extract() {
        if (this.source.lastModified() > this.dest.lastModified()) {
            this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
            FileOutputStream fileOutputStream = null;
            CBZip2InputStream cBZip2InputStream = null;
            InputStream inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.dest);
                inputStream = this.srcResource.getInputStream();
                bufferedInputStream = new BufferedInputStream(inputStream);
                int n = bufferedInputStream.read();
                if (n != 66) {
                    throw new BuildException("Invalid bz2 file.", this.getLocation());
                }
                n = bufferedInputStream.read();
                if (n != 90) {
                    throw new BuildException("Invalid bz2 file.", this.getLocation());
                }
                cBZip2InputStream = new CBZip2InputStream(bufferedInputStream);
                byte[] byArray = new byte[8192];
                int n2 = 0;
                do {
                    fileOutputStream.write(byArray, 0, n2);
                } while ((n2 = cBZip2InputStream.read(byArray, 0, byArray.length)) != -1);
            }
            catch (IOException iOException) {
                try {
                    String string = "Problem expanding bzip2 " + iOException.getMessage();
                    throw new BuildException(string, iOException, this.getLocation());
                }
                catch (Throwable throwable) {
                    FileUtils.close(bufferedInputStream);
                    FileUtils.close(inputStream);
                    FileUtils.close(fileOutputStream);
                    FileUtils.close(cBZip2InputStream);
                    throw throwable;
                }
            }
            FileUtils.close(bufferedInputStream);
            FileUtils.close(inputStream);
            FileUtils.close(fileOutputStream);
            FileUtils.close(cBZip2InputStream);
        }
    }

    @Override
    protected boolean supportsNonFileResources() {
        return this.getClass().equals(BUnzip2.class);
    }
}

