/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.AptExternalCompilerAdapter;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Apt
extends Javac {
    private boolean compile = true;
    private String factory;
    private Path factoryPath;
    private Vector options = new Vector();
    private File preprocessDir;
    public static final String EXECUTABLE_NAME = "apt";
    public static final String ERROR_IGNORING_COMPILER_OPTION = "Ignoring compiler attribute for the APT task, as it is fixed";
    public static final String ERROR_WRONG_JAVA_VERSION = "Apt task requires Java 1.5+";
    public static final String WARNING_IGNORING_FORK = "Apt only runs in its own JVM; fork=false option ignored";

    public Apt() {
        super.setCompiler(AptExternalCompilerAdapter.class.getName());
        super.setFork(true);
    }

    public String getAptExecutable() {
        return JavaEnvUtils.getJdkExecutable(EXECUTABLE_NAME);
    }

    @Override
    public void setCompiler(String string) {
        this.log(ERROR_IGNORING_COMPILER_OPTION, 1);
    }

    @Override
    public void setFork(boolean bl) {
        if (!bl) {
            this.log(WARNING_IGNORING_FORK, 1);
        }
    }

    @Override
    public String getCompiler() {
        return super.getCompiler();
    }

    public boolean isCompile() {
        return this.compile;
    }

    public void setCompile(boolean bl) {
        this.compile = bl;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String string) {
        this.factory = string;
    }

    public void setFactoryPathRef(Reference reference) {
        this.createFactoryPath().setRefid(reference);
    }

    public Path createFactoryPath() {
        if (this.factoryPath == null) {
            this.factoryPath = new Path(this.getProject());
        }
        return this.factoryPath.createPath();
    }

    public Path getFactoryPath() {
        return this.factoryPath;
    }

    public Option createOption() {
        Option option = new Option();
        this.options.add(option);
        return option;
    }

    public Vector getOptions() {
        return this.options;
    }

    public File getPreprocessDir() {
        return this.preprocessDir;
    }

    public void setPreprocessDir(File file) {
        this.preprocessDir = file;
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
    }

    public static final class Option {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }
    }
}

