/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Reference;

public class AntStructure
extends Task {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private File output;
    private StructurePrinter printer = new DTDPrinter();

    public void setOutput(File file) {
        this.output = file;
    }

    public void add(StructurePrinter structurePrinter) {
        this.printer = structurePrinter;
    }

    @Override
    public void execute() throws BuildException {
        if (this.output == null) {
            throw new BuildException("output attribute is required", this.getLocation());
        }
        PrintWriter printWriter = null;
        try {
            Object object;
            try {
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.output), "UTF8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                printWriter = new PrintWriter(new FileWriter(this.output));
            }
            this.printer.printHead(printWriter, this.getProject(), this.getProject().getTaskDefinitions(), this.getProject().getDataTypeDefinitions());
            this.printer.printTargetDecl(printWriter);
            Enumeration enumeration = this.getProject().getDataTypeDefinitions().keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                this.printer.printElementDecl(printWriter, this.getProject(), (String)object, (Class)this.getProject().getDataTypeDefinitions().get(object));
            }
            object = this.getProject().getTaskDefinitions().keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                this.printer.printElementDecl(printWriter, this.getProject(), string, (Class)this.getProject().getTaskDefinitions().get(string));
            }
            this.printer.printTail(printWriter);
        }
        catch (IOException iOException) {
            throw new BuildException("Error writing " + this.output.getAbsolutePath(), iOException, this.getLocation());
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    protected boolean isNmtoken(String string) {
        return DTDPrinter.isNmtoken(string);
    }

    protected boolean areNmtokens(String[] stringArray) {
        return DTDPrinter.areNmtokens(stringArray);
    }

    private static class DTDPrinter
    implements StructurePrinter {
        private static final String BOOLEAN = "%boolean;";
        private static final String TASKS = "%tasks;";
        private static final String TYPES = "%types;";
        private Hashtable visited = new Hashtable();

        private DTDPrinter() {
        }

        @Override
        public void printTail(PrintWriter printWriter) {
            this.visited.clear();
        }

        @Override
        public void printHead(PrintWriter printWriter, Project project, Hashtable hashtable, Hashtable hashtable2) {
            this.printHead(printWriter, hashtable.keys(), hashtable2.keys());
        }

        private void printHead(PrintWriter printWriter, Enumeration enumeration, Enumeration enumeration2) {
            String string;
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
            printWriter.println("<!ENTITY % boolean \"(true|false|on|off|yes|no)\">");
            printWriter.print("<!ENTITY % tasks \"");
            boolean bl = true;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!bl) {
                    printWriter.print(" | ");
                } else {
                    bl = false;
                }
                printWriter.print(string);
            }
            printWriter.println("\">");
            printWriter.print("<!ENTITY % types \"");
            bl = true;
            while (enumeration2.hasMoreElements()) {
                string = (String)enumeration2.nextElement();
                if (!bl) {
                    printWriter.print(" | ");
                } else {
                    bl = false;
                }
                printWriter.print(string);
            }
            printWriter.println("\">");
            printWriter.println("");
            printWriter.print("<!ELEMENT project (target | ");
            printWriter.print(TASKS);
            printWriter.print(" | ");
            printWriter.print(TYPES);
            printWriter.println(")*>");
            printWriter.println("<!ATTLIST project");
            printWriter.println("          name    CDATA #IMPLIED");
            printWriter.println("          default CDATA #IMPLIED");
            printWriter.println("          basedir CDATA #IMPLIED>");
            printWriter.println("");
        }

        @Override
        public void printTargetDecl(PrintWriter printWriter) {
            printWriter.print("<!ELEMENT target (");
            printWriter.print(TASKS);
            printWriter.print(" | ");
            printWriter.print(TYPES);
            printWriter.println(")*>");
            printWriter.println("");
            printWriter.println("<!ATTLIST target");
            printWriter.println("          id          ID    #IMPLIED");
            printWriter.println("          name        CDATA #REQUIRED");
            printWriter.println("          if          CDATA #IMPLIED");
            printWriter.println("          unless      CDATA #IMPLIED");
            printWriter.println("          depends     CDATA #IMPLIED");
            printWriter.println("          description CDATA #IMPLIED>");
            printWriter.println("");
        }

        @Override
        public void printElementDecl(PrintWriter printWriter, Project project, String string, Class clazz) {
            Object object;
            int n;
            int n2;
            if (this.visited.containsKey(string)) {
                return;
            }
            this.visited.put(string, "");
            IntrospectionHelper introspectionHelper = null;
            try {
                introspectionHelper = IntrospectionHelper.getHelper(project, clazz);
            }
            catch (Throwable throwable) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer("<!ELEMENT ");
            stringBuffer.append(string).append(" ");
            if (Reference.class.equals((Object)clazz)) {
                stringBuffer.append("EMPTY>").append(LINE_SEP);
                stringBuffer.append("<!ATTLIST ").append(string);
                stringBuffer.append(LINE_SEP).append("          id ID #IMPLIED");
                stringBuffer.append(LINE_SEP).append("          refid IDREF #IMPLIED");
                stringBuffer.append(">").append(LINE_SEP);
                printWriter.println(stringBuffer);
                return;
            }
            Vector<String> vector = new Vector<String>();
            if (introspectionHelper.supportsCharacters()) {
                vector.addElement("#PCDATA");
            }
            if (TaskContainer.class.isAssignableFrom(clazz)) {
                vector.addElement(TASKS);
            }
            Enumeration enumeration = introspectionHelper.getNestedElements();
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
            if (vector.isEmpty()) {
                stringBuffer.append("EMPTY");
            } else {
                stringBuffer.append("(");
                n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    if (n != 0) {
                        stringBuffer.append(" | ");
                    }
                    stringBuffer.append(vector.elementAt(n));
                }
                stringBuffer.append(")");
                if (n2 > 1 || !vector.elementAt(0).equals("#PCDATA")) {
                    stringBuffer.append("*");
                }
            }
            stringBuffer.append(">");
            printWriter.println(stringBuffer);
            stringBuffer = new StringBuffer("<!ATTLIST ");
            stringBuffer.append(string);
            stringBuffer.append(LINE_SEP).append("          id ID #IMPLIED");
            enumeration = introspectionHelper.getAttributes();
            while (enumeration.hasMoreElements()) {
                block33: {
                    String string2 = (String)enumeration.nextElement();
                    if ("id".equals(string2)) continue;
                    stringBuffer.append(LINE_SEP).append("          ").append(string2).append(" ");
                    Class clazz2 = introspectionHelper.getAttributeType(string2);
                    if (clazz2.equals(Boolean.class) || clazz2.equals(Boolean.TYPE)) {
                        stringBuffer.append(BOOLEAN).append(" ");
                    } else if (Reference.class.isAssignableFrom(clazz2)) {
                        stringBuffer.append("IDREF ");
                    } else if (EnumeratedAttribute.class.isAssignableFrom(clazz2)) {
                        try {
                            object = (EnumeratedAttribute)clazz2.newInstance();
                            String[] stringArray = object.getValues();
                            if (stringArray == null || stringArray.length == 0 || !DTDPrinter.areNmtokens(stringArray)) {
                                stringBuffer.append("CDATA ");
                                break block33;
                            }
                            stringBuffer.append("(");
                            for (int i = 0; i < stringArray.length; ++i) {
                                if (i != 0) {
                                    stringBuffer.append(" | ");
                                }
                                stringBuffer.append(stringArray[i]);
                            }
                            stringBuffer.append(") ");
                        }
                        catch (InstantiationException instantiationException) {
                            stringBuffer.append("CDATA ");
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            stringBuffer.append("CDATA ");
                        }
                    } else if (clazz2.getSuperclass() != null && clazz2.getSuperclass().getName().equals("java.lang.Enum")) {
                        try {
                            object = (Object[])clazz2.getMethod("values", null).invoke(null, (Object[])null);
                            if (((Object[])object).length == 0) {
                                stringBuffer.append("CDATA ");
                                break block33;
                            }
                            stringBuffer.append('(');
                            for (int i = 0; i < ((Object[])object).length; ++i) {
                                if (i != 0) {
                                    stringBuffer.append(" | ");
                                }
                                stringBuffer.append(clazz2.getMethod("name", null).invoke(object[i], (Object[])null));
                            }
                            stringBuffer.append(") ");
                        }
                        catch (Exception exception) {
                            stringBuffer.append("CDATA ");
                        }
                    } else {
                        stringBuffer.append("CDATA ");
                    }
                }
                stringBuffer.append("#IMPLIED");
            }
            stringBuffer.append(">").append(LINE_SEP);
            printWriter.println(stringBuffer);
            n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                object = (String)vector.elementAt(n);
                if ("#PCDATA".equals(object) || TASKS.equals(object) || TYPES.equals(object)) continue;
                this.printElementDecl(printWriter, project, (String)object, introspectionHelper.getElementType((String)object));
            }
        }

        public static final boolean isNmtoken(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '.' || c == '-' || c == '_' || c == ':') continue;
                return false;
            }
            return true;
        }

        public static final boolean areNmtokens(String[] stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (DTDPrinter.isNmtoken(stringArray[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static interface StructurePrinter {
        public void printHead(PrintWriter var1, Project var2, Hashtable var3, Hashtable var4);

        public void printTargetDecl(PrintWriter var1);

        public void printElementDecl(PrintWriter var1, Project var2, String var3, Class var4);

        public void printTail(PrintWriter var1);
    }
}

