/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.util.FileUtils;

public class Ant
extends Task {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private File dir = null;
    private String antFile = null;
    private String output = null;
    private boolean inheritAll = true;
    private boolean inheritRefs = false;
    private Vector properties = new Vector();
    private Vector references = new Vector();
    private Project newProject;
    private PrintStream out = null;
    private Vector propertySets = new Vector();
    private Vector targets = new Vector();
    private boolean targetAttributeSet = false;

    public Ant() {
    }

    public Ant(Task task) {
        this.bindToOwner(task);
    }

    public void setInheritAll(boolean bl) {
        this.inheritAll = bl;
    }

    public void setInheritRefs(boolean bl) {
        this.inheritRefs = bl;
    }

    @Override
    public void init() {
        this.newProject = this.getProject().createSubProject();
        this.newProject.setJavaVersionProperty();
    }

    private void reinit() {
        this.init();
    }

    private void initializeProject() {
        Object object;
        Object object2;
        this.newProject.setInputHandler(this.getProject().getInputHandler());
        Iterator iterator = this.getBuildListeners();
        while (iterator.hasNext()) {
            this.newProject.addBuildListener((BuildListener)iterator.next());
        }
        if (this.output != null) {
            object2 = null;
            object2 = this.dir != null ? FILE_UTILS.resolveFile(this.dir, this.output) : this.getProject().resolveFile(this.output);
            try {
                this.out = new PrintStream(new FileOutputStream((File)object2));
                object = new DefaultLogger();
                ((DefaultLogger)object).setMessageOutputLevel(2);
                ((DefaultLogger)object).setOutputPrintStream(this.out);
                ((DefaultLogger)object).setErrorPrintStream(this.out);
                this.newProject.addBuildListener((BuildListener)object);
            }
            catch (IOException iOException) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        this.getProject().copyUserProperties(this.newProject);
        if (!this.inheritAll) {
            this.newProject.initProperties();
        } else {
            this.addAlmostAll(this.getProject().getProperties());
        }
        object2 = this.propertySets.elements();
        while (object2.hasMoreElements()) {
            object = (PropertySet)object2.nextElement();
            this.addAlmostAll(((PropertySet)object).getProperties());
        }
    }

    @Override
    public void handleOutput(String string) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(string, false);
        } else {
            super.handleOutput(string);
        }
    }

    @Override
    public int handleInput(byte[] byArray, int n, int n2) throws IOException {
        if (this.newProject != null) {
            return this.newProject.demuxInput(byArray, n, n2);
        }
        return super.handleInput(byArray, n, n2);
    }

    @Override
    public void handleFlush(String string) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(string, false);
        } else {
            super.handleFlush(string);
        }
    }

    @Override
    public void handleErrorOutput(String string) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(string, true);
        } else {
            super.handleErrorOutput(string);
        }
    }

    @Override
    public void handleErrorFlush(String string) {
        if (this.newProject != null) {
            this.newProject.demuxFlush(string, true);
        } else {
            super.handleErrorFlush(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        block28: {
            Object object;
            Object object2;
            File file = this.dir;
            String string = this.antFile;
            Vector<String> vector = new Vector<String>(this.targets);
            try {
                Object object3;
                this.getNewProject();
                if (this.dir == null && this.inheritAll) {
                    this.dir = this.getProject().getBaseDir();
                }
                this.initializeProject();
                if (this.dir != null) {
                    this.newProject.setBaseDir(this.dir);
                    if (file != null) {
                        this.newProject.setInheritedProperty("basedir", this.dir.getAbsolutePath());
                    }
                } else {
                    this.dir = this.getProject().getBaseDir();
                }
                this.overrideProperties();
                if (this.antFile == null) {
                    this.antFile = "build.xml";
                }
                object2 = FILE_UTILS.resolveFile(this.dir, this.antFile);
                this.antFile = ((File)object2).getAbsolutePath();
                this.log("calling target(s) " + (vector.size() > 0 ? vector.toString() : "[default]") + " in build file " + this.antFile, 3);
                this.newProject.setUserProperty("ant.file", this.antFile);
                object = this.getProject().getProperty("ant.file");
                if (object != null && ((File)object2).equals(this.getProject().resolveFile((String)object)) && this.getOwningTarget() != null && this.getOwningTarget().getName().equals("")) {
                    if (this.getTaskName().equals("antcall")) {
                        throw new BuildException("antcall must not be used at the top level.");
                    }
                    throw new BuildException(this.getTaskName() + " task at the" + " top level must not invoke" + " its own build file.");
                }
                try {
                    ProjectHelper.configureProject(this.newProject, (File)object2);
                }
                catch (BuildException buildException) {
                    throw ProjectHelper.addLocationToBuildException(buildException, this.getLocation());
                }
                if (vector.size() == 0 && (object3 = this.newProject.getDefaultTarget()) != null) {
                    vector.add((String)object3);
                }
                if (this.newProject.getProperty("ant.file").equals(this.getProject().getProperty("ant.file")) && this.getOwningTarget() != null) {
                    boolean bl;
                    Target target;
                    object3 = this.getOwningTarget().getName();
                    if (vector.contains(object3)) {
                        throw new BuildException(this.getTaskName() + " task calling " + "its own parent target.");
                    }
                    Iterator iterator = vector.iterator();
                    for (bl = false; !bl && iterator.hasNext(); bl |= (target = (Target)this.getProject().getTargets().get(iterator.next())) != null && target.dependsOn((String)object3)) {
                    }
                    if (bl) {
                        throw new BuildException(this.getTaskName() + " task calling a target" + " that depends on" + " its parent target '" + (String)object3 + "'.");
                    }
                }
                this.addReferences();
                if (vector.size() <= 0 || vector.size() == 1 && "".equals(vector.get(0))) break block28;
                object3 = null;
                try {
                    this.log("Entering " + this.antFile + "...", 3);
                    this.newProject.fireSubBuildStarted();
                    this.newProject.executeTargets(vector);
                }
                catch (BuildException buildException) {
                    object3 = ProjectHelper.addLocationToBuildException(buildException, this.getLocation());
                    throw object3;
                }
                finally {
                    this.log("Exiting " + this.antFile + ".", 3);
                    this.newProject.fireSubBuildFinished((Throwable)object3);
                }
            }
            finally {
                this.newProject = null;
                object2 = this.properties.elements();
                while (object2.hasMoreElements()) {
                    object = (Property)object2.nextElement();
                    ((ProjectComponent)object).setProject(null);
                }
                if (this.output != null && this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (Exception exception) {}
                }
                this.dir = file;
                this.antFile = string;
            }
        }
    }

    private void overrideProperties() throws BuildException {
        Property property;
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = this.properties.size() - 1; i >= 0; --i) {
            property = (Property)this.properties.get(i);
            if (property.getName() == null || property.getName().equals("")) continue;
            if (hashSet.contains(property.getName())) {
                this.properties.remove(i);
                continue;
            }
            hashSet.add(property.getName());
        }
        Enumeration enumeration = this.properties.elements();
        while (enumeration.hasMoreElements()) {
            property = (Property)enumeration.nextElement();
            property.setProject(this.newProject);
            property.execute();
        }
        this.getProject().copyInheritedProperties(this.newProject);
    }

    private void addReferences() throws BuildException {
        Object object;
        Enumeration<Object> enumeration;
        Hashtable hashtable = (Hashtable)this.getProject().getReferences().clone();
        Hashtable hashtable2 = this.newProject.getReferences();
        if (this.references.size() > 0) {
            enumeration = this.references.elements();
            while (enumeration.hasMoreElements()) {
                object = (Reference)enumeration.nextElement();
                String string = ((org.apache.tools.ant.types.Reference)object).getRefId();
                if (string == null) {
                    throw new BuildException("the refid attribute is required for reference elements");
                }
                if (!hashtable.containsKey(string)) {
                    this.log("Parent project doesn't contain any reference '" + string + "'", 1);
                    continue;
                }
                hashtable.remove(string);
                String string2 = ((Reference)object).getToRefid();
                if (string2 == null) {
                    string2 = string;
                }
                this.copyReference(string, string2);
            }
        }
        if (this.inheritRefs) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (hashtable2.containsKey(object)) continue;
                this.copyReference((String)object, (String)object);
                this.newProject.inheritIDReferences(this.getProject());
            }
        }
    }

    private void copyReference(String string, String string2) {
        Method method;
        Object object = this.getProject().getReference(string);
        if (object == null) {
            this.log("No object referenced by " + string + ". Can't copy to " + string2, 1);
            return;
        }
        Class<?> clazz = object.getClass();
        Object object2 = object;
        try {
            method = clazz.getMethod("clone", new Class[0]);
            if (method != null) {
                object2 = method.invoke(object, new Object[0]);
                this.log("Adding clone of reference " + string, 4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object2 instanceof ProjectComponent) {
            ((ProjectComponent)object2).setProject(this.newProject);
        } else {
            try {
                method = clazz.getMethod("setProject", Project.class);
                if (method != null) {
                    method.invoke(object2, this.newProject);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                String string3 = "Error setting new project instance for reference with id " + string;
                throw new BuildException(string3, exception, this.getLocation());
            }
        }
        this.newProject.addReference(string2, object2);
    }

    private void addAlmostAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            if ("basedir".equals(string) || "ant.file".equals(string)) continue;
            String string2 = hashtable.get(string).toString();
            if (this.newProject.getProperty(string) != null) continue;
            this.newProject.setNewProperty(string, string2);
        }
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setAntfile(String string) {
        this.antFile = string;
    }

    public void setTarget(String string) {
        if (string.equals("")) {
            throw new BuildException("target attribute must not be empty");
        }
        this.targets.add(string);
        this.targetAttributeSet = true;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public Property createProperty() {
        Property property = new Property(true, this.getProject());
        property.setProject(this.getNewProject());
        property.setTaskName("property");
        this.properties.addElement(property);
        return property;
    }

    public void addReference(Reference reference) {
        this.references.addElement(reference);
    }

    public void addConfiguredTarget(TargetElement targetElement) {
        if (this.targetAttributeSet) {
            throw new BuildException("nested target is incompatible with the target attribute");
        }
        String string = targetElement.getName();
        if (string.equals("")) {
            throw new BuildException("target name must not be empty");
        }
        this.targets.add(string);
    }

    public void addPropertyset(PropertySet propertySet) {
        this.propertySets.addElement(propertySet);
    }

    protected Project getNewProject() {
        if (this.newProject == null) {
            this.reinit();
        }
        return this.newProject;
    }

    private Iterator getBuildListeners() {
        return this.getProject().getBuildListeners().iterator();
    }

    public static class TargetElement {
        private String name;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Reference
    extends org.apache.tools.ant.types.Reference {
        private String targetid = null;

        public void setToRefid(String string) {
            this.targetid = string;
        }

        public String getToRefid() {
            return this.targetid;
        }
    }
}

