/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JAXPUtils;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.XMLReaderAdapter;

public class ProjectHelperImpl
extends ProjectHelper {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private Parser parser;
    private Project project;
    private File buildFile;
    private File buildFileParent;
    private Locator locator;
    private Target implicitTarget = new Target();

    public ProjectHelperImpl() {
        this.implicitTarget.setName("");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void parse(Project project, Object object) throws BuildException {
        if (!(object instanceof File)) {
            throw new BuildException("Only File source supported by default plugin");
        }
        File file = (File)object;
        FileInputStream fileInputStream = null;
        InputSource inputSource = null;
        this.project = project;
        this.buildFile = new File(file.getAbsolutePath());
        this.buildFileParent = new File(this.buildFile.getParent());
        try {
            try {
                this.parser = JAXPUtils.getParser();
            }
            catch (BuildException buildException) {
                this.parser = new XMLReaderAdapter(JAXPUtils.getXMLReader());
            }
            String string = FILE_UTILS.toURI(file.getAbsolutePath());
            fileInputStream = new FileInputStream(file);
            inputSource = new InputSource(fileInputStream);
            inputSource.setSystemId(string);
            project.log("parsing buildfile " + file + " with URI = " + string, 3);
            RootHandler rootHandler = new RootHandler(this);
            this.parser.setDocumentHandler(rootHandler);
            this.parser.setEntityResolver(rootHandler);
            this.parser.setErrorHandler(rootHandler);
            this.parser.setDTDHandler(rootHandler);
            this.parser.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            try {
                Location location = new Location(sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
                Exception exception = sAXParseException.getException();
                if (!(exception instanceof BuildException)) throw new BuildException(sAXParseException.getMessage(), exception, location);
                BuildException buildException = (BuildException)exception;
                if (buildException.getLocation() != Location.UNKNOWN_LOCATION) throw buildException;
                buildException.setLocation(location);
                throw buildException;
                catch (SAXException sAXException) {
                    Exception exception2 = sAXException.getException();
                    if (!(exception2 instanceof BuildException)) throw new BuildException(sAXException.getMessage(), exception2);
                    throw (BuildException)exception2;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new BuildException(fileNotFoundException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new BuildException("Encoding of project file is invalid.", unsupportedEncodingException);
                }
                catch (IOException iOException) {
                    throw new BuildException("Error reading project file: " + iOException.getMessage(), iOException);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(fileInputStream);
                throw throwable;
            }
        }
        FileUtils.close(fileInputStream);
    }

    private static void handleElement(ProjectHelperImpl projectHelperImpl, DocumentHandler documentHandler, Target target, String string, AttributeList attributeList) throws SAXParseException {
        if (string.equals("description")) {
            new DescriptionHandler(projectHelperImpl, documentHandler);
        } else if (projectHelperImpl.project.getDataTypeDefinitions().get(string) != null) {
            new DataTypeHandler(projectHelperImpl, documentHandler, target).init(string, attributeList);
        } else {
            new TaskHandler(projectHelperImpl, documentHandler, target, null, target).init(string, attributeList);
        }
    }

    private void configureId(Object object, AttributeList attributeList) {
        String string = attributeList.getValue("id");
        if (string != null) {
            this.project.addReference(string, object);
        }
    }

    static class DataTypeHandler
    extends AbstractHandler {
        private Target target;
        private Object element;
        private RuntimeConfigurable wrapper = null;

        public DataTypeHandler(ProjectHelperImpl projectHelperImpl, DocumentHandler documentHandler, Target target) {
            super(projectHelperImpl, documentHandler);
            this.target = target;
        }

        public void init(String string, AttributeList attributeList) throws SAXParseException {
            try {
                this.element = this.helperImpl.project.createDataType(string);
                if (this.element == null) {
                    throw new BuildException("Unknown data type " + string);
                }
                this.wrapper = new RuntimeConfigurable(this.element, string);
                this.wrapper.setAttributes(attributeList);
                this.target.addDataType(this.wrapper);
            }
            catch (BuildException buildException) {
                throw new SAXParseException(buildException.getMessage(), this.helperImpl.locator, buildException);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.wrapper.addText(cArray, n, n2);
        }

        @Override
        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            new NestedElementHandler(this.helperImpl, this, this.element, this.wrapper, this.target).init(string, attributeList);
        }
    }

    static class NestedElementHandler
    extends AbstractHandler {
        private Object parent;
        private Object child;
        private RuntimeConfigurable parentWrapper;
        private RuntimeConfigurable childWrapper = null;
        private Target target;

        public NestedElementHandler(ProjectHelperImpl projectHelperImpl, DocumentHandler documentHandler, Object object, RuntimeConfigurable runtimeConfigurable, Target target) {
            super(projectHelperImpl, documentHandler);
            this.parent = object instanceof TypeAdapter ? ((TypeAdapter)object).getProxy() : object;
            this.parentWrapper = runtimeConfigurable;
            this.target = target;
        }

        public void init(String string, AttributeList attributeList) throws SAXParseException {
            Class<?> clazz = this.parent.getClass();
            IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(this.helperImpl.project, clazz);
            try {
                String string2 = string.toLowerCase(Locale.US);
                if (this.parent instanceof UnknownElement) {
                    UnknownElement unknownElement = new UnknownElement(string2);
                    unknownElement.setProject(this.helperImpl.project);
                    ((UnknownElement)this.parent).addChild(unknownElement);
                    this.child = unknownElement;
                } else {
                    this.child = introspectionHelper.createElement(this.helperImpl.project, this.parent, string2);
                }
                this.helperImpl.configureId(this.child, attributeList);
                this.childWrapper = new RuntimeConfigurable(this.child, string);
                this.childWrapper.setAttributes(attributeList);
                this.parentWrapper.addChild(this.childWrapper);
            }
            catch (BuildException buildException) {
                throw new SAXParseException(buildException.getMessage(), this.helperImpl.locator, buildException);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.childWrapper.addText(cArray, n, n2);
        }

        @Override
        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            if (this.child instanceof TaskContainer) {
                new TaskHandler(this.helperImpl, this, (TaskContainer)this.child, this.childWrapper, this.target).init(string, attributeList);
            } else {
                new NestedElementHandler(this.helperImpl, this, this.child, this.childWrapper, this.target).init(string, attributeList);
            }
        }
    }

    static class TaskHandler
    extends AbstractHandler {
        private Target target;
        private TaskContainer container;
        private Task task;
        private RuntimeConfigurable parentWrapper;
        private RuntimeConfigurable wrapper = null;

        public TaskHandler(ProjectHelperImpl projectHelperImpl, DocumentHandler documentHandler, TaskContainer taskContainer, RuntimeConfigurable runtimeConfigurable, Target target) {
            super(projectHelperImpl, documentHandler);
            this.container = taskContainer;
            this.parentWrapper = runtimeConfigurable;
            this.target = target;
        }

        public void init(String string, AttributeList attributeList) throws SAXParseException {
            try {
                this.task = this.helperImpl.project.createTask(string);
            }
            catch (BuildException buildException) {
                // empty catch block
            }
            if (this.task == null) {
                this.task = new UnknownElement(string);
                this.task.setProject(this.helperImpl.project);
                this.task.setTaskName(string);
            }
            this.task.setLocation(new Location(this.helperImpl.locator));
            this.helperImpl.configureId(this.task, attributeList);
            this.task.setOwningTarget(this.target);
            this.container.addTask(this.task);
            this.task.init();
            this.wrapper = this.task.getRuntimeConfigurableWrapper();
            this.wrapper.setAttributes(attributeList);
            if (this.parentWrapper != null) {
                this.parentWrapper.addChild(this.wrapper);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.wrapper.addText(cArray, n, n2);
        }

        @Override
        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            if (this.task instanceof TaskContainer) {
                new TaskHandler(this.helperImpl, this, (TaskContainer)((Object)this.task), this.wrapper, this.target).init(string, attributeList);
            } else {
                new NestedElementHandler(this.helperImpl, this, this.task, this.wrapper, this.target).init(string, attributeList);
            }
        }
    }

    static class DescriptionHandler
    extends AbstractHandler {
        public DescriptionHandler(ProjectHelperImpl projectHelperImpl, DocumentHandler documentHandler) {
            super(projectHelperImpl, documentHandler);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            String string = new String(cArray, n, n2);
            String string2 = this.helperImpl.project.getDescription();
            if (string2 == null) {
                this.helperImpl.project.setDescription(string);
            } else {
                this.helperImpl.project.setDescription(string2 + string);
            }
        }
    }

    static class TargetHandler
    extends AbstractHandler {
        private Target target;

        public TargetHandler(ProjectHelperImpl projectHelperImpl, DocumentHandler documentHandler) {
            super(projectHelperImpl, documentHandler);
        }

        public void init(String string, AttributeList attributeList) throws SAXParseException {
            String string2 = null;
            String string3 = "";
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            for (int i = 0; i < attributeList.getLength(); ++i) {
                String string8 = attributeList.getName(i);
                String string9 = attributeList.getValue(i);
                if (string8.equals("name")) {
                    string2 = string9;
                    if (!string2.equals("")) continue;
                    throw new BuildException("name attribute must not be empty", new Location(this.helperImpl.locator));
                }
                if (string8.equals("depends")) {
                    string3 = string9;
                    continue;
                }
                if (string8.equals("if")) {
                    string4 = string9;
                    continue;
                }
                if (string8.equals("unless")) {
                    string5 = string9;
                    continue;
                }
                if (string8.equals("id")) {
                    string6 = string9;
                    continue;
                }
                if (string8.equals("description")) {
                    string7 = string9;
                    continue;
                }
                throw new SAXParseException("Unexpected attribute \"" + string8 + "\"", this.helperImpl.locator);
            }
            if (string2 == null) {
                throw new SAXParseException("target element appears without a name attribute", this.helperImpl.locator);
            }
            this.target = new Target();
            this.target.addDependency("");
            this.target.setName(string2);
            this.target.setIf(string4);
            this.target.setUnless(string5);
            this.target.setDescription(string7);
            this.helperImpl.project.addTarget(string2, this.target);
            if (string6 != null && !string6.equals("")) {
                this.helperImpl.project.addReference(string6, this.target);
            }
            if (string3.length() > 0) {
                this.target.setDepends(string3);
            }
        }

        @Override
        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            ProjectHelperImpl.handleElement(this.helperImpl, this, this.target, string, attributeList);
        }
    }

    static class ProjectHandler
    extends AbstractHandler {
        public ProjectHandler(ProjectHelperImpl projectHelperImpl, DocumentHandler documentHandler) {
            super(projectHelperImpl, documentHandler);
        }

        public void init(String string, AttributeList attributeList) throws SAXParseException {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            for (int i = 0; i < attributeList.getLength(); ++i) {
                String string6 = attributeList.getName(i);
                String string7 = attributeList.getValue(i);
                if (string6.equals("default")) {
                    string2 = string7;
                    continue;
                }
                if (string6.equals("name")) {
                    string3 = string7;
                    continue;
                }
                if (string6.equals("id")) {
                    string4 = string7;
                    continue;
                }
                if (string6.equals("basedir")) {
                    string5 = string7;
                    continue;
                }
                throw new SAXParseException("Unexpected attribute \"" + attributeList.getName(i) + "\"", this.helperImpl.locator);
            }
            if (string2 == null || string2.equals("")) {
                throw new BuildException("The default attribute is required");
            }
            this.helperImpl.project.setDefaultTarget(string2);
            if (string3 != null) {
                this.helperImpl.project.setName(string3);
                this.helperImpl.project.addReference(string3, this.helperImpl.project);
            }
            if (string4 != null) {
                this.helperImpl.project.addReference(string4, this.helperImpl.project);
            }
            if (this.helperImpl.project.getProperty("basedir") != null) {
                this.helperImpl.project.setBasedir(this.helperImpl.project.getProperty("basedir"));
            } else if (string5 == null) {
                this.helperImpl.project.setBasedir(this.helperImpl.buildFileParent.getAbsolutePath());
            } else if (new File(string5).isAbsolute()) {
                this.helperImpl.project.setBasedir(string5);
            } else {
                File file = FILE_UTILS.resolveFile(this.helperImpl.buildFileParent, string5);
                this.helperImpl.project.setBaseDir(file);
            }
            this.helperImpl.project.addTarget("", this.helperImpl.implicitTarget);
        }

        @Override
        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            if (string.equals("target")) {
                this.handleTarget(string, attributeList);
            } else {
                ProjectHelperImpl.handleElement(this.helperImpl, this, this.helperImpl.implicitTarget, string, attributeList);
            }
        }

        private void handleTarget(String string, AttributeList attributeList) throws SAXParseException {
            new TargetHandler(this.helperImpl, this).init(string, attributeList);
        }
    }

    static class RootHandler
    extends HandlerBase {
        ProjectHelperImpl helperImpl;

        public RootHandler(ProjectHelperImpl projectHelperImpl) {
            this.helperImpl = projectHelperImpl;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            this.helperImpl.project.log("resolving systemId: " + string2, 3);
            if (string2.startsWith("file:")) {
                String string3 = FILE_UTILS.fromURI(string2);
                File file = new File(string3);
                if (!file.isAbsolute()) {
                    file = FILE_UTILS.resolveFile(this.helperImpl.buildFileParent, string3);
                    this.helperImpl.project.log("Warning: '" + string2 + "' in " + this.helperImpl.buildFile + " should be expressed simply as '" + string3.replace('\\', '/') + "' for compliance with other XML tools", 1);
                }
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(file));
                    inputSource.setSystemId(FILE_UTILS.toURI(file.getAbsolutePath()));
                    return inputSource;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.helperImpl.project.log(file.getAbsolutePath() + " could not be found", 1);
                }
            }
            return null;
        }

        @Override
        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            if (!string.equals("project")) {
                throw new SAXParseException("Config file is not of expected XML type", this.helperImpl.locator);
            }
            new ProjectHandler(this.helperImpl, this).init(string, attributeList);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.helperImpl.locator = locator;
        }
    }

    static class AbstractHandler
    extends HandlerBase {
        protected DocumentHandler parentHandler;
        ProjectHelperImpl helperImpl;

        public AbstractHandler(ProjectHelperImpl projectHelperImpl, DocumentHandler documentHandler) {
            this.parentHandler = documentHandler;
            this.helperImpl = projectHelperImpl;
            projectHelperImpl.parser.setDocumentHandler(this);
        }

        @Override
        public void startElement(String string, AttributeList attributeList) throws SAXParseException {
            throw new SAXParseException("Unexpected element \"" + string + "\"", this.helperImpl.locator);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXParseException {
            String string = new String(cArray, n, n2).trim();
            if (string.length() > 0) {
                throw new SAXParseException("Unexpected text \"" + string + "\"", this.helperImpl.locator);
            }
        }

        @Override
        public void endElement(String string) throws SAXException {
            this.helperImpl.parser.setDocumentHandler(this.parentHandler);
        }
    }
}

