/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JAXPUtils;
import org.apache.tools.ant.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ProjectHelper2
extends ProjectHelper {
    public static final String REFID_TARGETS = "ant.targets";
    private static AntHandler elementHandler = new ElementHandler();
    private static AntHandler targetHandler = new TargetHandler();
    private static AntHandler mainHandler = new MainHandler();
    private static AntHandler projectHandler = new ProjectHandler();
    private static final String REFID_CONTEXT = "ant.parsing.context";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();

    public UnknownElement parseUnknownElement(Project project, URL uRL) throws BuildException {
        Target target = new Target();
        target.setProject(project);
        AntXMLContext antXMLContext = new AntXMLContext(project);
        antXMLContext.addTarget(target);
        antXMLContext.setImplicitTarget(target);
        this.parse(antXMLContext.getProject(), uRL, new RootHandler(antXMLContext, elementHandler));
        Task[] taskArray = target.getTasks();
        if (taskArray.length != 1) {
            throw new BuildException("No tasks defined");
        }
        return (UnknownElement)taskArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(Project project, Object object) throws BuildException {
        this.getImportStack().addElement(object);
        AntXMLContext antXMLContext = null;
        antXMLContext = (AntXMLContext)project.getReference(REFID_CONTEXT);
        if (antXMLContext == null) {
            antXMLContext = new AntXMLContext(project);
            project.addReference(REFID_CONTEXT, antXMLContext);
            project.addReference(REFID_TARGETS, antXMLContext.getTargets());
        }
        if (this.getImportStack().size() > 1) {
            antXMLContext.setIgnoreProjectTag(true);
            Target target = antXMLContext.getCurrentTarget();
            Target target2 = antXMLContext.getImplicitTarget();
            Map map = antXMLContext.getCurrentTargets();
            try {
                Target target3 = new Target();
                target3.setProject(project);
                target3.setName("");
                antXMLContext.setCurrentTarget(target3);
                antXMLContext.setCurrentTargets(new HashMap());
                antXMLContext.setImplicitTarget(target3);
                this.parse(project, object, new RootHandler(antXMLContext, mainHandler));
                target3.execute();
            }
            finally {
                antXMLContext.setCurrentTarget(target);
                antXMLContext.setImplicitTarget(target2);
                antXMLContext.setCurrentTargets(map);
            }
        } else {
            antXMLContext.setCurrentTargets(new HashMap());
            this.parse(project, object, new RootHandler(antXMLContext, mainHandler));
            antXMLContext.getImplicitTarget().execute();
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(Project project, Object object, RootHandler rootHandler) throws BuildException {
        AntXMLContext antXMLContext = rootHandler.context;
        File file = null;
        URL uRL = null;
        String string = null;
        if (object instanceof File) {
            file = (File)object;
            file = FILE_UTILS.normalize(file.getAbsolutePath());
            antXMLContext.setBuildFile(file);
            string = file.toString();
        } else {
            if (!(object instanceof URL)) throw new BuildException("Source " + object.getClass().getName() + " not supported by this plugin");
            uRL = (URL)object;
            string = uRL.toString();
        }
        InputStream inputStream = null;
        InputSource inputSource = null;
        try {
            XMLReader xMLReader = JAXPUtils.getNamespaceXMLReader();
            String string2 = null;
            if (file != null) {
                string2 = FILE_UTILS.toURI(file.getAbsolutePath());
                inputStream = new FileInputStream(file);
            } else {
                inputStream = uRL.openStream();
                string2 = uRL.toString();
            }
            inputSource = new InputSource(inputStream);
            if (string2 != null) {
                inputSource.setSystemId(string2);
            }
            project.log("parsing buildfile " + string + " with URI = " + string2, 3);
            RootHandler rootHandler2 = rootHandler;
            xMLReader.setContentHandler(rootHandler2);
            xMLReader.setEntityResolver(rootHandler2);
            xMLReader.setErrorHandler(rootHandler2);
            xMLReader.setDTDHandler(rootHandler2);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            try {
                Exception exception;
                Location location = new Location(sAXParseException.getSystemId(), sAXParseException.getLineNumber(), sAXParseException.getColumnNumber());
                Exception exception2 = sAXParseException.getException();
                if (exception2 instanceof BuildException) {
                    BuildException buildException = (BuildException)exception2;
                    if (buildException.getLocation() != Location.UNKNOWN_LOCATION) throw buildException;
                    buildException.setLocation(location);
                    throw buildException;
                }
                String string3 = sAXParseException.getMessage();
                if (exception2 == null) {
                    exception = sAXParseException;
                    throw new BuildException(string3, exception, location);
                }
                exception = exception2;
                throw new BuildException(string3, exception, location);
                catch (SAXException sAXException) {
                    Exception exception3;
                    Exception exception4 = sAXException.getException();
                    if (exception4 instanceof BuildException) {
                        throw (BuildException)exception4;
                    }
                    String string4 = sAXException.getMessage();
                    if (exception4 == null) {
                        exception3 = sAXException;
                        throw new BuildException(string4, exception3);
                    }
                    exception3 = exception4;
                    throw new BuildException(string4, exception3);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new BuildException(fileNotFoundException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new BuildException("Encoding of project file " + string + " is invalid.", unsupportedEncodingException);
                }
                catch (IOException iOException) {
                    throw new BuildException("Error reading project file " + string + ": " + iOException.getMessage(), iOException);
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(inputStream);
                throw throwable;
            }
        }
        FileUtils.close(inputStream);
    }

    protected static AntHandler getMainHandler() {
        return mainHandler;
    }

    protected static void setMainHandler(AntHandler antHandler) {
        mainHandler = antHandler;
    }

    protected static AntHandler getProjectHandler() {
        return projectHandler;
    }

    protected static void setProjectHandler(AntHandler antHandler) {
        projectHandler = antHandler;
    }

    protected static AntHandler getTargetHandler() {
        return targetHandler;
    }

    protected static void setTargetHandler(AntHandler antHandler) {
        targetHandler = antHandler;
    }

    protected static AntHandler getElementHandler() {
        return elementHandler;
    }

    protected static void setElementHandler(AntHandler antHandler) {
        elementHandler = antHandler;
    }

    public static class ElementHandler
    extends AntHandler {
        @Override
        public void onStartElement(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            RuntimeConfigurable runtimeConfigurable = antXMLContext.currentWrapper();
            Object object = null;
            if (runtimeConfigurable != null) {
                object = runtimeConfigurable.getProxy();
            }
            UnknownElement unknownElement = new UnknownElement(string2);
            unknownElement.setProject(antXMLContext.getProject());
            unknownElement.setNamespace(string);
            unknownElement.setQName(string3);
            unknownElement.setTaskType(ProjectHelper.genComponentName(unknownElement.getNamespace(), string2));
            unknownElement.setTaskName(string3);
            Location location = new Location(antXMLContext.getLocator().getSystemId(), antXMLContext.getLocator().getLineNumber(), antXMLContext.getLocator().getColumnNumber());
            unknownElement.setLocation(location);
            unknownElement.setOwningTarget(antXMLContext.getCurrentTarget());
            if (object != null) {
                ((UnknownElement)object).addChild(unknownElement);
            } else {
                antXMLContext.getCurrentTarget().addTask(unknownElement);
            }
            antXMLContext.configureId(unknownElement, attributes);
            RuntimeConfigurable runtimeConfigurable2 = new RuntimeConfigurable(unknownElement, unknownElement.getTaskName());
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getLocalName(i);
                String string5 = attributes.getURI(i);
                if (string5 != null && !string5.equals("") && !string5.equals(string)) {
                    string4 = string5 + ":" + attributes.getQName(i);
                }
                String string6 = attributes.getValue(i);
                if ("ant-type".equals(string4) || "antlib:org.apache.tools.ant".equals(string5) && "ant-type".equals(attributes.getLocalName(i))) {
                    antXMLContext.getProject().log("WARNING: the ant-type mechanism has been deprecated" + StringUtils.LINE_SEP + "         and" + " will not be available in Ant 1.8.0 or higher", 1);
                    string4 = "ant-type";
                    int n = string6.indexOf(":");
                    if (n >= 0) {
                        String string7 = string6.substring(0, n);
                        String string8 = antXMLContext.getPrefixMapping(string7);
                        if (string8 == null) {
                            throw new BuildException("Unable to find XML NS prefix \"" + string7 + "\"");
                        }
                        string6 = ProjectHelper.genComponentName(string8, string6.substring(n + 1));
                    }
                }
                runtimeConfigurable2.setAttribute(string4, string6);
            }
            if (runtimeConfigurable != null) {
                runtimeConfigurable.addChild(runtimeConfigurable2);
            }
            antXMLContext.pushWrapper(runtimeConfigurable2);
        }

        @Override
        public void characters(char[] cArray, int n, int n2, AntXMLContext antXMLContext) throws SAXParseException {
            RuntimeConfigurable runtimeConfigurable = antXMLContext.currentWrapper();
            runtimeConfigurable.addText(cArray, n, n2);
        }

        @Override
        public AntHandler onStartChild(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            return elementHandler;
        }

        @Override
        public void onEndElement(String string, String string2, AntXMLContext antXMLContext) {
            antXMLContext.popWrapper();
        }
    }

    public static class TargetHandler
    extends AntHandler {
        @Override
        public void onStartElement(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            Object object;
            String string4;
            Object object2 = null;
            String string5 = "";
            Project project = antXMLContext.getProject();
            Target target = new Target();
            target.setProject(project);
            target.setLocation(new Location(antXMLContext.getLocator()));
            antXMLContext.addTarget(target);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string6 = attributes.getURI(i);
                if (string6 != null && !string6.equals("") && !string6.equals(string)) continue;
                string4 = attributes.getLocalName(i);
                object = attributes.getValue(i);
                if (string4.equals("name")) {
                    object2 = object;
                    if (!"".equals(object2)) continue;
                    throw new BuildException("name attribute must not be empty");
                }
                if (string4.equals("depends")) {
                    string5 = object;
                    continue;
                }
                if (string4.equals("if")) {
                    target.setIf((String)object);
                    continue;
                }
                if (string4.equals("unless")) {
                    target.setUnless((String)object);
                    continue;
                }
                if (string4.equals("id")) {
                    if (object == null || ((String)object).equals("")) continue;
                    antXMLContext.getProject().addReference((String)object, target);
                    continue;
                }
                if (string4.equals("description")) {
                    target.setDescription((String)object);
                    continue;
                }
                throw new SAXParseException("Unexpected attribute \"" + string4 + "\"", antXMLContext.getLocator());
            }
            if (object2 == null) {
                throw new SAXParseException("target element appears without a name attribute", antXMLContext.getLocator());
            }
            if (antXMLContext.getCurrentTargets().get(object2) != null) {
                throw new BuildException("Duplicate target '" + object2 + "'", target.getLocation());
            }
            Hashtable hashtable = project.getTargets();
            boolean bl = false;
            if (hashtable.containsKey(object2)) {
                project.log("Already defined in main or a previous import, ignore " + (String)object2, 3);
            } else {
                target.setName((String)object2);
                antXMLContext.getCurrentTargets().put(object2, target);
                project.addOrReplaceTarget((String)object2, target);
                bl = true;
            }
            if (string5.length() > 0) {
                target.setDepends(string5);
            }
            if (antXMLContext.isIgnoringProjectTag() && antXMLContext.getCurrentProjectName() != null && antXMLContext.getCurrentProjectName().length() != 0) {
                string4 = antXMLContext.getCurrentProjectName() + "." + (String)object2;
                object = bl ? new Target(target) : target;
                ((Target)object).setName(string4);
                antXMLContext.getCurrentTargets().put(string4, object);
                project.addOrReplaceTarget(string4, (Target)object);
            }
        }

        @Override
        public AntHandler onStartChild(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            return elementHandler;
        }

        @Override
        public void onEndElement(String string, String string2, AntXMLContext antXMLContext) {
            antXMLContext.setCurrentTarget(antXMLContext.getImplicitTarget());
        }
    }

    public static class ProjectHandler
    extends AntHandler {
        @Override
        public void onStartElement(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            Object object;
            String string4;
            String string5 = null;
            boolean bl = false;
            Project project = antXMLContext.getProject();
            antXMLContext.getImplicitTarget().setLocation(new Location(antXMLContext.getLocator()));
            for (int i = 0; i < attributes.getLength(); ++i) {
                string4 = attributes.getURI(i);
                if (string4 != null && !string4.equals("") && !string4.equals(string)) continue;
                object = attributes.getLocalName(i);
                String string6 = attributes.getValue(i);
                if (((String)object).equals("default")) {
                    if (string6 == null || string6.equals("") || antXMLContext.isIgnoringProjectTag()) continue;
                    project.setDefault(string6);
                    continue;
                }
                if (((String)object).equals("name")) {
                    if (string6 == null) continue;
                    antXMLContext.setCurrentProjectName(string6);
                    bl = true;
                    if (antXMLContext.isIgnoringProjectTag()) continue;
                    project.setName(string6);
                    project.addReference(string6, project);
                    continue;
                }
                if (((String)object).equals("id")) {
                    if (string6 == null || antXMLContext.isIgnoringProjectTag()) continue;
                    project.addReference(string6, project);
                    continue;
                }
                if (((String)object).equals("basedir")) {
                    if (antXMLContext.isIgnoringProjectTag()) continue;
                    string5 = string6;
                    continue;
                }
                throw new SAXParseException("Unexpected attribute \"" + attributes.getQName(i) + "\"", antXMLContext.getLocator());
            }
            String string7 = "ant.file." + antXMLContext.getCurrentProjectName();
            string4 = project.getProperty(string7);
            if (string4 != null && bl) {
                object = new File(string4);
                if (antXMLContext.isIgnoringProjectTag() && !((File)object).equals(antXMLContext.getBuildFile())) {
                    project.log("Duplicated project name in import. Project " + antXMLContext.getCurrentProjectName() + " defined first in " + string4 + " and again in " + antXMLContext.getBuildFile(), 1);
                }
            }
            if (antXMLContext.getBuildFile() != null && bl) {
                project.setUserProperty("ant.file." + antXMLContext.getCurrentProjectName(), antXMLContext.getBuildFile().toString());
            }
            if (antXMLContext.isIgnoringProjectTag()) {
                return;
            }
            if (project.getProperty("basedir") != null) {
                project.setBasedir(project.getProperty("basedir"));
            } else if (string5 == null) {
                project.setBasedir(antXMLContext.getBuildFileParent().getAbsolutePath());
            } else if (new File(string5).isAbsolute()) {
                project.setBasedir(string5);
            } else {
                project.setBaseDir(FILE_UTILS.resolveFile(antXMLContext.getBuildFileParent(), string5));
            }
            project.addTarget("", antXMLContext.getImplicitTarget());
            antXMLContext.setCurrentTarget(antXMLContext.getImplicitTarget());
        }

        @Override
        public AntHandler onStartChild(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            return string2.equals("target") && (string.equals("") || string.equals("antlib:org.apache.tools.ant")) ? targetHandler : elementHandler;
        }
    }

    public static class MainHandler
    extends AntHandler {
        @Override
        public AntHandler onStartChild(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            if (string2.equals("project") && (string.equals("") || string.equals("antlib:org.apache.tools.ant"))) {
                return projectHandler;
            }
            if (string2.equals(string3)) {
                throw new SAXParseException("Unexpected element \"{" + string + "}" + string2 + "\" {" + "antlib:org.apache.tools.ant" + "}" + string2, antXMLContext.getLocator());
            }
            throw new SAXParseException("Unexpected element \"" + string3 + "\" " + string2, antXMLContext.getLocator());
        }
    }

    public static class RootHandler
    extends DefaultHandler {
        private Stack antHandlers = new Stack();
        private AntHandler currentHandler = null;
        private AntXMLContext context;

        public RootHandler(AntXMLContext antXMLContext, AntHandler antHandler) {
            this.currentHandler = antHandler;
            this.antHandlers.push(this.currentHandler);
            this.context = antXMLContext;
        }

        public AntHandler getCurrentAntHandler() {
            return this.currentHandler;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            this.context.getProject().log("resolving systemId: " + string2, 3);
            if (string2.startsWith("file:")) {
                String string3 = FILE_UTILS.fromURI(string2);
                File file = new File(string3);
                if (!file.isAbsolute()) {
                    file = FILE_UTILS.resolveFile(this.context.getBuildFileParent(), string3);
                    this.context.getProject().log("Warning: '" + string2 + "' in " + this.context.getBuildFile() + " should be expressed simply as '" + string3.replace('\\', '/') + "' for compliance with other XML tools", 1);
                }
                this.context.getProject().log("file=" + file, 4);
                try {
                    InputSource inputSource = new InputSource(new FileInputStream(file));
                    inputSource.setSystemId(FILE_UTILS.toURI(file.getAbsolutePath()));
                    return inputSource;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.context.getProject().log(file.getAbsolutePath() + " could not be found", 1);
                }
            }
            this.context.getProject().log("could not resolve systemId", 4);
            return null;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXParseException {
            AntHandler antHandler = this.currentHandler.onStartChild(string, string2, string3, attributes, this.context);
            this.antHandlers.push(this.currentHandler);
            this.currentHandler = antHandler;
            this.currentHandler.onStartElement(string, string2, string3, attributes, this.context);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.context.setLocator(locator);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            AntHandler antHandler;
            this.currentHandler.onEndElement(string, string2, this.context);
            this.currentHandler = antHandler = (AntHandler)this.antHandlers.pop();
            if (this.currentHandler != null) {
                this.currentHandler.onEndChild(string, string2, string3, this.context);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXParseException {
            this.currentHandler.characters(cArray, n, n2, this.context);
        }

        @Override
        public void startPrefixMapping(String string, String string2) {
            this.context.startPrefixMapping(string, string2);
        }

        @Override
        public void endPrefixMapping(String string) {
            this.context.endPrefixMapping(string);
        }
    }

    public static class AntHandler {
        public void onStartElement(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
        }

        public AntHandler onStartChild(String string, String string2, String string3, Attributes attributes, AntXMLContext antXMLContext) throws SAXParseException {
            throw new SAXParseException("Unexpected element \"" + string3 + " \"", antXMLContext.getLocator());
        }

        public void onEndChild(String string, String string2, String string3, AntXMLContext antXMLContext) throws SAXParseException {
        }

        public void onEndElement(String string, String string2, AntXMLContext antXMLContext) {
        }

        public void characters(char[] cArray, int n, int n2, AntXMLContext antXMLContext) throws SAXParseException {
            String string = new String(cArray, n, n2).trim();
            if (string.length() > 0) {
                throw new SAXParseException("Unexpected text \"" + string + "\"", antXMLContext.getLocator());
            }
        }

        protected void checkNamespace(String string) {
        }
    }
}

