/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters.util;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.BaseFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.AntFilterReader;
import org.apache.tools.ant.types.FilterChain;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Parameterizable;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public final class ChainReaderHelper {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    public Reader primaryReader;
    public int bufferSize = 8192;
    public Vector filterChains = new Vector();
    private Project project = null;

    public void setPrimaryReader(Reader reader) {
        this.primaryReader = reader;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public void setFilterChains(Vector vector) {
        this.filterChains = vector;
    }

    public Reader getAssembledReader() throws BuildException {
        Vector vector;
        int n;
        if (this.primaryReader == null) {
            throw new BuildException("primaryReader must not be null.");
        }
        Reader reader = this.primaryReader;
        int n2 = this.filterChains.size();
        Vector vector2 = new Vector();
        for (n = 0; n < n2; ++n) {
            FilterChain filterChain = (FilterChain)this.filterChains.elementAt(n);
            vector = filterChain.getFilterReaders();
            int n3 = vector.size();
            for (int i = 0; i < n3; ++i) {
                vector2.addElement(vector.elementAt(i));
            }
        }
        n = vector2.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                vector = vector2.elementAt(i);
                if (vector instanceof AntFilterReader) {
                    AntFilterReader antFilterReader = (AntFilterReader)vector2.elementAt(i);
                    String string = antFilterReader.getClassName();
                    Path path = antFilterReader.getClasspath();
                    Project project = antFilterReader.getProject();
                    if (string == null) continue;
                    try {
                        Object[] objectArray;
                        int n4;
                        Constructor<?>[] constructorArray;
                        Class<?> clazz = null;
                        if (path == null) {
                            clazz = Class.forName(string);
                        } else {
                            constructorArray = project.createClassLoader(path);
                            clazz = Class.forName(string, true, (ClassLoader)constructorArray);
                        }
                        if (clazz == null) continue;
                        if (!FilterReader.class.isAssignableFrom(clazz)) {
                            throw new BuildException(string + " does not extend java.io.FilterReader");
                        }
                        constructorArray = clazz.getConstructors();
                        boolean bl = false;
                        for (n4 = 0; n4 < constructorArray.length; ++n4) {
                            objectArray = constructorArray[n4].getParameterTypes();
                            if (objectArray.length != 1 || !((Class)objectArray[0]).isAssignableFrom(Reader.class)) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            throw new BuildException(string + " does not define a public constructor" + " that takes in a Reader as its " + "single argument.");
                        }
                        objectArray = new Reader[]{reader};
                        reader = (Reader)constructorArray[n4].newInstance(objectArray);
                        this.setProjectOnObject(reader);
                        if (!Parameterizable.class.isAssignableFrom(clazz)) continue;
                        Parameter[] parameterArray = antFilterReader.getParams();
                        ((Parameterizable)((Object)reader)).setParameters(parameterArray);
                        continue;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new BuildException(classNotFoundException);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new BuildException(instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new BuildException(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new BuildException(invocationTargetException);
                    }
                }
                if (!(vector instanceof ChainableReader)) continue;
                this.setProjectOnObject(vector);
                reader = ((ChainableReader)((Object)vector)).chain(reader);
                this.setProjectOnObject(reader);
            }
        }
        return reader;
    }

    private void setProjectOnObject(Object object) {
        if (this.project == null) {
            return;
        }
        if (object instanceof BaseFilterReader) {
            ((BaseFilterReader)object).setProject(this.project);
            return;
        }
        this.project.setProjectReference(object);
    }

    public String readFully(Reader reader) throws IOException {
        return FileUtils.readFully(reader, this.bufferSize);
    }
}

