/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.filters.BaseFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.types.Substitution;
import org.apache.tools.ant.util.LineTokenizer;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.ant.util.Tokenizer;
import org.apache.tools.ant.util.regexp.Regexp;

public class TokenFilter
extends BaseFilterReader
implements ChainableReader {
    private Vector filters = new Vector();
    private Tokenizer tokenizer = null;
    private String delimOutput = null;
    private String line = null;
    private int linePos = 0;

    public TokenFilter() {
    }

    public TokenFilter(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        if (this.tokenizer == null) {
            this.tokenizer = new LineTokenizer();
        }
        while (this.line == null || this.line.length() == 0) {
            this.line = this.tokenizer.getToken(this.in);
            if (this.line == null) {
                return -1;
            }
            Enumeration enumeration = this.filters.elements();
            while (enumeration.hasMoreElements()) {
                Filter filter = (Filter)enumeration.nextElement();
                this.line = filter.filter(this.line);
                if (this.line != null) continue;
                break;
            }
            this.linePos = 0;
            if (this.line == null || this.tokenizer.getPostToken().length() == 0) continue;
            if (this.delimOutput != null) {
                this.line = this.line + this.delimOutput;
                continue;
            }
            this.line = this.line + this.tokenizer.getPostToken();
        }
        char c = this.line.charAt(this.linePos);
        ++this.linePos;
        if (this.linePos == this.line.length()) {
            this.line = null;
        }
        return c;
    }

    @Override
    public final Reader chain(Reader reader) {
        TokenFilter tokenFilter = new TokenFilter(reader);
        tokenFilter.filters = this.filters;
        tokenFilter.tokenizer = this.tokenizer;
        tokenFilter.delimOutput = this.delimOutput;
        tokenFilter.setProject(this.getProject());
        return tokenFilter;
    }

    public void setDelimOutput(String string) {
        this.delimOutput = TokenFilter.resolveBackSlash(string);
    }

    public void addLineTokenizer(LineTokenizer lineTokenizer) {
        this.add(lineTokenizer);
    }

    public void addStringTokenizer(StringTokenizer stringTokenizer) {
        this.add(stringTokenizer);
    }

    public void addFileTokenizer(FileTokenizer fileTokenizer) {
        this.add(fileTokenizer);
    }

    public void add(Tokenizer tokenizer) {
        if (this.tokenizer != null) {
            throw new BuildException("Only one tokenizer allowed");
        }
        this.tokenizer = tokenizer;
    }

    public void addReplaceString(ReplaceString replaceString) {
        this.filters.addElement(replaceString);
    }

    public void addContainsString(ContainsString containsString) {
        this.filters.addElement(containsString);
    }

    public void addReplaceRegex(ReplaceRegex replaceRegex) {
        this.filters.addElement(replaceRegex);
    }

    public void addContainsRegex(ContainsRegex containsRegex) {
        this.filters.addElement(containsRegex);
    }

    public void addTrim(Trim trim) {
        this.filters.addElement(trim);
    }

    public void addIgnoreBlank(IgnoreBlank ignoreBlank) {
        this.filters.addElement(ignoreBlank);
    }

    public void addDeleteCharacters(DeleteCharacters deleteCharacters) {
        this.filters.addElement(deleteCharacters);
    }

    public void add(Filter filter) {
        this.filters.addElement(filter);
    }

    public static String resolveBackSlash(String string) {
        return StringUtils.resolveBackSlash(string);
    }

    public static int convertRegexOptions(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        if (string.indexOf(103) != -1) {
            n |= 0x10;
        }
        if (string.indexOf(105) != -1) {
            n |= 0x100;
        }
        if (string.indexOf(109) != -1) {
            n |= 0x1000;
        }
        if (string.indexOf(115) != -1) {
            n |= 0x10000;
        }
        return n;
    }

    public static class DeleteCharacters
    extends ProjectComponent
    implements Filter,
    ChainableReader {
        private String deleteChars = "";

        public void setChars(String string) {
            this.deleteChars = TokenFilter.resolveBackSlash(string);
        }

        @Override
        public String filter(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length());
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (this.isDeleteCharacter(c)) continue;
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }

        @Override
        public Reader chain(Reader reader) {
            return new BaseFilterReader(reader){

                @Override
                public int read() throws IOException {
                    int n;
                    do {
                        if ((n = this.in.read()) != -1) continue;
                        return n;
                    } while (DeleteCharacters.this.isDeleteCharacter((char)n));
                    return n;
                }
            };
        }

        private boolean isDeleteCharacter(char c) {
            for (int i = 0; i < this.deleteChars.length(); ++i) {
                if (this.deleteChars.charAt(i) != c) continue;
                return true;
            }
            return false;
        }
    }

    public static class IgnoreBlank
    extends ChainableReaderFilter {
        @Override
        public String filter(String string) {
            if (string.trim().length() == 0) {
                return null;
            }
            return string;
        }
    }

    public static class Trim
    extends ChainableReaderFilter {
        @Override
        public String filter(String string) {
            return string.trim();
        }
    }

    public static class ContainsRegex
    extends ChainableReaderFilter {
        private String from;
        private String to;
        private RegularExpression regularExpression;
        private Substitution substitution;
        private boolean initialized = false;
        private String flags = "";
        private int options;
        private Regexp regexp;

        public void setPattern(String string) {
            this.from = string;
        }

        public void setReplace(String string) {
            this.to = string;
        }

        public void setFlags(String string) {
            this.flags = string;
        }

        private void initialize() {
            if (this.initialized) {
                return;
            }
            this.options = TokenFilter.convertRegexOptions(this.flags);
            if (this.from == null) {
                throw new BuildException("Missing from in containsregex");
            }
            this.regularExpression = new RegularExpression();
            this.regularExpression.setPattern(this.from);
            this.regexp = this.regularExpression.getRegexp(this.getProject());
            if (this.to == null) {
                return;
            }
            this.substitution = new Substitution();
            this.substitution.setExpression(this.to);
        }

        @Override
        public String filter(String string) {
            this.initialize();
            if (!this.regexp.matches(string, this.options)) {
                return null;
            }
            if (this.substitution == null) {
                return string;
            }
            return this.regexp.substitute(string, this.substitution.getExpression(this.getProject()), this.options);
        }
    }

    public static class ReplaceRegex
    extends ChainableReaderFilter {
        private String from;
        private String to;
        private RegularExpression regularExpression;
        private Substitution substitution;
        private boolean initialized = false;
        private String flags = "";
        private int options;
        private Regexp regexp;

        public void setPattern(String string) {
            this.from = string;
        }

        public void setReplace(String string) {
            this.to = string;
        }

        public void setFlags(String string) {
            this.flags = string;
        }

        private void initialize() {
            if (this.initialized) {
                return;
            }
            this.options = TokenFilter.convertRegexOptions(this.flags);
            if (this.from == null) {
                throw new BuildException("Missing pattern in replaceregex");
            }
            this.regularExpression = new RegularExpression();
            this.regularExpression.setPattern(this.from);
            this.regexp = this.regularExpression.getRegexp(this.getProject());
            if (this.to == null) {
                this.to = "";
            }
            this.substitution = new Substitution();
            this.substitution.setExpression(this.to);
        }

        @Override
        public String filter(String string) {
            this.initialize();
            if (!this.regexp.matches(string, this.options)) {
                return string;
            }
            return this.regexp.substitute(string, this.substitution.getExpression(this.getProject()), this.options);
        }
    }

    public static class ContainsString
    extends ProjectComponent
    implements Filter {
        private String contains;

        public void setContains(String string) {
            this.contains = string;
        }

        @Override
        public String filter(String string) {
            if (this.contains == null) {
                throw new BuildException("Missing contains in containsstring");
            }
            if (string.indexOf(this.contains) > -1) {
                return string;
            }
            return null;
        }
    }

    public static class ReplaceString
    extends ChainableReaderFilter {
        private String from;
        private String to;

        public void setFrom(String string) {
            this.from = string;
        }

        public void setTo(String string) {
            this.to = string;
        }

        @Override
        public String filter(String string) {
            if (this.from == null) {
                throw new BuildException("Missing from in stringreplace");
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = string.indexOf(this.from);
            while (n2 >= 0) {
                if (n2 > n) {
                    stringBuffer.append(string.substring(n, n2));
                }
                if (this.to != null) {
                    stringBuffer.append(this.to);
                }
                n = n2 + this.from.length();
                n2 = string.indexOf(this.from, n);
            }
            if (string.length() > n) {
                stringBuffer.append(string.substring(n, string.length()));
            }
            return stringBuffer.toString();
        }
    }

    public static abstract class ChainableReaderFilter
    extends ProjectComponent
    implements ChainableReader,
    Filter {
        private boolean byLine = true;

        public void setByLine(boolean bl) {
            this.byLine = bl;
        }

        @Override
        public Reader chain(Reader reader) {
            TokenFilter tokenFilter = new TokenFilter(reader);
            if (!this.byLine) {
                tokenFilter.add(new FileTokenizer());
            }
            tokenFilter.add(this);
            return tokenFilter;
        }
    }

    public static class StringTokenizer
    extends org.apache.tools.ant.util.StringTokenizer {
    }

    public static class FileTokenizer
    extends org.apache.tools.ant.util.FileTokenizer {
    }

    public static interface Filter {
        public String filter(String var1);
    }
}

