/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class TabsToSpaces
extends BaseParamFilterReader
implements ChainableReader {
    private static final int DEFAULT_TAB_LENGTH = 8;
    private static final String TAB_LENGTH_KEY = "tablength";
    private int tabLength = 8;
    private int spacesRemaining = 0;

    public TabsToSpaces() {
    }

    public TabsToSpaces(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int n = -1;
        if (this.spacesRemaining > 0) {
            --this.spacesRemaining;
            n = 32;
        } else {
            n = this.in.read();
            if (n == 9) {
                this.spacesRemaining = this.tabLength - 1;
                n = 32;
            }
        }
        return n;
    }

    public void setTablength(int n) {
        this.tabLength = n;
    }

    private int getTablength() {
        return this.tabLength;
    }

    @Override
    public Reader chain(Reader reader) {
        TabsToSpaces tabsToSpaces = new TabsToSpaces(reader);
        tabsToSpaces.setTablength(this.getTablength());
        tabsToSpaces.setInitialized(true);
        return tabsToSpaces;
    }

    private void initialize() {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                if (parameterArray[i] == null || !TAB_LENGTH_KEY.equals(parameterArray[i].getName())) continue;
                this.tabLength = Integer.parseInt(parameterArray[i].getValue());
                break;
            }
        }
    }
}

