/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;

public final class StripLineComments
extends BaseParamFilterReader
implements ChainableReader {
    private static final String COMMENTS_KEY = "comment";
    private Vector comments = new Vector();
    private String line = null;

    public StripLineComments() {
    }

    public StripLineComments(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int n = -1;
        if (this.line != null) {
            n = this.line.charAt(0);
            this.line = this.line.length() == 1 ? null : this.line.substring(1);
        } else {
            this.line = this.readLine();
            int n2 = this.comments.size();
            while (this.line != null) {
                for (int i = 0; i < n2; ++i) {
                    String string = (String)this.comments.elementAt(i);
                    if (!this.line.startsWith(string)) continue;
                    this.line = null;
                    break;
                }
                if (this.line != null) break;
                this.line = this.readLine();
            }
            if (this.line != null) {
                return this.read();
            }
        }
        return n;
    }

    public void addConfiguredComment(Comment comment) {
        this.comments.addElement(comment.getValue());
    }

    private void setComments(Vector vector) {
        this.comments = vector;
    }

    private Vector getComments() {
        return this.comments;
    }

    @Override
    public Reader chain(Reader reader) {
        StripLineComments stripLineComments = new StripLineComments(reader);
        stripLineComments.setComments(this.getComments());
        stripLineComments.setInitialized(true);
        return stripLineComments;
    }

    private void initialize() {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                if (!COMMENTS_KEY.equals(parameterArray[i].getType())) continue;
                this.comments.addElement(parameterArray[i].getValue());
            }
        }
    }

    public static class Comment {
        private String value;

        public final void setValue(String string) {
            if (this.value != null) {
                throw new IllegalStateException("Comment value already set.");
            }
            this.value = string;
        }

        public final String getValue() {
            return this.value;
        }

        public void addText(String string) {
            this.setValue(string);
        }
    }
}

