/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.RegularExpression;
import org.apache.tools.ant.util.regexp.Regexp;

public final class LineContainsRegExp
extends BaseParamFilterReader
implements ChainableReader {
    private static final String REGEXP_KEY = "regexp";
    private static final String NEGATE_KEY = "negate";
    private Vector regexps = new Vector();
    private String line = null;
    private boolean negate = false;

    public LineContainsRegExp() {
    }

    public LineContainsRegExp(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        if (!this.getInitialized()) {
            this.initialize();
            this.setInitialized(true);
        }
        int n = -1;
        if (this.line != null) {
            n = this.line.charAt(0);
            this.line = this.line.length() == 1 ? null : this.line.substring(1);
        } else {
            int n2 = this.regexps.size();
            this.line = this.readLine();
            while (this.line != null) {
                boolean bl = true;
                for (int i = 0; bl && i < n2; ++i) {
                    RegularExpression regularExpression = (RegularExpression)this.regexps.elementAt(i);
                    Regexp regexp = regularExpression.getRegexp(this.getProject());
                    bl = regexp.matches(this.line);
                }
                if (bl ^ this.isNegated()) break;
                this.line = this.readLine();
            }
            if (this.line != null) {
                return this.read();
            }
        }
        return n;
    }

    public void addConfiguredRegexp(RegularExpression regularExpression) {
        this.regexps.addElement(regularExpression);
    }

    private void setRegexps(Vector vector) {
        this.regexps = vector;
    }

    private Vector getRegexps() {
        return this.regexps;
    }

    @Override
    public Reader chain(Reader reader) {
        LineContainsRegExp lineContainsRegExp = new LineContainsRegExp(reader);
        lineContainsRegExp.setRegexps(this.getRegexps());
        lineContainsRegExp.setNegate(this.isNegated());
        return lineContainsRegExp;
    }

    public void setNegate(boolean bl) {
        this.negate = bl;
    }

    public boolean isNegated() {
        return this.negate;
    }

    private void initialize() {
        Parameter[] parameterArray = this.getParameters();
        if (parameterArray != null) {
            for (int i = 0; i < parameterArray.length; ++i) {
                if (REGEXP_KEY.equals(parameterArray[i].getType())) {
                    String string = parameterArray[i].getValue();
                    RegularExpression regularExpression = new RegularExpression();
                    regularExpression.setPattern(string);
                    this.regexps.addElement(regularExpression);
                    continue;
                }
                if (!NEGATE_KEY.equals(parameterArray[i].getType())) continue;
                this.setNegate(Project.toBoolean(parameterArray[i].getValue()));
            }
        }
    }
}

