/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.filters.BaseParamFilterReader;
import org.apache.tools.ant.filters.ChainableReader;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.EnumeratedAttribute;

public final class FixCrLfFilter
extends BaseParamFilterReader
implements ChainableReader {
    private static final int DEFAULT_TAB_LENGTH = 8;
    private static final int MIN_TAB_LENGTH = 2;
    private static final int MAX_TAB_LENGTH = 80;
    private static final char CTRLZ = '\u001a';
    private int tabLength = 8;
    private CrLf eol;
    private AddAsisRemove ctrlz;
    private AddAsisRemove tabs = AddAsisRemove.access$000();
    private boolean javafiles = false;
    private boolean fixlast = true;
    private boolean initialized = false;

    public FixCrLfFilter() {
        if (Os.isFamily("mac") && !Os.isFamily("unix")) {
            this.ctrlz = AddAsisRemove.REMOVE;
            this.setEol(CrLf.MAC);
        } else if (Os.isFamily("dos")) {
            this.ctrlz = AddAsisRemove.ASIS;
            this.setEol(CrLf.DOS);
        } else {
            this.ctrlz = AddAsisRemove.REMOVE;
            this.setEol(CrLf.UNIX);
        }
    }

    public FixCrLfFilter(Reader reader) throws IOException {
        super(reader);
        if (Os.isFamily("mac") && !Os.isFamily("unix")) {
            this.ctrlz = AddAsisRemove.REMOVE;
            this.setEol(CrLf.MAC);
        } else if (Os.isFamily("dos")) {
            this.ctrlz = AddAsisRemove.ASIS;
            this.setEol(CrLf.DOS);
        } else {
            this.ctrlz = AddAsisRemove.REMOVE;
            this.setEol(CrLf.UNIX);
        }
    }

    @Override
    public Reader chain(Reader reader) {
        try {
            FixCrLfFilter fixCrLfFilter = new FixCrLfFilter(reader);
            fixCrLfFilter.setJavafiles(this.getJavafiles());
            fixCrLfFilter.setEol(this.getEol());
            fixCrLfFilter.setTab(this.getTab());
            fixCrLfFilter.setTablength(this.getTablength());
            fixCrLfFilter.setEof(this.getEof());
            fixCrLfFilter.setFixlast(this.getFixlast());
            fixCrLfFilter.initInternalFilters();
            return fixCrLfFilter;
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public AddAsisRemove getEof() {
        return this.ctrlz.newInstance();
    }

    public CrLf getEol() {
        return this.eol.newInstance();
    }

    public boolean getFixlast() {
        return this.fixlast;
    }

    public boolean getJavafiles() {
        return this.javafiles;
    }

    public AddAsisRemove getTab() {
        return this.tabs.newInstance();
    }

    public int getTablength() {
        return this.tabLength;
    }

    private static String calculateEolString(CrLf crLf) {
        if (crLf == CrLf.ASIS) {
            return System.getProperty("line.separator");
        }
        if (crLf == CrLf.CR || crLf == CrLf.MAC) {
            return "\r";
        }
        if (crLf == CrLf.CRLF || crLf == CrLf.DOS) {
            return "\r\n";
        }
        return "\n";
    }

    private void initInternalFilters() {
        this.in = this.ctrlz == AddAsisRemove.REMOVE ? new RemoveEofFilter(this.in) : this.in;
        this.in = new NormalizeEolFilter(this.in, FixCrLfFilter.calculateEolString(this.eol), this.getFixlast());
        if (this.tabs != AddAsisRemove.ASIS) {
            if (this.getJavafiles()) {
                this.in = new MaskJavaTabLiteralsFilter(this.in);
            }
            this.in = this.tabs == AddAsisRemove.ADD ? new AddTabFilter(this.in, this.getTablength()) : new RemoveTabFilter(this.in, this.getTablength());
        }
        this.in = this.ctrlz == AddAsisRemove.ADD ? new AddEofFilter(this.in) : this.in;
        this.initialized = true;
    }

    @Override
    public synchronized int read() throws IOException {
        if (!this.initialized) {
            this.initInternalFilters();
        }
        return this.in.read();
    }

    public void setEof(AddAsisRemove addAsisRemove) {
        this.ctrlz = addAsisRemove.resolve();
    }

    public void setEol(CrLf crLf) {
        this.eol = crLf.resolve();
    }

    public void setFixlast(boolean bl) {
        this.fixlast = bl;
    }

    public void setJavafiles(boolean bl) {
        this.javafiles = bl;
    }

    public void setTab(AddAsisRemove addAsisRemove) {
        this.tabs = addAsisRemove.resolve();
    }

    public void setTablength(int n) throws IOException {
        if (n < 2 || n > 80) {
            throw new IOException("tablength must be between 2 and 80");
        }
        this.tabLength = n;
    }

    public static class CrLf
    extends EnumeratedAttribute {
        private static final CrLf ASIS = CrLf.newInstance("asis");
        private static final CrLf CR = CrLf.newInstance("cr");
        private static final CrLf CRLF = CrLf.newInstance("crlf");
        private static final CrLf DOS = CrLf.newInstance("dos");
        private static final CrLf LF = CrLf.newInstance("lf");
        private static final CrLf MAC = CrLf.newInstance("mac");
        private static final CrLf UNIX = CrLf.newInstance("unix");

        @Override
        public String[] getValues() {
            return new String[]{"asis", "cr", "lf", "crlf", "mac", "unix", "dos"};
        }

        public boolean equals(Object object) {
            return object instanceof CrLf && this.getIndex() == ((CrLf)object).getIndex();
        }

        public int hashCode() {
            return this.getIndex();
        }

        CrLf resolve() {
            if (this.equals(ASIS)) {
                return ASIS;
            }
            if (this.equals(CR) || this.equals(MAC)) {
                return CR;
            }
            if (this.equals(CRLF) || this.equals(DOS)) {
                return CRLF;
            }
            if (this.equals(LF) || this.equals(UNIX)) {
                return LF;
            }
            throw new IllegalStateException("No replacement for " + this);
        }

        private CrLf newInstance() {
            return CrLf.newInstance(this.getValue());
        }

        public static CrLf newInstance(String string) {
            CrLf crLf = new CrLf();
            crLf.setValue(string);
            return crLf;
        }
    }

    public static class AddAsisRemove
    extends EnumeratedAttribute {
        private static final AddAsisRemove ASIS = AddAsisRemove.newInstance("asis");
        private static final AddAsisRemove ADD = AddAsisRemove.newInstance("add");
        private static final AddAsisRemove REMOVE = AddAsisRemove.newInstance("remove");

        @Override
        public String[] getValues() {
            return new String[]{"add", "asis", "remove"};
        }

        public boolean equals(Object object) {
            return object instanceof AddAsisRemove && this.getIndex() == ((AddAsisRemove)object).getIndex();
        }

        public int hashCode() {
            return this.getIndex();
        }

        AddAsisRemove resolve() throws IllegalStateException {
            if (this.equals(ASIS)) {
                return ASIS;
            }
            if (this.equals(ADD)) {
                return ADD;
            }
            if (this.equals(REMOVE)) {
                return REMOVE;
            }
            throw new IllegalStateException("No replacement for " + this);
        }

        private AddAsisRemove newInstance() {
            return AddAsisRemove.newInstance(this.getValue());
        }

        public static AddAsisRemove newInstance(String string) {
            AddAsisRemove addAsisRemove = new AddAsisRemove();
            addAsisRemove.setValue(string);
            return addAsisRemove;
        }
    }

    private static class RemoveTabFilter
    extends SimpleFilterReader {
        private int columnNumber = 0;
        private int tabLength = 0;

        public RemoveTabFilter(Reader reader, int n) {
            super(reader);
            this.tabLength = n;
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            switch (n) {
                case 10: 
                case 13: {
                    this.columnNumber = 0;
                    break;
                }
                case 9: {
                    int n2;
                    if (!this.editsBlocked()) {
                        for (n2 = this.tabLength - this.columnNumber % this.tabLength; n2 > 1; --n2) {
                            this.push(' ');
                        }
                        n = 32;
                    }
                    this.columnNumber += n2;
                    break;
                }
                default: {
                    ++this.columnNumber;
                }
            }
            return n;
        }
    }

    private static class AddTabFilter
    extends SimpleFilterReader {
        private int columnNumber = 0;
        private int tabLength = 0;

        public AddTabFilter(Reader reader, int n) {
            super(reader);
            this.tabLength = n;
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            block0 : switch (n) {
                case 10: 
                case 13: {
                    this.columnNumber = 0;
                    break;
                }
                case 32: {
                    ++this.columnNumber;
                    if (this.editsBlocked()) break;
                    int n2 = (this.columnNumber + this.tabLength - 1) / this.tabLength * this.tabLength;
                    int n3 = 1;
                    int n4 = 0;
                    block13: while ((n = super.read()) != -1) {
                        switch (n) {
                            case 32: {
                                if (++this.columnNumber == n2) {
                                    ++n4;
                                    n3 = 0;
                                    n2 += this.tabLength;
                                    continue block13;
                                }
                                ++n3;
                                continue block13;
                            }
                            case 9: {
                                this.columnNumber = n2;
                                ++n4;
                                n3 = 0;
                                n2 += this.tabLength;
                                continue block13;
                            }
                        }
                        this.push(n);
                        break;
                    }
                    while (n3-- > 0) {
                        this.push(' ');
                        --this.columnNumber;
                    }
                    while (n4-- > 0) {
                        this.push('\t');
                        this.columnNumber -= this.tabLength;
                    }
                    n = super.read();
                    switch (n) {
                        case 32: {
                            ++this.columnNumber;
                            break block0;
                        }
                        case 9: {
                            this.columnNumber += this.tabLength;
                            break block0;
                        }
                    }
                    break;
                }
                case 9: {
                    this.columnNumber = (this.columnNumber + this.tabLength - 1) / this.tabLength * this.tabLength;
                    break;
                }
                default: {
                    ++this.columnNumber;
                }
            }
            return n;
        }
    }

    private static class RemoveEofFilter
    extends SimpleFilterReader {
        private int lookAhead = -1;

        public RemoveEofFilter(Reader reader) {
            super(reader);
            try {
                this.lookAhead = reader.read();
            }
            catch (IOException iOException) {
                this.lookAhead = -1;
            }
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (n == -1 && this.lookAhead == 26) {
                return -1;
            }
            int n2 = this.lookAhead;
            this.lookAhead = n;
            return n2;
        }
    }

    private static class AddEofFilter
    extends SimpleFilterReader {
        private int lastChar = -1;

        public AddEofFilter(Reader reader) {
            super(reader);
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (n == -1) {
                if (this.lastChar != 26) {
                    this.lastChar = 26;
                    return this.lastChar;
                }
            } else {
                this.lastChar = n;
            }
            return n;
        }
    }

    private static class NormalizeEolFilter
    extends SimpleFilterReader {
        private boolean previousWasEOL;
        private boolean fixLast;
        private int normalizedEOL = 0;
        private char[] eol = null;

        public NormalizeEolFilter(Reader reader, String string, boolean bl) {
            super(reader);
            this.eol = string.toCharArray();
            this.fixLast = bl;
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            if (this.normalizedEOL == 0) {
                int n2 = 0;
                boolean bl = false;
                switch (n) {
                    case 26: {
                        int n3 = super.read();
                        if (n3 == -1) {
                            bl = true;
                            if (!this.fixLast || this.previousWasEOL) break;
                            n2 = 1;
                            this.push(n);
                            break;
                        }
                        this.push(n3);
                        break;
                    }
                    case -1: {
                        bl = true;
                        if (!this.fixLast || this.previousWasEOL) break;
                        n2 = 1;
                        break;
                    }
                    case 10: {
                        n2 = 1;
                        break;
                    }
                    case 13: {
                        n2 = 1;
                        int n4 = super.read();
                        int n5 = super.read();
                        if (n4 == 13 && n5 == 10) break;
                        if (n4 == 13) {
                            n2 = 2;
                            this.push(n5);
                            break;
                        }
                        if (n4 == 10) {
                            this.push(n5);
                            break;
                        }
                        this.push(n5);
                        this.push(n4);
                    }
                }
                if (n2 > 0) {
                    while (n2-- > 0) {
                        this.push(this.eol);
                        this.normalizedEOL += this.eol.length;
                    }
                    this.previousWasEOL = true;
                    n = this.read();
                } else if (!bl) {
                    this.previousWasEOL = false;
                }
            } else {
                --this.normalizedEOL;
            }
            return n;
        }
    }

    private static class MaskJavaTabLiteralsFilter
    extends SimpleFilterReader {
        private boolean editsBlocked = false;
        private static final int JAVA = 1;
        private static final int IN_CHAR_CONST = 2;
        private static final int IN_STR_CONST = 3;
        private static final int IN_SINGLE_COMMENT = 4;
        private static final int IN_MULTI_COMMENT = 5;
        private static final int TRANS_TO_COMMENT = 6;
        private static final int TRANS_FROM_MULTI = 8;
        private int state = 1;

        public MaskJavaTabLiteralsFilter(Reader reader) {
            super(reader);
        }

        @Override
        public boolean editsBlocked() {
            return this.editsBlocked || super.editsBlocked();
        }

        @Override
        public int read() throws IOException {
            int n = super.read();
            this.editsBlocked = this.state == 2 || this.state == 3;
            block0 : switch (this.state) {
                case 1: {
                    switch (n) {
                        case 39: {
                            this.state = 2;
                            break block0;
                        }
                        case 34: {
                            this.state = 3;
                            break block0;
                        }
                        case 47: {
                            this.state = 6;
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n) {
                        case 39: {
                            this.state = 1;
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n) {
                        case 34: {
                            this.state = 1;
                            break block0;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (n) {
                        case 10: 
                        case 13: {
                            this.state = 1;
                            break block0;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (n) {
                        case 42: {
                            this.state = 8;
                            break block0;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (n) {
                        case 42: {
                            this.state = 5;
                            break block0;
                        }
                        case 47: {
                            this.state = 4;
                            break block0;
                        }
                        case 39: {
                            this.state = 2;
                            break block0;
                        }
                        case 34: {
                            this.state = 3;
                            break block0;
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 8: {
                    switch (n) {
                        case 47: {
                            this.state = 1;
                            break block0;
                        }
                    }
                    break;
                }
            }
            return n;
        }
    }

    private static class SimpleFilterReader
    extends Reader {
        private static final int PREEMPT_BUFFER_LENGTH = 16;
        private Reader in;
        private int[] preempt = new int[16];
        private int preemptIndex = 0;

        public SimpleFilterReader(Reader reader) {
            this.in = reader;
        }

        public void push(char c) {
            this.push((int)c);
        }

        public void push(int n) {
            try {
                this.preempt[this.preemptIndex++] = n;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[] nArray = new int[this.preempt.length * 2];
                System.arraycopy(this.preempt, 0, nArray, 0, this.preempt.length);
                this.preempt = nArray;
                this.push(n);
            }
        }

        public void push(char[] cArray, int n, int n2) {
            int n3 = n + n2 - 1;
            while (n3 >= n) {
                this.push(cArray[n3--]);
            }
        }

        public void push(char[] cArray) {
            this.push(cArray, 0, cArray.length);
        }

        public void push(String string) {
            this.push(string.toCharArray());
        }

        public boolean editsBlocked() {
            return this.in instanceof SimpleFilterReader && ((SimpleFilterReader)this.in).editsBlocked();
        }

        @Override
        public int read() throws IOException {
            return this.preemptIndex > 0 ? this.preempt[--this.preemptIndex] : this.in.read();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public void reset() throws IOException {
            this.in.reset();
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }

        @Override
        public boolean ready() throws IOException {
            return this.in.ready();
        }

        @Override
        public void mark(int n) throws IOException {
            this.in.mark(n);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.in.skip(l);
        }

        @Override
        public int read(char[] cArray) throws IOException {
            return this.read(cArray, 0, cArray.length);
        }

        @Override
        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            int n4 = 0;
            while (n2-- > 0 && (n4 = this.read()) != -1) {
                cArray[n++] = (char)n4;
                ++n3;
            }
            return n3 == 0 && n4 == -1 ? -1 : n3;
        }
    }
}

