/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.filters;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.FileUtils;

public abstract class BaseFilterReader
extends FilterReader {
    private static final int BUFFER_SIZE = 8192;
    private boolean initialized = false;
    private Project project = null;

    public BaseFilterReader() {
        super(new StringReader(""));
        FileUtils.close(this);
    }

    public BaseFilterReader(Reader reader) {
        super(reader);
    }

    @Override
    public final int read(char[] cArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cArray[n + i] = (char)n3;
        }
        return n2;
    }

    @Override
    public final long skip(long l) throws IOException, IllegalArgumentException {
        if (l < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        for (long i = 0L; i < l; ++i) {
            if (this.read() != -1) continue;
            return i;
        }
        return l;
    }

    protected final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    protected final boolean getInitialized() {
        return this.initialized;
    }

    public final void setProject(Project project) {
        this.project = project;
    }

    protected final Project getProject() {
        return this.project;
    }

    protected final String readLine() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n != -1) {
            stringBuffer.append((char)n);
            if (n == 10) break;
            n = this.in.read();
        }
        return stringBuffer.toString();
    }

    protected final String readFully() throws IOException {
        return FileUtils.readFully(this.in, 8192);
    }
}

