/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.util.CollectionUtils;

public class Target
implements TaskContainer {
    private String name;
    private String ifCondition = "";
    private String unlessCondition = "";
    private List dependencies = null;
    private List children = new ArrayList();
    private Location location = Location.UNKNOWN_LOCATION;
    private Project project;
    private String description = null;

    public Target() {
    }

    public Target(Target target) {
        this.name = target.name;
        this.ifCondition = target.ifCondition;
        this.unlessCondition = target.unlessCondition;
        this.dependencies = target.dependencies;
        this.location = target.location;
        this.project = target.project;
        this.description = target.description;
        this.children = target.children;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setDepends(String string) {
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if ("".equals(string2) || ",".equals(string2)) {
                    throw new BuildException("Syntax Error: depends attribute of target \"" + this.getName() + "\" has an empty string as dependency.");
                }
                this.addDependency(string2);
                if (!stringTokenizer.hasMoreTokens()) continue;
                string2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens() && ",".equals(string2)) continue;
                throw new BuildException("Syntax Error: Depend attribute for target \"" + this.getName() + "\" ends with a , character");
            }
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void addTask(Task task) {
        this.children.add(task);
    }

    public void addDataType(RuntimeConfigurable runtimeConfigurable) {
        this.children.add(runtimeConfigurable);
    }

    public Task[] getTasks() {
        ArrayList arrayList = new ArrayList(this.children.size());
        for (Object e : this.children) {
            if (!(e instanceof Task)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new Task[arrayList.size()]);
    }

    public void addDependency(String string) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList(2);
        }
        this.dependencies.add(string);
    }

    public Enumeration getDependencies() {
        return this.dependencies != null ? Collections.enumeration(this.dependencies) : new CollectionUtils.EmptyEnumeration();
    }

    public boolean dependsOn(String string) {
        Project project = this.getProject();
        Hashtable hashtable = project == null ? null : project.getTargets();
        return project != null && project.topoSort(this.getName(), hashtable, false).contains(hashtable.get(string));
    }

    public void setIf(String string) {
        this.ifCondition = string == null ? "" : string;
    }

    public String getIf() {
        return "".equals(this.ifCondition) ? null : this.ifCondition;
    }

    public void setUnless(String string) {
        this.unlessCondition = string == null ? "" : string;
    }

    public String getUnless() {
        return "".equals(this.unlessCondition) ? null : this.unlessCondition;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name;
    }

    public void execute() throws BuildException {
        if (this.testIfCondition() && this.testUnlessCondition()) {
            for (int i = 0; i < this.children.size(); ++i) {
                Object object;
                Object e = this.children.get(i);
                if (e instanceof Task) {
                    object = (Task)e;
                    ((Task)object).perform();
                    continue;
                }
                object = (RuntimeConfigurable)e;
                ((RuntimeConfigurable)object).maybeConfigure(this.project);
            }
        } else if (!this.testIfCondition()) {
            this.project.log(this, "Skipped because property '" + this.project.replaceProperties(this.ifCondition) + "' not set.", 3);
        } else {
            this.project.log(this, "Skipped because property '" + this.project.replaceProperties(this.unlessCondition) + "' set.", 3);
        }
    }

    public final void performTasks() {
        RuntimeException runtimeException = null;
        this.project.fireTargetStarted(this);
        try {
            this.execute();
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
            throw runtimeException2;
        }
        finally {
            this.project.fireTargetFinished(this, runtimeException);
        }
    }

    void replaceChild(Task task, RuntimeConfigurable runtimeConfigurable) {
        int n;
        while ((n = this.children.indexOf(task)) >= 0) {
            this.children.set(n, runtimeConfigurable);
        }
    }

    void replaceChild(Task task, Task task2) {
        int n;
        while ((n = this.children.indexOf(task)) >= 0) {
            this.children.set(n, task2);
        }
    }

    private boolean testIfCondition() {
        if ("".equals(this.ifCondition)) {
            return true;
        }
        String string = this.project.replaceProperties(this.ifCondition);
        return this.project.getProperty(string) != null;
    }

    private boolean testUnlessCondition() {
        if ("".equals(this.unlessCondition)) {
            return true;
        }
        String string = this.project.replaceProperties(this.unlessCondition);
        return this.project.getProperty(string) == null;
    }
}

