/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.UnsupportedAttributeException;
import org.apache.tools.ant.util.CollectionUtils;
import org.xml.sax.AttributeList;
import org.xml.sax.helpers.AttributeListImpl;

public class RuntimeConfigurable
implements Serializable {
    private static final Hashtable EMPTY_HASHTABLE = new Hashtable(0);
    private String elementTag = null;
    private List children = null;
    private transient Object wrappedObject = null;
    private transient IntrospectionHelper.Creator creator;
    private transient AttributeList attributes;
    private List attributeNames = null;
    private Map attributeMap = null;
    private StringBuffer characters = null;
    private boolean proxyConfigured = false;
    private String polyType = null;
    private String id = null;

    public RuntimeConfigurable(Object object, String string) {
        this.setProxy(object);
        this.setElementTag(string);
        if (object instanceof Task) {
            ((Task)object).setRuntimeConfigurableWrapper(this);
        }
    }

    public synchronized void setProxy(Object object) {
        this.wrappedObject = object;
        this.proxyConfigured = false;
    }

    synchronized void setCreator(IntrospectionHelper.Creator creator) {
        this.creator = creator;
    }

    public synchronized Object getProxy() {
        return this.wrappedObject;
    }

    public synchronized String getId() {
        return this.id;
    }

    public synchronized String getPolyType() {
        return this.polyType;
    }

    public synchronized void setPolyType(String string) {
        this.polyType = string;
    }

    public synchronized void setAttributes(AttributeList attributeList) {
        this.attributes = new AttributeListImpl(attributeList);
        for (int i = 0; i < attributeList.getLength(); ++i) {
            this.setAttribute(attributeList.getName(i), attributeList.getValue(i));
        }
    }

    public synchronized void setAttribute(String string, String string2) {
        if (string.equalsIgnoreCase("ant-type")) {
            this.polyType = string2;
        } else {
            if (this.attributeNames == null) {
                this.attributeNames = new ArrayList();
                this.attributeMap = new HashMap();
            }
            if (string.toLowerCase(Locale.US).equals("refid")) {
                this.attributeNames.add(0, string);
            } else {
                this.attributeNames.add(string);
            }
            this.attributeMap.put(string, string2);
            if (string.equals("id")) {
                this.id = string2;
            }
        }
    }

    public synchronized void removeAttribute(String string) {
        this.attributeNames.remove(string);
        this.attributeMap.remove(string);
    }

    public synchronized Hashtable getAttributeMap() {
        return this.attributeMap == null ? EMPTY_HASHTABLE : new Hashtable(this.attributeMap);
    }

    public synchronized AttributeList getAttributes() {
        return this.attributes;
    }

    public synchronized void addChild(RuntimeConfigurable runtimeConfigurable) {
        this.children = this.children == null ? new ArrayList() : this.children;
        this.children.add(runtimeConfigurable);
    }

    synchronized RuntimeConfigurable getChild(int n) {
        return (RuntimeConfigurable)this.children.get(n);
    }

    public synchronized Enumeration getChildren() {
        return this.children == null ? new CollectionUtils.EmptyEnumeration() : Collections.enumeration(this.children);
    }

    public synchronized void addText(String string) {
        if (string.length() == 0) {
            return;
        }
        this.characters = this.characters == null ? new StringBuffer(string) : this.characters.append(string);
    }

    public synchronized void addText(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        this.characters = (this.characters == null ? new StringBuffer(n2) : this.characters).append(cArray, n, n2);
    }

    public synchronized StringBuffer getText() {
        return this.characters == null ? new StringBuffer(0) : this.characters;
    }

    public synchronized void setElementTag(String string) {
        this.elementTag = string;
    }

    public synchronized String getElementTag() {
        return this.elementTag;
    }

    public void maybeConfigure(Project project) throws BuildException {
        this.maybeConfigure(project, true);
    }

    public synchronized void maybeConfigure(Project project, boolean bl) throws BuildException {
        if (this.proxyConfigured) {
            return;
        }
        Object object = this.wrappedObject instanceof TypeAdapter ? ((TypeAdapter)this.wrappedObject).getProxy() : this.wrappedObject;
        IntrospectionHelper introspectionHelper = IntrospectionHelper.getHelper(project, object.getClass());
        if (this.attributeNames != null) {
            for (int i = 0; i < this.attributeNames.size(); ++i) {
                String string = (String)this.attributeNames.get(i);
                String string2 = (String)this.attributeMap.get(string);
                string2 = project.replaceProperties(string2);
                try {
                    introspectionHelper.setAttribute(project, object, string, string2);
                    continue;
                }
                catch (UnsupportedAttributeException unsupportedAttributeException) {
                    if (string.equals("id")) continue;
                    if (this.getElementTag() == null) {
                        throw unsupportedAttributeException;
                    }
                    throw new BuildException(this.getElementTag() + " doesn't support the \"" + unsupportedAttributeException.getAttribute() + "\" attribute", unsupportedAttributeException);
                }
                catch (BuildException buildException) {
                    if (string.equals("id")) continue;
                    throw buildException;
                }
            }
        }
        if (this.characters != null) {
            ProjectHelper.addText(project, this.wrappedObject, this.characters.substring(0));
        }
        if (this.id != null) {
            project.addReference(this.id, this.wrappedObject);
        }
        this.proxyConfigured = true;
    }

    public void reconfigure(Project project) {
        this.proxyConfigured = false;
        this.maybeConfigure(project);
    }

    public void applyPreSet(RuntimeConfigurable runtimeConfigurable) {
        if (runtimeConfigurable.attributeMap != null) {
            for (String string : runtimeConfigurable.attributeMap.keySet()) {
                if (this.attributeMap != null && this.attributeMap.get(string) != null) continue;
                this.setAttribute(string, (String)runtimeConfigurable.attributeMap.get(string));
            }
        }
        String string = this.polyType = this.polyType == null ? runtimeConfigurable.polyType : this.polyType;
        if (runtimeConfigurable.children != null) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(runtimeConfigurable.children);
            if (this.children != null) {
                arrayList.addAll(this.children);
            }
            this.children = arrayList;
        }
        if (runtimeConfigurable.characters != null && (this.characters == null || this.characters.toString().trim().length() == 0)) {
            this.characters = new StringBuffer(runtimeConfigurable.characters.toString());
        }
    }
}

