/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import java.util.WeakHashMap;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Executor;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.DefaultExecutor;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.types.Description;
import org.apache.tools.ant.types.FilterSet;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.StringUtils;

public class Project
implements ResourceFactory {
    private static final String LINE_SEP = System.getProperty("line.separator");
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static final String VISITING = "VISITING";
    private static final String VISITED = "VISITED";
    public static final String JAVA_1_0 = "1.0";
    public static final String JAVA_1_1 = "1.1";
    public static final String JAVA_1_2 = "1.2";
    public static final String JAVA_1_3 = "1.3";
    public static final String JAVA_1_4 = "1.4";
    public static final String TOKEN_START = "@";
    public static final String TOKEN_END = "@";
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private String name;
    private String description;
    private Hashtable references = new AntRefTable();
    private HashMap idReferences = new HashMap();
    private Project parentIdProject = null;
    private String defaultTarget;
    private Hashtable targets = new Hashtable();
    private FilterSet globalFilterSet = new FilterSet();
    private FilterSetCollection globalFilters;
    private File baseDir;
    private Vector listeners;
    private ClassLoader coreLoader;
    private Map threadTasks;
    private Map threadGroupTasks;
    private InputHandler inputHandler;
    private InputStream defaultInputStream;
    private boolean keepGoingMode;
    private boolean loggingMessage;

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public void setDefaultInputStream(InputStream inputStream) {
        this.defaultInputStream = inputStream;
    }

    public InputStream getDefaultInputStream() {
        return this.defaultInputStream;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public Project() {
        this.globalFilterSet.setProject(this);
        this.globalFilters = new FilterSetCollection(this.globalFilterSet);
        this.listeners = new Vector();
        this.coreLoader = null;
        this.threadTasks = Collections.synchronizedMap(new WeakHashMap());
        this.threadGroupTasks = Collections.synchronizedMap(new WeakHashMap());
        this.inputHandler = null;
        this.defaultInputStream = null;
        this.keepGoingMode = false;
        this.loggingMessage = false;
        this.inputHandler = new DefaultInputHandler();
    }

    public Project createSubProject() {
        Project project = null;
        try {
            project = (Project)this.getClass().newInstance();
        }
        catch (Exception exception) {
            project = new Project();
        }
        this.initSubProject(project);
        return project;
    }

    public void initSubProject(Project project) {
        ComponentHelper.getComponentHelper(project).initSubProject(ComponentHelper.getComponentHelper(this));
        project.setDefaultInputStream(this.getDefaultInputStream());
        project.setKeepGoingMode(this.isKeepGoingMode());
        project.setExecutor(this.getExecutor().getSubProjectExecutor());
    }

    public void init() throws BuildException {
        this.initProperties();
        ComponentHelper.getComponentHelper(this).initDefaultDefinitions();
    }

    public void initProperties() throws BuildException {
        this.setJavaVersionProperty();
        this.setSystemProperties();
        this.setPropertyInternal("ant.version", Main.getAntVersion());
        this.setAntLib();
    }

    private void setAntLib() {
        File file = Locator.getClassSource(Project.class);
        if (file != null) {
            this.setPropertyInternal("ant.core.lib", file.getAbsolutePath());
        }
    }

    public AntClassLoader createClassLoader(Path path) {
        return new AntClassLoader(this.getClass().getClassLoader(), this, path);
    }

    public AntClassLoader createClassLoader(ClassLoader classLoader, Path path) {
        return new AntClassLoader(classLoader, this, path);
    }

    public void setCoreLoader(ClassLoader classLoader) {
        this.coreLoader = classLoader;
    }

    public ClassLoader getCoreLoader() {
        return this.coreLoader;
    }

    public synchronized void addBuildListener(BuildListener buildListener) {
        if (this.listeners.contains(buildListener)) {
            return;
        }
        Vector vector = this.getBuildListeners();
        vector.addElement(buildListener);
        this.listeners = vector;
    }

    public synchronized void removeBuildListener(BuildListener buildListener) {
        Vector vector = this.getBuildListeners();
        vector.removeElement(buildListener);
        this.listeners = vector;
    }

    public Vector getBuildListeners() {
        return (Vector)this.listeners.clone();
    }

    public void log(String string) {
        this.log(string, 2);
    }

    public void log(String string, int n) {
        this.log(string, null, n);
    }

    public void log(String string, Throwable throwable, int n) {
        this.fireMessageLogged(this, string, throwable, n);
    }

    public void log(Task task, String string, int n) {
        this.fireMessageLogged(task, string, null, n);
    }

    public void log(Task task, String string, Throwable throwable, int n) {
        this.fireMessageLogged(task, string, throwable, n);
    }

    public void log(Target target, String string, int n) {
        this.log(target, string, null, n);
    }

    public void log(Target target, String string, Throwable throwable, int n) {
        this.fireMessageLogged(target, string, throwable, n);
    }

    public FilterSet getGlobalFilterSet() {
        return this.globalFilterSet;
    }

    public void setProperty(String string, String string2) {
        PropertyHelper.getPropertyHelper(this).setProperty(null, string, string2, true);
    }

    public void setNewProperty(String string, String string2) {
        PropertyHelper.getPropertyHelper(this).setNewProperty(null, string, string2);
    }

    public void setUserProperty(String string, String string2) {
        PropertyHelper.getPropertyHelper(this).setUserProperty(null, string, string2);
    }

    public void setInheritedProperty(String string, String string2) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        propertyHelper.setInheritedProperty(null, string, string2);
    }

    private void setPropertyInternal(String string, String string2) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        propertyHelper.setProperty(null, string, string2, false);
    }

    public String getProperty(String string) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        return (String)propertyHelper.getProperty(null, string);
    }

    public String replaceProperties(String string) throws BuildException {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        return propertyHelper.replaceProperties(null, string, null);
    }

    public String getUserProperty(String string) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        return (String)propertyHelper.getUserProperty(null, string);
    }

    public Hashtable getProperties() {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        return propertyHelper.getProperties();
    }

    public Hashtable getUserProperties() {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        return propertyHelper.getUserProperties();
    }

    public void copyUserProperties(Project project) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        propertyHelper.copyUserProperties(project);
    }

    public void copyInheritedProperties(Project project) {
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper(this);
        propertyHelper.copyInheritedProperties(project);
    }

    public void setDefaultTarget(String string) {
        this.defaultTarget = string;
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void setDefault(String string) {
        this.defaultTarget = string;
    }

    public void setName(String string) {
        this.setUserProperty("ant.project.name", string);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = Description.getDescription(this);
        }
        return this.description;
    }

    public void addFilter(String string, String string2) {
        if (string == null) {
            return;
        }
        this.globalFilterSet.addFilter(new FilterSet.Filter(string, string2));
    }

    public Hashtable getFilters() {
        return this.globalFilterSet.getFilterHash();
    }

    public void setBasedir(String string) throws BuildException {
        this.setBaseDir(new File(string));
    }

    public void setBaseDir(File file) throws BuildException {
        if (!(file = FILE_UTILS.normalize(file.getAbsolutePath())).exists()) {
            throw new BuildException("Basedir " + file.getAbsolutePath() + " does not exist");
        }
        if (!file.isDirectory()) {
            throw new BuildException("Basedir " + file.getAbsolutePath() + " is not a directory");
        }
        this.baseDir = file;
        this.setPropertyInternal("basedir", this.baseDir.getPath());
        String string = "Project base dir set to: " + this.baseDir;
        this.log(string, 3);
    }

    public File getBaseDir() {
        if (this.baseDir == null) {
            try {
                this.setBasedir(".");
            }
            catch (BuildException buildException) {
                buildException.printStackTrace();
            }
        }
        return this.baseDir;
    }

    public void setKeepGoingMode(boolean bl) {
        this.keepGoingMode = bl;
    }

    public boolean isKeepGoingMode() {
        return this.keepGoingMode;
    }

    public static String getJavaVersion() {
        return JavaEnvUtils.getJavaVersion();
    }

    public void setJavaVersionProperty() throws BuildException {
        String string = JavaEnvUtils.getJavaVersion();
        this.setPropertyInternal("ant.java.version", string);
        if (JavaEnvUtils.isJavaVersion(JAVA_1_0) || JavaEnvUtils.isJavaVersion(JAVA_1_1)) {
            throw new BuildException("Ant cannot work on Java 1.0 / 1.1");
        }
        this.log("Detected Java version: " + string + " in: " + System.getProperty("java.home"), 3);
        this.log("Detected OS: " + System.getProperty("os.name"), 3);
    }

    public void setSystemProperties() {
        Properties properties = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            this.setPropertyInternal(string, string2);
        }
    }

    public void addTaskDefinition(String string, Class clazz) throws BuildException {
        ComponentHelper.getComponentHelper(this).addTaskDefinition(string, clazz);
    }

    public void checkTaskClass(Class clazz) throws BuildException {
        ComponentHelper.getComponentHelper(this).checkTaskClass(clazz);
        if (!Modifier.isPublic(clazz.getModifiers())) {
            String string = clazz + " is not public";
            this.log(string, 0);
            throw new BuildException(string);
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            String string = clazz + " is abstract";
            this.log(string, 0);
            throw new BuildException(string);
        }
        try {
            clazz.getConstructor(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "No public no-arg constructor in " + clazz;
            this.log(string, 0);
            throw new BuildException(string);
        }
        catch (LinkageError linkageError) {
            String string = "Could not load " + clazz + ": " + linkageError;
            this.log(string, 0);
            throw new BuildException(string, linkageError);
        }
        if (!Task.class.isAssignableFrom(clazz)) {
            TaskAdapter.checkTaskClass(clazz, this);
        }
    }

    public Hashtable getTaskDefinitions() {
        return ComponentHelper.getComponentHelper(this).getTaskDefinitions();
    }

    public void addDataTypeDefinition(String string, Class clazz) {
        ComponentHelper.getComponentHelper(this).addDataTypeDefinition(string, clazz);
    }

    public Hashtable getDataTypeDefinitions() {
        return ComponentHelper.getComponentHelper(this).getDataTypeDefinitions();
    }

    public void addTarget(Target target) throws BuildException {
        this.addTarget(target.getName(), target);
    }

    public void addTarget(String string, Target target) throws BuildException {
        if (this.targets.get(string) != null) {
            throw new BuildException("Duplicate target: `" + string + "'");
        }
        this.addOrReplaceTarget(string, target);
    }

    public void addOrReplaceTarget(Target target) {
        this.addOrReplaceTarget(target.getName(), target);
    }

    public void addOrReplaceTarget(String string, Target target) {
        String string2 = " +Target: " + string;
        this.log(string2, 4);
        target.setProject(this);
        this.targets.put(string, target);
    }

    public Hashtable getTargets() {
        return this.targets;
    }

    public Task createTask(String string) throws BuildException {
        return ComponentHelper.getComponentHelper(this).createTask(string);
    }

    public Object createDataType(String string) throws BuildException {
        return ComponentHelper.getComponentHelper(this).createDataType(string);
    }

    public void setExecutor(Executor executor) {
        this.addReference("ant.executor", executor);
    }

    public Executor getExecutor() {
        Object object = this.getReference("ant.executor");
        if (object == null) {
            String string = this.getProperty("ant.executor.class");
            if (string == null) {
                string = DefaultExecutor.class.getName();
            }
            this.log("Attempting to create object of type " + string, 4);
            try {
                object = Class.forName(string, true, this.coreLoader).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    object = Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    this.log(exception.toString(), 0);
                }
            }
            catch (Exception exception) {
                this.log(exception.toString(), 0);
            }
            if (object == null) {
                throw new BuildException("Unable to obtain a Target Executor instance.");
            }
            this.setExecutor((Executor)object);
        }
        return (Executor)object;
    }

    public void executeTargets(Vector vector) throws BuildException {
        this.getExecutor().executeTargets(this, vector.toArray(new String[vector.size()]));
    }

    public void demuxOutput(String string, boolean bl) {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            this.log(string, bl ? 1 : 2);
        } else if (bl) {
            task.handleErrorOutput(string);
        } else {
            task.handleOutput(string);
        }
    }

    public int defaultInput(byte[] byArray, int n, int n2) throws IOException {
        if (this.defaultInputStream != null) {
            System.out.flush();
            return this.defaultInputStream.read(byArray, n, n2);
        }
        throw new EOFException("No input provided for project");
    }

    public int demuxInput(byte[] byArray, int n, int n2) throws IOException {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            return this.defaultInput(byArray, n, n2);
        }
        return task.handleInput(byArray, n, n2);
    }

    public void demuxFlush(String string, boolean bl) {
        Task task = this.getThreadTask(Thread.currentThread());
        if (task == null) {
            this.fireMessageLogged(this, string, bl ? 0 : 2);
        } else if (bl) {
            task.handleErrorFlush(string);
        } else {
            task.handleFlush(string);
        }
    }

    public void executeTarget(String string) throws BuildException {
        if (string == null) {
            String string2 = "No target specified";
            throw new BuildException(string2);
        }
        this.executeSortedTargets(this.topoSort(string, this.targets, false));
    }

    public void executeSortedTargets(Vector vector) throws BuildException {
        HashSet<String> hashSet = new HashSet<String>();
        BuildException buildException = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Target target = (Target)enumeration.nextElement();
            boolean bl = true;
            Object object = target.getDependencies();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                if (hashSet.contains(string)) continue;
                bl = false;
                this.log(target, "Cannot execute '" + target.getName() + "' - '" + string + "' failed or was not executed.", 0);
                break;
            }
            if (!bl) continue;
            object = null;
            try {
                target.performTasks();
                hashSet.add(target.getName());
            }
            catch (RuntimeException runtimeException) {
                if (!this.keepGoingMode) {
                    throw runtimeException;
                }
                object = runtimeException;
            }
            catch (Throwable throwable) {
                if (!this.keepGoingMode) {
                    throw new BuildException(throwable);
                }
                object = throwable;
            }
            if (object == null) continue;
            if (object instanceof BuildException) {
                this.log(target, "Target '" + target.getName() + "' failed with message '" + ((Throwable)object).getMessage() + "'.", 0);
                if (buildException != null) continue;
                buildException = (BuildException)object;
                continue;
            }
            this.log(target, "Target '" + target.getName() + "' failed with message '" + ((Throwable)object).getMessage() + "'.", 0);
            ((Throwable)object).printStackTrace(System.err);
            if (buildException != null) continue;
            buildException = new BuildException((Throwable)object);
        }
        if (buildException != null) {
            throw buildException;
        }
    }

    public File resolveFile(String string, File file) {
        return FILE_UTILS.resolveFile(file, string);
    }

    public File resolveFile(String string) {
        return FILE_UTILS.resolveFile(this.baseDir, string);
    }

    public static String translatePath(String string) {
        return FileUtils.translatePath(string);
    }

    public void copyFile(String string, String string2) throws IOException {
        FILE_UTILS.copyFile(string, string2);
    }

    public void copyFile(String string, String string2, boolean bl) throws IOException {
        FILE_UTILS.copyFile(string, string2, bl ? this.globalFilters : null);
    }

    public void copyFile(String string, String string2, boolean bl, boolean bl2) throws IOException {
        FILE_UTILS.copyFile(string, string2, bl ? this.globalFilters : null, bl2);
    }

    public void copyFile(String string, String string2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        FILE_UTILS.copyFile(string, string2, bl ? this.globalFilters : null, bl2, bl3);
    }

    public void copyFile(File file, File file2) throws IOException {
        FILE_UTILS.copyFile(file, file2);
    }

    public void copyFile(File file, File file2, boolean bl) throws IOException {
        FILE_UTILS.copyFile(file, file2, bl ? this.globalFilters : null);
    }

    public void copyFile(File file, File file2, boolean bl, boolean bl2) throws IOException {
        FILE_UTILS.copyFile(file, file2, bl ? this.globalFilters : null, bl2);
    }

    public void copyFile(File file, File file2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        FILE_UTILS.copyFile(file, file2, bl ? this.globalFilters : null, bl2, bl3);
    }

    public void setFileLastModified(File file, long l) throws BuildException {
        FILE_UTILS.setFileLastModified(file, l);
        this.log("Setting modification time for " + file, 3);
    }

    public static boolean toBoolean(String string) {
        return "on".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string);
    }

    public static Project getProject(Object object) {
        if (object instanceof ProjectComponent) {
            return ((ProjectComponent)object).getProject();
        }
        try {
            Method method = object.getClass().getMethod("getProject", null);
            if (Project.class == method.getReturnType()) {
                return (Project)method.invoke(object, (Object[])null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public final Vector topoSort(String string, Hashtable hashtable) throws BuildException {
        return this.topoSort(new String[]{string}, hashtable, true);
    }

    public final Vector topoSort(String string, Hashtable hashtable, boolean bl) throws BuildException {
        return this.topoSort(new String[]{string}, hashtable, bl);
    }

    public final Vector topoSort(String[] stringArray, Hashtable hashtable, boolean bl) throws BuildException {
        Vector vector = new Vector();
        Hashtable hashtable2 = new Hashtable();
        Stack stack = new Stack();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = (String)hashtable2.get(stringArray[i]);
            if (string == null) {
                this.tsort(stringArray[i], hashtable, hashtable2, stack, vector);
                continue;
            }
            if (string != VISITING) continue;
            throw new RuntimeException("Unexpected node in visiting state: " + stringArray[i]);
        }
        StringBuffer stringBuffer = new StringBuffer("Build sequence for target(s)");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(i == 0 ? " `" : ", `").append(stringArray[i]).append('\'');
        }
        stringBuffer.append(" is " + vector);
        this.log(stringBuffer.toString(), 3);
        Vector vector2 = bl ? vector : new Vector(vector);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable2.get(string);
            if (string2 == null) {
                this.tsort(string, hashtable, hashtable2, stack, vector2);
                continue;
            }
            if (string2 != VISITING) continue;
            throw new RuntimeException("Unexpected node in visiting state: " + string);
        }
        this.log("Complete build sequence is " + vector2, 3);
        return vector;
    }

    private void tsort(String string, Hashtable hashtable, Hashtable hashtable2, Stack stack, Vector vector) throws BuildException {
        hashtable2.put(string, VISITING);
        stack.push(string);
        Target target = (Target)hashtable.get(string);
        if (target == null) {
            StringBuffer stringBuffer = new StringBuffer("Target \"");
            stringBuffer.append(string);
            stringBuffer.append("\" does not exist in the project \"");
            stringBuffer.append(this.name);
            stringBuffer.append("\". ");
            stack.pop();
            if (!stack.empty()) {
                String string2 = (String)stack.peek();
                stringBuffer.append("It is used from target \"");
                stringBuffer.append(string2);
                stringBuffer.append("\".");
            }
            throw new BuildException(new String(stringBuffer));
        }
        Object object = target.getDependencies();
        while (object.hasMoreElements()) {
            String string3 = (String)object.nextElement();
            String string4 = (String)hashtable2.get(string3);
            if (string4 == null) {
                this.tsort(string3, hashtable, hashtable2, stack, vector);
                continue;
            }
            if (string4 != VISITING) continue;
            throw Project.makeCircularException(string3, stack);
        }
        object = (String)stack.pop();
        if (string != object) {
            throw new RuntimeException("Unexpected internal error: expected to pop " + string + " but got " + (String)object);
        }
        hashtable2.put(string, VISITED);
        vector.addElement(target);
    }

    private static BuildException makeCircularException(String string, Stack stack) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer("Circular dependency: ");
        stringBuffer.append(string);
        do {
            string2 = (String)stack.pop();
            stringBuffer.append(" <- ");
            stringBuffer.append(string2);
        } while (!string2.equals(string));
        return new BuildException(new String(stringBuffer));
    }

    public void inheritIDReferences(Project project) {
        this.parentIdProject = project;
    }

    private Object resolveIdReference(String string, Project project) {
        UnknownElement unknownElement = (UnknownElement)this.idReferences.get(string);
        if (unknownElement == null) {
            return this.parentIdProject == null ? null : this.parentIdProject.resolveIdReference(string, project);
        }
        project.log("Warning: Reference " + string + " has not been set at runtime," + " but was found during" + LINE_SEP + "build file parsing, attempting to resolve." + " Future versions of Ant may support" + LINE_SEP + " referencing ids defined in non-executed targets.", 1);
        UnknownElement unknownElement2 = unknownElement.copy(project);
        unknownElement2.maybeConfigure();
        return unknownElement2.getRealThing();
    }

    public void addIdReference(String string, Object object) {
        this.idReferences.put(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(String string, Object object) {
        Hashtable hashtable = this.references;
        synchronized (hashtable) {
            Object object2 = ((AntRefTable)this.references).getReal(string);
            if (object2 == object) {
                return;
            }
            if (object2 != null && !(object2 instanceof UnknownElement)) {
                this.log("Overriding previous definition of reference to " + string, 3);
            }
            this.log("Adding reference: " + string, 4);
            this.references.put(string, object);
        }
    }

    public Hashtable getReferences() {
        return this.references;
    }

    public Object getReference(String string) {
        Object object = this.references.get(string);
        if (object != null) {
            return object;
        }
        object = this.resolveIdReference(string, this);
        if (object == null && !string.equals("ant.PropertyHelper")) {
            Vector vector = new Vector();
            PropertyHelper.getPropertyHelper(this).parsePropertyString(string, new Vector(), vector);
            if (vector.size() == 1) {
                this.log("Unresolvable reference " + string + " might be a misuse of property expansion syntax.", 1);
            }
        }
        return object;
    }

    public String getElementName(Object object) {
        return ComponentHelper.getComponentHelper(this).getElementName(object);
    }

    public void fireBuildStarted() {
        BuildEvent buildEvent = new BuildEvent(this);
        for (BuildListener buildListener : this.listeners) {
            buildListener.buildStarted(buildEvent);
        }
    }

    public void fireBuildFinished(Throwable throwable) {
        BuildEvent buildEvent = new BuildEvent(this);
        buildEvent.setException(throwable);
        for (BuildListener buildListener : this.listeners) {
            buildListener.buildFinished(buildEvent);
        }
        IntrospectionHelper.clearCache();
    }

    public void fireSubBuildStarted() {
        BuildEvent buildEvent = new BuildEvent(this);
        for (Object e : this.listeners) {
            if (!(e instanceof SubBuildListener)) continue;
            ((SubBuildListener)e).subBuildStarted(buildEvent);
        }
    }

    public void fireSubBuildFinished(Throwable throwable) {
        BuildEvent buildEvent = new BuildEvent(this);
        buildEvent.setException(throwable);
        for (Object e : this.listeners) {
            if (!(e instanceof SubBuildListener)) continue;
            ((SubBuildListener)e).subBuildFinished(buildEvent);
        }
    }

    protected void fireTargetStarted(Target target) {
        BuildEvent buildEvent = new BuildEvent(target);
        for (BuildListener buildListener : this.listeners) {
            buildListener.targetStarted(buildEvent);
        }
    }

    protected void fireTargetFinished(Target target, Throwable throwable) {
        BuildEvent buildEvent = new BuildEvent(target);
        buildEvent.setException(throwable);
        for (BuildListener buildListener : this.listeners) {
            buildListener.targetFinished(buildEvent);
        }
    }

    protected void fireTaskStarted(Task task) {
        this.registerThreadTask(Thread.currentThread(), task);
        BuildEvent buildEvent = new BuildEvent(task);
        for (BuildListener buildListener : this.listeners) {
            buildListener.taskStarted(buildEvent);
        }
    }

    protected void fireTaskFinished(Task task, Throwable throwable) {
        this.registerThreadTask(Thread.currentThread(), null);
        System.out.flush();
        System.err.flush();
        BuildEvent buildEvent = new BuildEvent(task);
        buildEvent.setException(throwable);
        for (BuildListener buildListener : this.listeners) {
            buildListener.taskFinished(buildEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageLoggedEvent(BuildEvent buildEvent, String string, int n) {
        if (string.endsWith(StringUtils.LINE_SEP)) {
            int n2 = string.length() - StringUtils.LINE_SEP.length();
            buildEvent.setMessage(string.substring(0, n2), n);
        } else {
            buildEvent.setMessage(string, n);
        }
        Project project = this;
        synchronized (project) {
            if (this.loggingMessage) {
                return;
            }
            try {
                this.loggingMessage = true;
                for (BuildListener buildListener : this.listeners) {
                    buildListener.messageLogged(buildEvent);
                }
            }
            finally {
                this.loggingMessage = false;
            }
        }
    }

    protected void fireMessageLogged(Project project, String string, int n) {
        this.fireMessageLogged(project, string, null, n);
    }

    protected void fireMessageLogged(Project project, String string, Throwable throwable, int n) {
        BuildEvent buildEvent = new BuildEvent(project);
        buildEvent.setException(throwable);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    protected void fireMessageLogged(Target target, String string, int n) {
        this.fireMessageLogged(target, string, null, n);
    }

    protected void fireMessageLogged(Target target, String string, Throwable throwable, int n) {
        BuildEvent buildEvent = new BuildEvent(target);
        buildEvent.setException(throwable);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    protected void fireMessageLogged(Task task, String string, int n) {
        this.fireMessageLogged(task, string, null, n);
    }

    protected void fireMessageLogged(Task task, String string, Throwable throwable, int n) {
        BuildEvent buildEvent = new BuildEvent(task);
        buildEvent.setException(throwable);
        this.fireMessageLoggedEvent(buildEvent, string, n);
    }

    public synchronized void registerThreadTask(Thread thread, Task task) {
        if (task != null) {
            this.threadTasks.put(thread, task);
            this.threadGroupTasks.put(thread.getThreadGroup(), task);
        } else {
            this.threadTasks.remove(thread);
            this.threadGroupTasks.remove(thread.getThreadGroup());
        }
    }

    public Task getThreadTask(Thread thread) {
        Task task = (Task)this.threadTasks.get(thread);
        if (task == null) {
            for (ThreadGroup threadGroup = thread.getThreadGroup(); task == null && threadGroup != null; threadGroup = threadGroup.getParent()) {
                task = (Task)this.threadGroupTasks.get(threadGroup);
            }
        }
        return task;
    }

    public final void setProjectReference(Object object) {
        if (object instanceof ProjectComponent) {
            ((ProjectComponent)object).setProject(this);
            return;
        }
        try {
            Method method = object.getClass().getMethod("setProject", Project.class);
            if (method != null) {
                method.invoke(object, this);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Resource getResource(String string) {
        return new FileResource(this.getBaseDir(), string);
    }

    private static class AntRefTable
    extends Hashtable {
        AntRefTable() {
        }

        private Object getReal(Object object) {
            return super.get(object);
        }

        @Override
        public Object get(Object object) {
            Object object2 = this.getReal(object);
            if (object2 instanceof UnknownElement) {
                UnknownElement unknownElement = (UnknownElement)object2;
                unknownElement.maybeConfigure();
                object2 = unknownElement.getRealThing();
            }
            return object2;
        }
    }
}

