/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.DynamicAttribute;
import org.apache.tools.ant.DynamicAttributeNS;
import org.apache.tools.ant.DynamicElement;
import org.apache.tools.ant.DynamicElementNS;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.UnsupportedAttributeException;
import org.apache.tools.ant.UnsupportedElementException;
import org.apache.tools.ant.taskdefs.PreSetDef;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.util.StringUtils;

public final class IntrospectionHelper {
    private static final Map HELPERS = new Hashtable();
    private static final Map PRIMITIVE_TYPE_MAP = new HashMap(8);
    private static final int MAX_REPORT_NESTED_TEXT = 20;
    private static final String ELLIPSIS = "...";
    private Hashtable attributeTypes = new Hashtable();
    private Hashtable attributeSetters = new Hashtable();
    private Hashtable nestedTypes = new Hashtable();
    private Hashtable nestedCreators = new Hashtable();
    private List addTypeMethods = new ArrayList();
    private Method addText = null;
    private Class bean;

    private IntrospectionHelper(Class clazz) {
        this.bean = clazz;
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Object object;
            Object object2;
            Method method = methodArray[i];
            String string = method.getName();
            Class<?> clazz2 = method.getReturnType();
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length == 1 && Void.TYPE.equals(clazz2) && ("add".equals(string) || "addConfigured".equals(string))) {
                this.insertAddTypeMethod(method);
                continue;
            }
            if (ProjectComponent.class.isAssignableFrom(clazz) && classArray.length == 1 && this.isHiddenSetMethod(string, classArray[0]) || this.isContainer() && classArray.length == 1 && "addTask".equals(string) && Task.class.equals(classArray[0])) continue;
            if ("addText".equals(string) && Void.TYPE.equals(clazz2) && classArray.length == 1 && String.class.equals(classArray[0])) {
                this.addText = methodArray[i];
                continue;
            }
            if (string.startsWith("set") && Void.TYPE.equals(clazz2) && classArray.length == 1 && !classArray[0].isArray()) {
                object2 = IntrospectionHelper.getPropertyName(string, "set");
                if (this.attributeSetters.get(object2) != null && String.class.equals(classArray[0]) || (object = this.createAttributeSetter(method, classArray[0], (String)object2)) == null) continue;
                this.attributeTypes.put(object2, classArray[0]);
                this.attributeSetters.put(object2, object);
                continue;
            }
            if (string.startsWith("create") && !clazz2.isArray() && !clazz2.isPrimitive() && classArray.length == 0) {
                object2 = IntrospectionHelper.getPropertyName(string, "create");
                if (this.nestedCreators.get(object2) != null) continue;
                this.nestedTypes.put(object2, clazz2);
                this.nestedCreators.put(object2, new CreateNestedCreator(method));
                continue;
            }
            if (string.startsWith("addConfigured") && Void.TYPE.equals(clazz2) && classArray.length == 1 && !String.class.equals(classArray[0]) && !classArray[0].isArray() && !classArray[0].isPrimitive()) {
                try {
                    object2 = null;
                    try {
                        object2 = classArray[0].getConstructor(new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        object2 = classArray[0].getConstructor(Project.class);
                    }
                    object = IntrospectionHelper.getPropertyName(string, "addConfigured");
                    this.nestedTypes.put(object, classArray[0]);
                    this.nestedCreators.put(object, new AddNestedCreator(method, (Constructor)object2, 2));
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                continue;
            }
            if (!string.startsWith("add") || !Void.TYPE.equals(clazz2) || classArray.length != 1 || String.class.equals(classArray[0]) || classArray[0].isArray() || classArray[0].isPrimitive()) continue;
            try {
                object2 = null;
                try {
                    object2 = classArray[0].getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    object2 = classArray[0].getConstructor(Project.class);
                }
                object = IntrospectionHelper.getPropertyName(string, "add");
                if (this.nestedTypes.get(object) != null) continue;
                this.nestedTypes.put(object, classArray[0]);
                this.nestedCreators.put(object, new AddNestedCreator(method, (Constructor)object2, 1));
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    private boolean isHiddenSetMethod(String string, Class clazz) {
        if ("setLocation".equals(string) && Location.class.equals((Object)clazz)) {
            return true;
        }
        return "setTaskType".equals(string) && String.class.equals((Object)clazz);
    }

    public static synchronized IntrospectionHelper getHelper(Class clazz) {
        return IntrospectionHelper.getHelper(null, clazz);
    }

    public static IntrospectionHelper getHelper(Project project, Class clazz) {
        IntrospectionHelper introspectionHelper = (IntrospectionHelper)HELPERS.get(clazz.getName());
        if (introspectionHelper == null || introspectionHelper.bean != clazz) {
            introspectionHelper = new IntrospectionHelper(clazz);
            if (project != null) {
                HELPERS.put(clazz.getName(), introspectionHelper);
            }
        }
        return introspectionHelper;
    }

    public void setAttribute(Project project, Object object, String string, String string2) throws BuildException {
        AttributeSetter attributeSetter = (AttributeSetter)this.attributeSetters.get(string.toLowerCase(Locale.US));
        if (attributeSetter == null) {
            if (object instanceof DynamicAttributeNS) {
                DynamicAttributeNS dynamicAttributeNS = (DynamicAttributeNS)object;
                String string3 = ProjectHelper.extractUriFromComponentName(string);
                String string4 = ProjectHelper.extractUriFromComponentName(string3);
                String string5 = ProjectHelper.extractNameFromComponentName(string);
                String string6 = "".equals(string4) ? string5 : string4 + ":" + string5;
                dynamicAttributeNS.setDynamicAttribute(string4, string5, string6, string2);
                return;
            }
            if (object instanceof DynamicAttribute) {
                DynamicAttribute dynamicAttribute = (DynamicAttribute)object;
                dynamicAttribute.setDynamicAttribute(string.toLowerCase(Locale.US), string2);
                return;
            }
            if (string.indexOf(58) != -1) {
                return;
            }
            String string7 = this.getElementName(project, object) + " doesn't support the \"" + string + "\" attribute.";
            throw new UnsupportedAttributeException(string7, string);
        }
        try {
            attributeSetter.set(project, object, string2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw IntrospectionHelper.extractBuildException(invocationTargetException);
        }
    }

    public void addText(Project project, Object object, String string) throws BuildException {
        if (this.addText == null) {
            if ((string = string.trim()).length() == 0) {
                return;
            }
            throw new BuildException(project.getElementName(object) + " doesn't support nested text data (\"" + this.condenseText(string) + "\").");
        }
        try {
            this.addText.invoke(object, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw IntrospectionHelper.extractBuildException(invocationTargetException);
        }
    }

    public void throwNotSupported(Project project, Object object, String string) {
        String string2 = project.getElementName(object) + " doesn't support the nested \"" + string + "\" element.";
        throw new UnsupportedElementException(string2, string);
    }

    private NestedCreator getNestedCreator(Project project, String string, Object object, String string2, UnknownElement unknownElement) throws BuildException {
        Object object2;
        Object object3;
        Object object4;
        String string3 = ProjectHelper.extractUriFromComponentName(string2);
        String string4 = ProjectHelper.extractNameFromComponentName(string2);
        if (string3.equals("antlib:org.apache.tools.ant")) {
            string3 = "";
        }
        if (string.equals("antlib:org.apache.tools.ant")) {
            string = "";
        }
        NestedCreator nestedCreator = null;
        if (string3.equals(string) || string3.length() == 0) {
            nestedCreator = (NestedCreator)this.nestedCreators.get(string4.toLowerCase(Locale.US));
        }
        if (nestedCreator == null) {
            nestedCreator = this.createAddTypeCreator(project, object, string2);
        }
        if (nestedCreator == null && object instanceof DynamicElementNS && (object4 = (object3 = (DynamicElementNS)object).createDynamicElement(unknownElement == null ? "" : unknownElement.getNamespace(), string4, (String)(object2 = unknownElement == null ? string4 : unknownElement.getQName()))) != null) {
            nestedCreator = new NestedCreator(null){

                @Override
                Object create(Project project, Object object, Object object2) {
                    return object4;
                }
            };
        }
        if (nestedCreator == null && object instanceof DynamicElement && (object2 = (object3 = (DynamicElement)object).createDynamicElement(string4.toLowerCase(Locale.US))) != null) {
            nestedCreator = new NestedCreator(null){

                @Override
                Object create(Project project, Object object, Object object22) {
                    return object2;
                }
            };
        }
        if (nestedCreator == null) {
            this.throwNotSupported(project, object, string2);
        }
        return nestedCreator;
    }

    public Object createElement(Project project, Object object, String string) throws BuildException {
        NestedCreator nestedCreator = this.getNestedCreator(project, "", object, string, null);
        try {
            Object object2 = nestedCreator.create(project, object, null);
            if (project != null) {
                project.setProjectReference(object2);
            }
            return object2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new BuildException(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw IntrospectionHelper.extractBuildException(invocationTargetException);
        }
    }

    public Creator getElementCreator(Project project, String string, Object object, String string2, UnknownElement unknownElement) {
        NestedCreator nestedCreator = this.getNestedCreator(project, string, object, string2, unknownElement);
        return new Creator(project, object, nestedCreator);
    }

    public boolean isDynamic() {
        return DynamicElement.class.isAssignableFrom(this.bean) || DynamicElementNS.class.isAssignableFrom(this.bean);
    }

    public boolean isContainer() {
        return TaskContainer.class.isAssignableFrom(this.bean);
    }

    public boolean supportsNestedElement(String string) {
        return this.supportsNestedElement("", string);
    }

    public boolean supportsNestedElement(String string, String string2) {
        if (this.isDynamic() || this.addTypeMethods.size() > 0) {
            return true;
        }
        String string3 = ProjectHelper.extractNameFromComponentName(string2);
        if (!this.nestedCreators.containsKey(string3.toLowerCase(Locale.US))) {
            return false;
        }
        String string4 = ProjectHelper.extractUriFromComponentName(string2);
        if (string4.equals("antlib:org.apache.tools.ant")) {
            string4 = "";
        }
        if ("".equals(string4)) {
            return true;
        }
        if (string.equals("antlib:org.apache.tools.ant")) {
            string = "";
        }
        return string4.equals(string);
    }

    public void storeElement(Project project, Object object, Object object2, String string) throws BuildException {
        if (string == null) {
            return;
        }
        NestedCreator nestedCreator = (NestedCreator)this.nestedCreators.get(string.toLowerCase(Locale.US));
        if (nestedCreator == null) {
            return;
        }
        try {
            nestedCreator.store(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new BuildException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new BuildException(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw IntrospectionHelper.extractBuildException(invocationTargetException);
        }
    }

    private static BuildException extractBuildException(InvocationTargetException invocationTargetException) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof BuildException) {
            return (BuildException)throwable;
        }
        return new BuildException(throwable);
    }

    public Class getElementType(String string) throws BuildException {
        Class clazz = (Class)this.nestedTypes.get(string);
        if (clazz == null) {
            throw new UnsupportedElementException("Class " + this.bean.getName() + " doesn't support the nested \"" + string + "\" element.", string);
        }
        return clazz;
    }

    public Class getAttributeType(String string) throws BuildException {
        Class clazz = (Class)this.attributeTypes.get(string);
        if (clazz == null) {
            throw new UnsupportedAttributeException("Class " + this.bean.getName() + " doesn't support the \"" + string + "\" attribute.", string);
        }
        return clazz;
    }

    public Method getAddTextMethod() throws BuildException {
        if (!this.supportsCharacters()) {
            throw new BuildException("Class " + this.bean.getName() + " doesn't support nested text data.");
        }
        return this.addText;
    }

    public Method getElementMethod(String string) throws BuildException {
        Object v = this.nestedCreators.get(string);
        if (v == null) {
            throw new UnsupportedElementException("Class " + this.bean.getName() + " doesn't support the nested \"" + string + "\" element.", string);
        }
        return ((NestedCreator)v).method;
    }

    public Method getAttributeMethod(String string) throws BuildException {
        Object v = this.attributeSetters.get(string);
        if (v == null) {
            throw new UnsupportedAttributeException("Class " + this.bean.getName() + " doesn't support the \"" + string + "\" attribute.", string);
        }
        return ((AttributeSetter)v).method;
    }

    public boolean supportsCharacters() {
        return this.addText != null;
    }

    public Enumeration getAttributes() {
        return this.attributeSetters.keys();
    }

    public Map getAttributeMap() {
        return this.attributeTypes.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.attributeTypes);
    }

    public Enumeration getNestedElements() {
        return this.nestedTypes.keys();
    }

    public Map getNestedElementMap() {
        return this.nestedTypes.isEmpty() ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.nestedTypes);
    }

    public List getExtensionPoints() {
        return this.addTypeMethods.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.addTypeMethods);
    }

    private AttributeSetter createAttributeSetter(final Method method, Class clazz, final String string) {
        boolean bl;
        Constructor constructor;
        Class clazz2;
        Class clazz3 = clazz2 = PRIMITIVE_TYPE_MAP.containsKey(clazz) ? (Class)PRIMITIVE_TYPE_MAP.get(clazz) : clazz;
        if (String.class.equals((Object)clazz2)) {
            return new AttributeSetter(method){

                @Override
                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new String[]{string});
                }
            };
        }
        if (Character.class.equals((Object)clazz2)) {
            return new AttributeSetter(method){

                @Override
                public void set(Project project, Object object, String string2) throws InvocationTargetException, IllegalAccessException {
                    if (string2.length() == 0) {
                        throw new BuildException("The value \"\" is not a legal value for attribute \"" + string + "\"");
                    }
                    method.invoke(object, (Object[])new Character[]{new Character(string2.charAt(0))});
                }
            };
        }
        if (Boolean.class.equals((Object)clazz2)) {
            return new AttributeSetter(method){

                @Override
                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, (Object[])new Boolean[]{Project.toBoolean(string) ? Boolean.TRUE : Boolean.FALSE});
                }
            };
        }
        if (Class.class.equals((Object)clazz2)) {
            return new AttributeSetter(method){

                @Override
                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        method.invoke(object, Class.forName(string));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new BuildException(classNotFoundException);
                    }
                }
            };
        }
        if (File.class.equals((Object)clazz2)) {
            return new AttributeSetter(method){

                @Override
                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException {
                    method.invoke(object, project.resolveFile(string));
                }
            };
        }
        if (EnumeratedAttribute.class.isAssignableFrom(clazz2)) {
            return new AttributeSetter(method){

                @Override
                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        EnumeratedAttribute enumeratedAttribute = (EnumeratedAttribute)clazz2.newInstance();
                        enumeratedAttribute.setValue(string);
                        method.invoke(object, enumeratedAttribute);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new BuildException(instantiationException);
                    }
                }
            };
        }
        Class<?> clazz4 = null;
        try {
            clazz4 = Class.forName("java.lang.Enum");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz4 != null && clazz4.isAssignableFrom(clazz2)) {
            return new AttributeSetter(method){

                @Override
                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        method.invoke(object, clazz2.getMethod("valueOf", String.class).invoke(null, string));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        if (invocationTargetException.getTargetException() instanceof IllegalArgumentException) {
                            throw new BuildException("'" + string + "' is not a permitted value for " + clazz2.getName());
                        }
                        throw IntrospectionHelper.extractBuildException(invocationTargetException);
                    }
                    catch (Exception exception) {
                        throw new BuildException(exception);
                    }
                }
            };
        }
        if (Long.class.equals((Object)clazz2)) {
            return new AttributeSetter(method){

                @Override
                public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException, BuildException {
                    try {
                        method.invoke(object, new Long(StringUtils.parseHumanSizes(string)));
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw illegalAccessException;
                    }
                    catch (Exception exception) {
                        throw new BuildException(exception);
                    }
                }
            };
        }
        try {
            constructor = clazz2.getConstructor(Project.class, String.class);
            bl = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                constructor = clazz2.getConstructor(String.class);
                bl = false;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                return null;
            }
        }
        final boolean bl2 = bl;
        final Constructor constructor2 = constructor;
        return new AttributeSetter(method){

            @Override
            public void set(Project project, Object object, String string) throws InvocationTargetException, IllegalAccessException, BuildException {
                try {
                    Object[] objectArray;
                    if (bl2) {
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = project;
                        objectArray = objectArray2;
                        objectArray2[1] = string;
                    } else {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = string;
                    }
                    Object[] objectArray4 = objectArray;
                    Object t = constructor2.newInstance(objectArray4);
                    if (project != null) {
                        project.setProjectReference(t);
                    }
                    method.invoke(object, t);
                }
                catch (InstantiationException instantiationException) {
                    throw new BuildException(instantiationException);
                }
            }
        };
    }

    private String getElementName(Project project, Object object) {
        return project.getElementName(object);
    }

    private static String getPropertyName(String string, String string2) {
        return string.substring(string2.length()).toLowerCase(Locale.US);
    }

    public static void clearCache() {
        HELPERS.clear();
    }

    private NestedCreator createAddTypeCreator(Project project, Object object, String string) throws BuildException {
        if (this.addTypeMethods.size() == 0) {
            return null;
        }
        ComponentHelper componentHelper = ComponentHelper.getComponentHelper(project);
        Object object2 = null;
        Method method = null;
        Class clazz = componentHelper.getComponentClass(string);
        if (clazz == null) {
            return null;
        }
        method = this.findMatchingMethod(clazz, this.addTypeMethods);
        if (method == null) {
            return null;
        }
        object2 = componentHelper.createComponent(string);
        if (object2 == null) {
            return null;
        }
        Object object3 = object2;
        if (object2 instanceof PreSetDef.PreSetDefinition) {
            object3 = ((PreSetDef.PreSetDefinition)object2).createObject(project);
        }
        final Object object4 = object2;
        final Object object5 = object3;
        return new NestedCreator(method){

            @Override
            Object create(Project project, Object object, Object object2) throws InvocationTargetException, IllegalAccessException {
                if (!this.getMethod().getName().endsWith("Configured")) {
                    this.getMethod().invoke(object, object5);
                }
                return object4;
            }

            @Override
            Object getRealObject() {
                return object5;
            }

            @Override
            void store(Object object, Object object2) throws InvocationTargetException, IllegalAccessException, InstantiationException {
                if (this.getMethod().getName().endsWith("Configured")) {
                    this.getMethod().invoke(object, object5);
                }
            }
        };
    }

    private void insertAddTypeMethod(Method method) {
        Class<?> clazz = method.getParameterTypes()[0];
        for (int i = 0; i < this.addTypeMethods.size(); ++i) {
            Method method2 = (Method)this.addTypeMethods.get(i);
            if (method2.getParameterTypes()[0].equals(clazz)) {
                if (method.getName().equals("addConfigured")) {
                    this.addTypeMethods.set(i, method);
                }
                return;
            }
            if (!method2.getParameterTypes()[0].isAssignableFrom(clazz)) continue;
            this.addTypeMethods.add(i, method);
            return;
        }
        this.addTypeMethods.add(method);
    }

    private Method findMatchingMethod(Class clazz, List list) {
        Class<?> clazz2 = null;
        Method method = null;
        for (int i = 0; i < list.size(); ++i) {
            Method method2 = (Method)list.get(i);
            Class<?> clazz3 = method2.getParameterTypes()[0];
            if (!clazz3.isAssignableFrom(clazz)) continue;
            if (clazz2 == null) {
                clazz2 = clazz3;
                method = method2;
                continue;
            }
            if (clazz3.isAssignableFrom(clazz2)) continue;
            throw new BuildException("ambiguous: types " + clazz2.getName() + " and " + clazz3.getName() + " match " + clazz.getName());
        }
        return method;
    }

    private String condenseText(String string) {
        if (string.length() <= 20) {
            return string;
        }
        int n = (20 - ELLIPSIS.length()) / 2;
        return new StringBuffer(string).replace(n, string.length() - n, ELLIPSIS).toString();
    }

    static {
        Class[] classArray = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        Class[] classArray2 = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
        for (int i = 0; i < classArray.length; ++i) {
            PRIMITIVE_TYPE_MAP.put(classArray[i], classArray2[i]);
        }
    }

    private static abstract class AttributeSetter {
        private Method method;

        protected AttributeSetter(Method method) {
            this.method = method;
        }

        abstract void set(Project var1, Object var2, String var3) throws InvocationTargetException, IllegalAccessException, BuildException;
    }

    private static class AddNestedCreator
    extends NestedCreator {
        static final int ADD = 1;
        static final int ADD_CONFIGURED = 2;
        private Constructor constructor;
        private int behavior;

        AddNestedCreator(Method method, Constructor constructor, int n) {
            super(method);
            this.constructor = constructor;
            this.behavior = n;
        }

        @Override
        boolean isPolyMorphic() {
            return true;
        }

        @Override
        Object create(Project project, Object object, Object object2) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            if (object2 == null) {
                Object[] objectArray;
                if (this.constructor.getParameterTypes().length == 0) {
                    objectArray = new Object[]{};
                } else {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = project;
                }
                object2 = this.constructor.newInstance(objectArray);
            }
            if (object2 instanceof PreSetDef.PreSetDefinition) {
                object2 = ((PreSetDef.PreSetDefinition)object2).createObject(project);
            }
            if (this.behavior == 1) {
                this.istore(object, object2);
            }
            return object2;
        }

        @Override
        void store(Object object, Object object2) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            if (this.behavior == 2) {
                this.istore(object, object2);
            }
        }

        private void istore(Object object, Object object2) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            this.getMethod().invoke(object, object2);
        }
    }

    private static class CreateNestedCreator
    extends NestedCreator {
        CreateNestedCreator(Method method) {
            super(method);
        }

        @Override
        Object create(Project project, Object object, Object object2) throws InvocationTargetException, IllegalAccessException {
            return this.getMethod().invoke(object, new Object[0]);
        }
    }

    private static abstract class NestedCreator {
        private Method method;

        protected NestedCreator(Method method) {
            this.method = method;
        }

        Method getMethod() {
            return this.method;
        }

        boolean isPolyMorphic() {
            return false;
        }

        Object getRealObject() {
            return null;
        }

        abstract Object create(Project var1, Object var2, Object var3) throws InvocationTargetException, IllegalAccessException, InstantiationException;

        void store(Object object, Object object2) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        }
    }

    public static final class Creator {
        private NestedCreator nestedCreator;
        private Object parent;
        private Project project;
        private Object nestedObject;
        private String polyType;

        private Creator(Project project, Object object, NestedCreator nestedCreator) {
            this.project = project;
            this.parent = object;
            this.nestedCreator = nestedCreator;
        }

        public void setPolyType(String string) {
            this.polyType = string;
        }

        public Object create() {
            if (this.polyType != null) {
                if (!this.nestedCreator.isPolyMorphic()) {
                    throw new BuildException("Not allowed to use the polymorphic form for this element");
                }
                ComponentHelper componentHelper = ComponentHelper.getComponentHelper(this.project);
                this.nestedObject = componentHelper.createComponent(this.polyType);
                if (this.nestedObject == null) {
                    throw new BuildException("Unable to create object of type " + this.polyType);
                }
            }
            try {
                this.nestedObject = this.nestedCreator.create(this.project, this.parent, this.nestedObject);
                if (this.project != null) {
                    this.project.setProjectReference(this.nestedObject);
                }
                return this.nestedObject;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BuildException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new BuildException(instantiationException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.polyType == null) {
                    throw illegalArgumentException;
                }
                throw new BuildException("Invalid type used " + this.polyType);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw IntrospectionHelper.extractBuildException(invocationTargetException);
            }
        }

        public Object getRealObject() {
            return this.nestedCreator.getRealObject();
        }

        public void store() {
            try {
                this.nestedCreator.store(this.parent, this.nestedObject);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BuildException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new BuildException(instantiationException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (this.polyType == null) {
                    throw illegalArgumentException;
                }
                throw new BuildException("Invalid type used " + this.polyType);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw IntrospectionHelper.extractBuildException(invocationTargetException);
            }
        }
    }
}

