/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.WeakHashMap;
import org.apache.tools.ant.Project;

public class DemuxOutputStream
extends OutputStream {
    private static final int MAX_SIZE = 1024;
    private static final int INTIAL_SIZE = 132;
    private static final int CR = 13;
    private static final int LF = 10;
    private WeakHashMap buffers = new WeakHashMap();
    private Project project;
    private boolean isErrorStream;

    public DemuxOutputStream(Project project, boolean bl) {
        this.project = project;
        this.isErrorStream = bl;
    }

    private BufferInfo getBufferInfo() {
        Thread thread = Thread.currentThread();
        BufferInfo bufferInfo = (BufferInfo)this.buffers.get(thread);
        if (bufferInfo == null) {
            bufferInfo = new BufferInfo();
            bufferInfo.buffer = new ByteArrayOutputStream(132);
            bufferInfo.crSeen = false;
            this.buffers.put(thread, bufferInfo);
        }
        return bufferInfo;
    }

    private void resetBufferInfo() {
        Thread thread = Thread.currentThread();
        BufferInfo bufferInfo = (BufferInfo)this.buffers.get(thread);
        try {
            bufferInfo.buffer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        bufferInfo.buffer = new ByteArrayOutputStream();
        bufferInfo.crSeen = false;
    }

    private void removeBuffer() {
        Thread thread = Thread.currentThread();
        this.buffers.remove(thread);
    }

    @Override
    public void write(int n) throws IOException {
        byte by = (byte)n;
        BufferInfo bufferInfo = this.getBufferInfo();
        if (by == 10) {
            bufferInfo.buffer.write(n);
            this.processBuffer(bufferInfo.buffer);
        } else {
            if (bufferInfo.crSeen) {
                this.processBuffer(bufferInfo.buffer);
            }
            bufferInfo.buffer.write(n);
        }
        bufferInfo.crSeen = by == 13;
        if (!bufferInfo.crSeen && bufferInfo.buffer.size() > 1024) {
            this.processBuffer(bufferInfo.buffer);
        }
    }

    protected void processBuffer(ByteArrayOutputStream byteArrayOutputStream) {
        String string = byteArrayOutputStream.toString();
        this.project.demuxOutput(string, this.isErrorStream);
        this.resetBufferInfo();
    }

    protected void processFlush(ByteArrayOutputStream byteArrayOutputStream) {
        String string = byteArrayOutputStream.toString();
        this.project.demuxFlush(string, this.isErrorStream);
        this.resetBufferInfo();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.removeBuffer();
    }

    @Override
    public void flush() throws IOException {
        BufferInfo bufferInfo = this.getBufferInfo();
        if (bufferInfo.buffer.size() > 0) {
            this.processFlush(bufferInfo.buffer);
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n3 = n;
        int n5 = n2;
        BufferInfo bufferInfo = this.getBufferInfo();
        while (n5 > 0) {
            while (n5 > 0 && byArray[n3] != 10 && byArray[n3] != 13) {
                ++n3;
                --n5;
            }
            int n6 = n3 - n4;
            if (n6 > 0) {
                bufferInfo.buffer.write(byArray, n4, n6);
            }
            while (n5 > 0 && (byArray[n3] == 10 || byArray[n3] == 13)) {
                this.write(byArray[n3]);
                ++n3;
                --n5;
            }
            n4 = n3;
        }
    }

    private static class BufferInfo {
        private ByteArrayOutputStream buffer;
        private boolean crSeen = false;

        private BufferInfo() {
        }
    }
}

