/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskAdapter;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.launch.Launcher;
import org.apache.tools.ant.taskdefs.Definer;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.taskdefs.Typedef;
import org.apache.tools.ant.util.FileUtils;

public class ComponentHelper {
    private AntTypeTable antTypeTable;
    private Hashtable taskClassDefinitions = new Hashtable();
    private boolean rebuildTaskClassDefinitions = true;
    private Hashtable typeClassDefinitions = new Hashtable();
    private boolean rebuildTypeClassDefinitions = true;
    private Set checkedNamespaces = new HashSet();
    private Stack antLibStack = new Stack();
    private String antLibCurrentUri = null;
    private ComponentHelper next;
    private Project project;
    private static final String ERROR_NO_TASK_LIST_LOAD = "Can't load default task list";
    private static final String ERROR_NO_TYPE_LIST_LOAD = "Can't load default type list";
    public static final String COMPONENT_HELPER_REFERENCE = "ant.ComponentHelper";
    private static final String BUILD_SYSCLASSPATH_ONLY = "only";
    private static final String ANT_PROPERTY_TASK = "property";
    private static Properties[] defaultDefinitions = new Properties[2];

    public static ComponentHelper getComponentHelper(Project project) {
        if (project == null) {
            return null;
        }
        ComponentHelper componentHelper = (ComponentHelper)project.getReference(COMPONENT_HELPER_REFERENCE);
        if (componentHelper != null) {
            return componentHelper;
        }
        componentHelper = new ComponentHelper();
        componentHelper.setProject(project);
        project.addReference(COMPONENT_HELPER_REFERENCE, componentHelper);
        return componentHelper;
    }

    protected ComponentHelper() {
    }

    public void setNext(ComponentHelper componentHelper) {
        this.next = componentHelper;
    }

    public ComponentHelper getNext() {
        return this.next;
    }

    public void setProject(Project project) {
        this.project = project;
        this.antTypeTable = new AntTypeTable(project);
    }

    public void initSubProject(ComponentHelper componentHelper) {
        AntTypeTable antTypeTable = componentHelper.antTypeTable;
        for (AntTypeDefinition antTypeDefinition : antTypeTable.values()) {
            this.antTypeTable.put(antTypeDefinition.getName(), antTypeDefinition);
        }
        Iterator<Object> iterator = componentHelper.checkedNamespaces.iterator();
        while (iterator.hasNext()) {
            this.checkedNamespaces.add(iterator.next());
        }
    }

    public Object createComponent(UnknownElement unknownElement, String string, String string2) throws BuildException {
        Object object = this.createComponent(string2);
        if (object instanceof Task) {
            Task task = (Task)object;
            task.setLocation(unknownElement.getLocation());
            task.setTaskType(string2);
            task.setTaskName(unknownElement.getTaskName());
            task.setOwningTarget(unknownElement.getOwningTarget());
            task.init();
        }
        return object;
    }

    public Object createComponent(String string) {
        AntTypeDefinition antTypeDefinition = this.getDefinition(string);
        return antTypeDefinition == null ? null : antTypeDefinition.create(this.project);
    }

    public Class getComponentClass(String string) {
        AntTypeDefinition antTypeDefinition = this.getDefinition(string);
        return antTypeDefinition == null ? null : antTypeDefinition.getExposedClass(this.project);
    }

    public AntTypeDefinition getDefinition(String string) {
        this.checkNamespace(string);
        return this.antTypeTable.getDefinition(string);
    }

    public void initDefaultDefinitions() {
        this.initTasks();
        this.initTypes();
    }

    public void addTaskDefinition(String string, Class clazz) {
        this.checkTaskClass(clazz);
        AntTypeDefinition antTypeDefinition = new AntTypeDefinition();
        antTypeDefinition.setName(string);
        antTypeDefinition.setClassLoader(clazz.getClassLoader());
        antTypeDefinition.setClass(clazz);
        antTypeDefinition.setAdapterClass(TaskAdapter.class);
        antTypeDefinition.setClassName(clazz.getName());
        antTypeDefinition.setAdaptToClass(Task.class);
        this.updateDataTypeDefinition(antTypeDefinition);
    }

    public void checkTaskClass(Class clazz) throws BuildException {
        if (!Modifier.isPublic(clazz.getModifiers())) {
            String string = clazz + " is not public";
            this.project.log(string, 0);
            throw new BuildException(string);
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            String string = clazz + " is abstract";
            this.project.log(string, 0);
            throw new BuildException(string);
        }
        try {
            clazz.getConstructor(null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = "No public no-arg constructor in " + clazz;
            this.project.log(string, 0);
            throw new BuildException(string);
        }
        if (!Task.class.isAssignableFrom(clazz)) {
            TaskAdapter.checkTaskClass(clazz, this.project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getTaskDefinitions() {
        Hashtable hashtable = this.taskClassDefinitions;
        synchronized (hashtable) {
            AntTypeTable antTypeTable = this.antTypeTable;
            synchronized (antTypeTable) {
                if (this.rebuildTaskClassDefinitions) {
                    this.taskClassDefinitions.clear();
                    for (String string : this.antTypeTable.keySet()) {
                        Class clazz = this.antTypeTable.getExposedClass(string);
                        if (clazz == null || !Task.class.isAssignableFrom(clazz)) continue;
                        this.taskClassDefinitions.put(string, this.antTypeTable.getTypeClass(string));
                    }
                    this.rebuildTaskClassDefinitions = false;
                }
            }
        }
        return this.taskClassDefinitions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDataTypeDefinitions() {
        Hashtable hashtable = this.typeClassDefinitions;
        synchronized (hashtable) {
            AntTypeTable antTypeTable = this.antTypeTable;
            synchronized (antTypeTable) {
                if (this.rebuildTypeClassDefinitions) {
                    this.typeClassDefinitions.clear();
                    for (String string : this.antTypeTable.keySet()) {
                        Class clazz = this.antTypeTable.getExposedClass(string);
                        if (clazz == null || Task.class.isAssignableFrom(clazz)) continue;
                        this.typeClassDefinitions.put(string, this.antTypeTable.getTypeClass(string));
                    }
                    this.rebuildTypeClassDefinitions = false;
                }
            }
        }
        return this.typeClassDefinitions;
    }

    public void addDataTypeDefinition(String string, Class clazz) {
        AntTypeDefinition antTypeDefinition = new AntTypeDefinition();
        antTypeDefinition.setName(string);
        antTypeDefinition.setClass(clazz);
        this.updateDataTypeDefinition(antTypeDefinition);
        this.project.log(" +User datatype: " + string + "     " + clazz.getName(), 4);
    }

    public void addDataTypeDefinition(AntTypeDefinition antTypeDefinition) {
        this.updateDataTypeDefinition(antTypeDefinition);
    }

    public Hashtable getAntTypeTable() {
        return this.antTypeTable;
    }

    public Task createTask(String string) throws BuildException {
        Task task = this.createNewTask(string);
        if (task == null && string.equals(ANT_PROPERTY_TASK)) {
            this.addTaskDefinition(ANT_PROPERTY_TASK, Property.class);
            task = this.createNewTask(string);
        }
        return task;
    }

    private Task createNewTask(String string) throws BuildException {
        Class clazz = this.getComponentClass(string);
        if (clazz == null || !Task.class.isAssignableFrom(clazz)) {
            return null;
        }
        Object object = this.createComponent(string);
        if (object == null) {
            return null;
        }
        if (!(object instanceof Task)) {
            throw new BuildException("Expected a Task from '" + string + "' but got an instance of " + object.getClass().getName() + " instead");
        }
        Task task = (Task)object;
        task.setTaskType(string);
        task.setTaskName(string);
        this.project.log("   +Task: " + string, 4);
        return task;
    }

    public Object createDataType(String string) throws BuildException {
        return this.createComponent(string);
    }

    public String getElementName(Object object) {
        return this.getElementName(object, false);
    }

    public String getElementName(Object object, boolean bl) {
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        for (AntTypeDefinition antTypeDefinition : this.antTypeTable.values()) {
            if (!string.equals(antTypeDefinition.getClassName()) || clazz != antTypeDefinition.getExposedClass(this.project)) continue;
            String string2 = antTypeDefinition.getName();
            return bl ? string2 : "The <" + string2 + "> type";
        }
        return ComponentHelper.getUnmappedElementName(object.getClass(), bl);
    }

    public static String getElementName(Project project, Object object, boolean bl) {
        if (project == null) {
            project = Project.getProject(object);
        }
        return project == null ? ComponentHelper.getUnmappedElementName(object.getClass(), bl) : ComponentHelper.getComponentHelper(project).getElementName(object, bl);
    }

    private static String getUnmappedElementName(Class clazz, boolean bl) {
        if (bl) {
            String string = clazz.getName();
            return string.substring(string.lastIndexOf(46) + 1);
        }
        return clazz.toString();
    }

    private boolean validDefinition(AntTypeDefinition antTypeDefinition) {
        return antTypeDefinition.getTypeClass(this.project) != null && antTypeDefinition.getExposedClass(this.project) != null;
    }

    private boolean sameDefinition(AntTypeDefinition antTypeDefinition, AntTypeDefinition antTypeDefinition2) {
        boolean bl = this.validDefinition(antTypeDefinition);
        boolean bl2 = bl == this.validDefinition(antTypeDefinition2);
        return bl2 && (!bl || antTypeDefinition.sameDefinition(antTypeDefinition2, this.project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataTypeDefinition(AntTypeDefinition antTypeDefinition) {
        String string = antTypeDefinition.getName();
        AntTypeTable antTypeTable = this.antTypeTable;
        synchronized (antTypeTable) {
            this.rebuildTaskClassDefinitions = true;
            this.rebuildTypeClassDefinitions = true;
            AntTypeDefinition antTypeDefinition2 = this.antTypeTable.getDefinition(string);
            if (antTypeDefinition2 != null) {
                if (this.sameDefinition(antTypeDefinition, antTypeDefinition2)) {
                    return;
                }
                Class clazz = this.antTypeTable.getExposedClass(string);
                boolean bl = clazz != null && Task.class.isAssignableFrom(clazz);
                this.project.log("Trying to override old definition of " + (bl ? "task " : "datatype ") + string, antTypeDefinition.similarDefinition(antTypeDefinition2, this.project) ? 3 : 1);
            }
            this.project.log(" +Datatype " + string + " " + antTypeDefinition.getClassName(), 4);
            this.antTypeTable.put(string, antTypeDefinition);
        }
    }

    public void enterAntLib(String string) {
        this.antLibCurrentUri = string;
        this.antLibStack.push(string);
    }

    public String getCurrentAntlibUri() {
        return this.antLibCurrentUri;
    }

    public void exitAntLib() {
        this.antLibStack.pop();
        this.antLibCurrentUri = this.antLibStack.size() == 0 ? null : (String)this.antLibStack.peek();
    }

    private void initTasks() {
        ClassLoader classLoader = this.getClassLoader(null);
        Properties properties = ComponentHelper.getDefaultDefinitions(false);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            AntTypeDefinition antTypeDefinition = new AntTypeDefinition();
            antTypeDefinition.setName(string);
            antTypeDefinition.setClassName(string2);
            antTypeDefinition.setClassLoader(classLoader);
            antTypeDefinition.setAdaptToClass(Task.class);
            antTypeDefinition.setAdapterClass(TaskAdapter.class);
            this.antTypeTable.put(string, antTypeDefinition);
        }
    }

    private ClassLoader getClassLoader(ClassLoader classLoader) {
        String string = this.project.getProperty("build.sysclasspath");
        if (this.project.getCoreLoader() != null && !BUILD_SYSCLASSPATH_ONLY.equals(string)) {
            classLoader = this.project.getCoreLoader();
        }
        return classLoader;
    }

    private static synchronized Properties getDefaultDefinitions(boolean bl) throws BuildException {
        int n;
        int n2 = n = bl ? 1 : 0;
        if (defaultDefinitions[n] == null) {
            String string = bl ? "/org/apache/tools/ant/types/defaults.properties" : "/org/apache/tools/ant/taskdefs/defaults.properties";
            String string2 = bl ? ERROR_NO_TYPE_LIST_LOAD : ERROR_NO_TASK_LIST_LOAD;
            InputStream inputStream = null;
            try {
                inputStream = ComponentHelper.class.getResourceAsStream(string);
                if (inputStream == null) {
                    throw new BuildException(string2);
                }
                Properties properties = new Properties();
                properties.load(inputStream);
                ComponentHelper.defaultDefinitions[n] = properties;
            }
            catch (IOException iOException) {
                throw new BuildException(string2, iOException);
            }
            finally {
                FileUtils.close(inputStream);
            }
        }
        return defaultDefinitions[n];
    }

    private void initTypes() {
        ClassLoader classLoader = this.getClassLoader(null);
        Properties properties = ComponentHelper.getDefaultDefinitions(true);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            AntTypeDefinition antTypeDefinition = new AntTypeDefinition();
            antTypeDefinition.setName(string);
            antTypeDefinition.setClassName(string2);
            antTypeDefinition.setClassLoader(classLoader);
            this.antTypeTable.put(string, antTypeDefinition);
        }
    }

    private synchronized void checkNamespace(String string) {
        String string2 = ProjectHelper.extractUriFromComponentName(string);
        if ("".equals(string2)) {
            string2 = "antlib:org.apache.tools.ant";
        }
        if (!string2.startsWith("antlib:")) {
            return;
        }
        if (this.checkedNamespaces.contains(string2)) {
            return;
        }
        this.checkedNamespaces.add(string2);
        Typedef typedef = new Typedef();
        typedef.setProject(this.project);
        typedef.init();
        typedef.setURI(string2);
        typedef.setTaskName(string2);
        typedef.setResource(Definer.makeResourceFromURI(string2));
        typedef.setOnError(new Definer.OnError("ignore"));
        typedef.execute();
    }

    public String diagnoseCreationFailure(String string, String string2) {
        String string3;
        Comparable<File> comparable;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Problem: failed to create " + string2 + " " + string);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string4 = System.getProperty("user.home");
        File file = new File(string4, Launcher.USER_LIBDIR);
        boolean bl4 = false;
        String string5 = System.getProperty("ant.home");
        if (string5 != null) {
            comparable = new File(string5, "lib");
            string3 = ((File)comparable).getAbsolutePath();
        } else {
            bl4 = true;
            string3 = "ANT_HOME" + File.separatorChar + "lib";
        }
        comparable = new StringBuffer();
        ((StringBuffer)comparable).append("        -");
        ((StringBuffer)comparable).append(string3);
        ((StringBuffer)comparable).append('\n');
        if (bl4) {
            ((StringBuffer)comparable).append("        -");
            ((StringBuffer)comparable).append("the IDE Ant configuration dialogs");
        } else {
            ((StringBuffer)comparable).append("        -");
            ((StringBuffer)comparable).append(file);
            ((StringBuffer)comparable).append('\n');
            ((StringBuffer)comparable).append("        -");
            ((StringBuffer)comparable).append("a directory added on the command line with the -lib argument");
        }
        String string6 = ((StringBuffer)comparable).toString();
        AntTypeDefinition antTypeDefinition = this.getDefinition(string);
        if (antTypeDefinition == null) {
            this.printUnknownDefinition(printWriter, string, string6);
            bl3 = true;
        } else {
            String string7 = antTypeDefinition.getClassName();
            boolean bl5 = string7.startsWith("org.apache.tools.ant.");
            boolean bl6 = string7.startsWith("org.apache.tools.ant.taskdefs.optional");
            bl6 |= string7.startsWith("org.apache.tools.ant.types.optional");
            Class clazz = null;
            try {
                clazz = antTypeDefinition.innerGetTypeClass();
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl2 = true;
                if (!bl6) {
                    bl3 = true;
                }
                this.printClassNotFound(printWriter, string7, bl6, string6);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                bl2 = true;
                this.printNotLoadDependentClass(printWriter, bl6, noClassDefFoundError, string6);
            }
            if (clazz != null) {
                try {
                    antTypeDefinition.innerCreateAndSet(clazz, this.project);
                    printWriter.println("The component could be instantiated.");
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    bl = true;
                    printWriter.println("Cause: The class " + string7 + " has no compatible constructor.");
                }
                catch (InstantiationException instantiationException) {
                    bl = true;
                    printWriter.println("Cause: The class " + string7 + " is abstract and cannot be instantiated.");
                }
                catch (IllegalAccessException illegalAccessException) {
                    bl = true;
                    printWriter.println("Cause: The constructor for " + string7 + " is private and cannot be invoked.");
                }
                catch (InvocationTargetException invocationTargetException) {
                    bl = true;
                    Throwable throwable = invocationTargetException.getTargetException();
                    printWriter.println("Cause: The constructor threw the exception");
                    printWriter.println(throwable.toString());
                    throwable.printStackTrace(printWriter);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    bl2 = true;
                    printWriter.println("Cause:  A class needed by class " + string7 + " cannot be found: ");
                    printWriter.println("       " + noClassDefFoundError.getMessage());
                    printWriter.println("Action: Determine what extra JAR files are needed, and place them in:");
                    printWriter.println(string6);
                }
            }
            printWriter.println();
            printWriter.println("Do not panic, this is a common problem.");
            if (bl3) {
                printWriter.println("It may just be a typographical error in the build file or the task/type declaration.");
            }
            if (bl2) {
                printWriter.println("The commonest cause is a missing JAR.");
            }
            if (bl) {
                printWriter.println("This is quite a low level problem, which may need consultation with the author of the task.");
                if (bl5) {
                    printWriter.println("This may be the Ant team. Please file a defect or contact the developer team.");
                } else {
                    printWriter.println("This does not appear to be a task bundled with Ant.");
                    printWriter.println("Please take it up with the supplier of the third-party " + string2 + ".");
                    printWriter.println("If you have written it yourself, you probably have a bug to fix.");
                }
            } else {
                printWriter.println();
                printWriter.println("This is not a bug; it is a configuration problem");
            }
        }
        printWriter.flush();
        printWriter.close();
        return stringWriter.toString();
    }

    private void printUnknownDefinition(PrintWriter printWriter, String string, String string2) {
        boolean bl = string.indexOf("antlib:") == 0;
        String string3 = ProjectHelper.extractUriFromComponentName(string);
        printWriter.println("Cause: The name is undefined.");
        printWriter.println("Action: Check the spelling.");
        printWriter.println("Action: Check that any custom tasks/types have been declared.");
        printWriter.println("Action: Check that any <presetdef>/<macrodef> declarations have taken place.");
        if (string3.length() > 0) {
            List list = this.antTypeTable.findMatches(string3);
            if (list.size() > 0) {
                printWriter.println();
                printWriter.println("The definitions in the namespace " + string3 + " are:");
                for (AntTypeDefinition antTypeDefinition : list) {
                    String string4 = ProjectHelper.extractNameFromComponentName(antTypeDefinition.getName());
                    printWriter.println("    " + string4);
                }
            } else {
                printWriter.println("No types or tasks have been defined in this namespace yet");
                if (bl) {
                    printWriter.println();
                    printWriter.println("This appears to be an antlib declaration. ");
                    printWriter.println("Action: Check that the implementing library exists in one of:");
                    printWriter.println(string2);
                }
            }
        }
    }

    private void printClassNotFound(PrintWriter printWriter, String string, boolean bl, String string2) {
        printWriter.println("Cause: the class " + string + " was not found.");
        if (bl) {
            printWriter.println("        This looks like one of Ant's optional components.");
            printWriter.println("Action: Check that the appropriate optional JAR exists in");
            printWriter.println(string2);
        } else {
            printWriter.println("Action: Check that the component has been correctly declared");
            printWriter.println("        and that the implementing JAR is in one of:");
            printWriter.println(string2);
        }
    }

    private void printNotLoadDependentClass(PrintWriter printWriter, boolean bl, NoClassDefFoundError noClassDefFoundError, String string) {
        printWriter.println("Cause: Could not load a dependent class " + noClassDefFoundError.getMessage());
        if (bl) {
            printWriter.println("       It is not enough to have Ant's optional JARs");
            printWriter.println("       you need the JAR files that the optional tasks depend upon.");
            printWriter.println("       Ant's optional task dependencies are listed in the manual.");
        } else {
            printWriter.println("       This class may be in a separate JAR that is not installed.");
        }
        printWriter.println("Action: Determine what extra JAR files are needed, and place them in one of:");
        printWriter.println(string);
    }

    private static class AntTypeTable
    extends Hashtable {
        private static final long serialVersionUID = -3060442320477772028L;
        private Project project;

        AntTypeTable(Project project) {
            this.project = project;
        }

        AntTypeDefinition getDefinition(String string) {
            return (AntTypeDefinition)super.get(string);
        }

        @Override
        public Object get(Object object) {
            return this.getTypeClass((String)object);
        }

        Object create(String string) {
            AntTypeDefinition antTypeDefinition = this.getDefinition(string);
            return antTypeDefinition == null ? null : antTypeDefinition.create(this.project);
        }

        Class getTypeClass(String string) {
            AntTypeDefinition antTypeDefinition = this.getDefinition(string);
            return antTypeDefinition == null ? null : antTypeDefinition.getTypeClass(this.project);
        }

        Class getExposedClass(String string) {
            AntTypeDefinition antTypeDefinition = this.getDefinition(string);
            return antTypeDefinition == null ? null : antTypeDefinition.getExposedClass(this.project);
        }

        @Override
        public boolean contains(Object object) {
            boolean bl = false;
            if (object instanceof Class) {
                Iterator iterator = this.values().iterator();
                while (iterator.hasNext() && !bl) {
                    bl = ((AntTypeDefinition)iterator.next()).getExposedClass(this.project) == object;
                }
            }
            return bl;
        }

        @Override
        public boolean containsValue(Object object) {
            return this.contains(object);
        }

        public List findMatches(String string) {
            ArrayList<AntTypeDefinition> arrayList = new ArrayList<AntTypeDefinition>();
            for (AntTypeDefinition antTypeDefinition : this.values()) {
                if (!antTypeDefinition.getName().startsWith(string)) continue;
                arrayList.add(antTypeDefinition);
            }
            return arrayList;
        }
    }
}

