/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.apache.tools.ant.Location;

public class BuildException
extends RuntimeException {
    private static final long serialVersionUID = -5419014565354664240L;
    private Throwable cause;
    private Location location = Location.UNKNOWN_LOCATION;

    public BuildException() {
    }

    public BuildException(String string) {
        super(string);
    }

    public BuildException(String string, Throwable throwable) {
        super(string);
        this.cause = throwable;
    }

    public BuildException(String string, Throwable throwable, Location location) {
        this(string, throwable);
        this.location = location;
    }

    public BuildException(Throwable throwable) {
        super(throwable.toString());
        this.cause = throwable;
    }

    public BuildException(String string, Location location) {
        super(string);
        this.location = location;
    }

    public BuildException(Throwable throwable, Location location) {
        this(throwable);
        this.location = location;
    }

    public Throwable getException() {
        return this.cause;
    }

    @Override
    public Throwable getCause() {
        return this.getException();
    }

    @Override
    public String toString() {
        return this.location.toString() + this.getMessage();
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Location getLocation() {
        return this.location;
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintStream printStream) {
        PrintStream printStream2 = printStream;
        synchronized (printStream2) {
            super.printStackTrace(printStream);
            if (this.cause != null) {
                printStream.println("--- Nested Exception ---");
                this.cause.printStackTrace(printStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printStackTrace(PrintWriter printWriter) {
        PrintWriter printWriter2 = printWriter;
        synchronized (printWriter2) {
            super.printStackTrace(printWriter);
            if (this.cause != null) {
                printWriter.println("--- Nested Exception ---");
                this.cause.printStackTrace(printWriter);
            }
        }
    }
}

