/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.launch.Locator;
import org.apache.tools.ant.taskdefs.Manifest;
import org.apache.tools.ant.taskdefs.ManifestException;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.CollectionUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LoaderUtils;

public class AntClassLoader
extends ClassLoader
implements SubBuildListener {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final int BUFFER_SIZE = 8192;
    private static final int NUMBER_OF_STRINGS = 256;
    private Vector pathComponents = new Vector();
    private Project project;
    private boolean parentFirst = true;
    private Vector systemPackages = new Vector();
    private Vector loaderPackages = new Vector();
    private boolean ignoreBase = false;
    private ClassLoader parent = null;
    private Hashtable zipFiles = new Hashtable();
    private static Map pathMap = Collections.synchronizedMap(new HashMap());
    private ClassLoader savedContextLoader = null;
    private boolean isContextLoaderSaved = false;

    public AntClassLoader(ClassLoader classLoader, Project project, Path path) {
        this.setParent(classLoader);
        this.setClassPath(path);
        this.setProject(project);
    }

    public AntClassLoader() {
        this.setParent(null);
    }

    public AntClassLoader(Project project, Path path) {
        this.setParent(null);
        this.setProject(project);
        this.setClassPath(path);
    }

    public AntClassLoader(ClassLoader classLoader, Project project, Path path, boolean bl) {
        this(project, path);
        if (classLoader != null) {
            this.setParent(classLoader);
        }
        this.setParentFirst(bl);
        this.addJavaLibraries();
    }

    public AntClassLoader(Project project, Path path, boolean bl) {
        this(null, project, path, bl);
    }

    public AntClassLoader(ClassLoader classLoader, boolean bl) {
        this.setParent(classLoader);
        this.project = null;
        this.parentFirst = bl;
    }

    public void setProject(Project project) {
        this.project = project;
        if (project != null) {
            project.addBuildListener(this);
        }
    }

    public void setClassPath(Path path) {
        this.pathComponents.removeAllElements();
        if (path != null) {
            Path path2 = path.concatSystemClasspath("ignore");
            String[] stringArray = path2.list();
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    this.addPathElement(stringArray[i]);
                    continue;
                }
                catch (BuildException buildException) {
                    // empty catch block
                }
            }
        }
    }

    public void setParent(ClassLoader classLoader) {
        this.parent = classLoader == null ? AntClassLoader.class.getClassLoader() : classLoader;
    }

    public void setParentFirst(boolean bl) {
        this.parentFirst = bl;
    }

    protected void log(String string, int n) {
        if (this.project != null) {
            this.project.log(string, n);
        }
    }

    public void setThreadContextLoader() {
        if (this.isContextLoaderSaved) {
            throw new BuildException("Context loader has not been reset");
        }
        if (LoaderUtils.isContextLoaderAvailable()) {
            this.savedContextLoader = LoaderUtils.getContextClassLoader();
            ClassLoader classLoader = this;
            if (this.project != null && "only".equals(this.project.getProperty("build.sysclasspath"))) {
                classLoader = this.getClass().getClassLoader();
            }
            LoaderUtils.setContextClassLoader(classLoader);
            this.isContextLoaderSaved = true;
        }
    }

    public void resetThreadContextLoader() {
        if (LoaderUtils.isContextLoaderAvailable() && this.isContextLoaderSaved) {
            LoaderUtils.setContextClassLoader(this.savedContextLoader);
            this.savedContextLoader = null;
            this.isContextLoaderSaved = false;
        }
    }

    public void addPathElement(String string) throws BuildException {
        File file = this.project != null ? this.project.resolveFile(string) : new File(string);
        try {
            this.addPathFile(file);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public void addPathComponent(File file) {
        if (this.pathComponents.contains(file)) {
            return;
        }
        this.pathComponents.addElement(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void addPathFile(File file) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string;
        block16: {
            String string2;
            block15: {
                block14: {
                    this.pathComponents.addElement(file);
                    if (file.isDirectory()) {
                        return;
                    }
                    string2 = file.getAbsolutePath() + file.lastModified() + "-" + file.length();
                    string = (String)pathMap.get(string2);
                    if (string != null) break block16;
                    object4 = null;
                    object3 = null;
                    object4 = new ZipFile(file);
                    object3 = ((ZipFile)object4).getInputStream(new ZipEntry("META-INF/MANIFEST.MF"));
                    if (object3 != null) break block14;
                    FileUtils.close((InputStream)object3);
                    if (object4 != null) {
                        ((ZipFile)object4).close();
                    }
                    return;
                }
                try {
                    object2 = new InputStreamReader((InputStream)object3, "UTF-8");
                    object = new Manifest((Reader)object2);
                    string = ((Manifest)object).getMainSection().getAttributeValue("Class-Path");
                }
                catch (ManifestException manifestException) {
                    FileUtils.close(object3);
                    if (object4 != null) {
                        ((ZipFile)object4).close();
                    }
                    break block15;
                    catch (Throwable throwable) {
                        FileUtils.close(object3);
                        if (object4 != null) {
                            ((ZipFile)object4).close();
                        }
                        throw throwable;
                    }
                }
                FileUtils.close((InputStream)object3);
                if (object4 != null) {
                    ((ZipFile)object4).close();
                }
            }
            if (string == null) {
                string = "";
            }
            pathMap.put(string2, string);
        }
        if (!"".equals(string)) {
            object4 = FILE_UTILS.getFileURL(file);
            object3 = new StringTokenizer(string);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken();
                object = new URL((URL)object4, (String)object2);
                if (!((URL)object).getProtocol().equals("file")) {
                    this.log("Skipping jar library " + (String)object2 + " since only relative URLs are supported by this" + " loader", 3);
                    continue;
                }
                String string3 = Locator.decodeUri((String)((URL)object).getFile());
                File file2 = new File(string3);
                if (!file2.exists() || this.isInPath(file2)) continue;
                this.addPathFile(file2);
            }
        }
    }

    public String getClasspath() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        Enumeration enumeration = this.pathComponents.elements();
        while (enumeration.hasMoreElements()) {
            if (!bl) {
                stringBuffer.append(System.getProperty("path.separator"));
            } else {
                bl = false;
            }
            stringBuffer.append(((File)enumeration.nextElement()).getAbsolutePath());
        }
        return stringBuffer.toString();
    }

    public synchronized void setIsolated(boolean bl) {
        this.ignoreBase = bl;
    }

    public static void initializeClass(Class clazz) {
        Constructor<?>[] constructorArray = clazz.getDeclaredConstructors();
        if (constructorArray != null && constructorArray.length > 0 && constructorArray[0] != null) {
            String[] stringArray = new String[256];
            try {
                constructorArray[0].newInstance(stringArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void addSystemPackageRoot(String string) {
        this.systemPackages.addElement(string + (string.endsWith(".") ? "" : "."));
    }

    public void addLoaderPackageRoot(String string) {
        this.loaderPackages.addElement(string + (string.endsWith(".") ? "" : "."));
    }

    public Class forceLoadClass(String string) throws ClassNotFoundException {
        this.log("force loading " + string, 4);
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.findClass(string);
        }
        return clazz;
    }

    public Class forceLoadSystemClass(String string) throws ClassNotFoundException {
        this.log("force system loading " + string, 4);
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            clazz = this.findBaseClass(string);
        }
        return clazz;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.isParentFirst(string)) {
            inputStream = this.loadBaseResource(string);
            if (inputStream != null) {
                this.log("ResourceStream for " + string + " loaded from parent loader", 4);
            } else {
                inputStream = this.loadResource(string);
                if (inputStream != null) {
                    this.log("ResourceStream for " + string + " loaded from ant loader", 4);
                }
            }
        } else {
            inputStream = this.loadResource(string);
            if (inputStream != null) {
                this.log("ResourceStream for " + string + " loaded from ant loader", 4);
            } else {
                inputStream = this.loadBaseResource(string);
                if (inputStream != null) {
                    this.log("ResourceStream for " + string + " loaded from parent loader", 4);
                }
            }
        }
        if (inputStream == null) {
            this.log("Couldn't load ResourceStream for " + string, 4);
        }
        return inputStream;
    }

    private InputStream loadResource(String string) {
        InputStream inputStream = null;
        Enumeration enumeration = this.pathComponents.elements();
        while (enumeration.hasMoreElements() && inputStream == null) {
            File file = (File)enumeration.nextElement();
            inputStream = this.getResourceStream(file, string);
        }
        return inputStream;
    }

    private InputStream loadBaseResource(String string) {
        if (this.parent == null) {
            return AntClassLoader.getSystemResourceAsStream(string);
        }
        return this.parent.getResourceAsStream(string);
    }

    private InputStream getResourceStream(File file, String string) {
        try {
            ZipFile zipFile = (ZipFile)this.zipFiles.get(file);
            if (zipFile == null && file.isDirectory()) {
                File file2 = new File(file, string);
                if (file2.exists()) {
                    return new FileInputStream(file2);
                }
            } else {
                ZipEntry zipEntry;
                if (zipFile == null) {
                    if (!file.exists()) {
                        return null;
                    }
                    zipFile = new ZipFile(file);
                    this.zipFiles.put(file, zipFile);
                    zipFile = (ZipFile)this.zipFiles.get(file);
                }
                if ((zipEntry = zipFile.getEntry(string)) != null) {
                    return zipFile.getInputStream(zipEntry);
                }
            }
        }
        catch (Exception exception) {
            this.log("Ignoring Exception " + exception.getClass().getName() + ": " + exception.getMessage() + " reading resource " + string + " from " + file, 3);
        }
        return null;
    }

    private boolean isParentFirst(String string) {
        String string2;
        boolean bl = this.parentFirst;
        Enumeration enumeration = this.systemPackages.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string.startsWith(string2)) continue;
            bl = true;
            break;
        }
        enumeration = this.loaderPackages.elements();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string.startsWith(string2)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private ClassLoader getRootLoader() {
        ClassLoader classLoader;
        for (classLoader = this.getClass().getClassLoader(); classLoader != null && classLoader.getParent() != null; classLoader = classLoader.getParent()) {
        }
        return classLoader;
    }

    @Override
    public URL getResource(String string) {
        URL uRL = null;
        if (this.isParentFirst(string)) {
            URL uRL2 = uRL = this.parent == null ? super.getResource(string) : this.parent.getResource(string);
        }
        if (uRL != null) {
            this.log("Resource " + string + " loaded from parent loader", 4);
        } else {
            Enumeration enumeration = this.pathComponents.elements();
            while (enumeration.hasMoreElements() && uRL == null) {
                File file = (File)enumeration.nextElement();
                uRL = this.getResourceURL(file, string);
                if (uRL == null) continue;
                this.log("Resource " + string + " loaded from ant loader", 4);
            }
        }
        if (uRL == null && !this.isParentFirst(string)) {
            if (this.ignoreBase) {
                uRL = this.getRootLoader() == null ? null : this.getRootLoader().getResource(string);
            } else {
                URL uRL3 = uRL = this.parent == null ? super.getResource(string) : this.parent.getResource(string);
            }
            if (uRL != null) {
                this.log("Resource " + string + " loaded from parent loader", 4);
            }
        }
        if (uRL == null) {
            this.log("Couldn't load Resource " + string, 4);
        }
        return uRL;
    }

    protected Enumeration findResources(String string) throws IOException {
        ResourceEnumeration resourceEnumeration = new ResourceEnumeration(string);
        Enumeration enumeration = this.parent != null && this.parent != this.getParent() ? this.parent.getResources(string) : new CollectionUtils.EmptyEnumeration();
        if (this.isParentFirst(string)) {
            return CollectionUtils.append(enumeration, resourceEnumeration);
        }
        if (this.ignoreBase) {
            return this.getRootLoader() == null ? resourceEnumeration : CollectionUtils.append(resourceEnumeration, this.getRootLoader().getResources(string));
        }
        return CollectionUtils.append(resourceEnumeration, enumeration);
    }

    protected URL getResourceURL(File file, String string) {
        try {
            ZipFile zipFile = (ZipFile)this.zipFiles.get(file);
            if (zipFile == null && file.isDirectory()) {
                File file2 = new File(file, string);
                if (file2.exists()) {
                    try {
                        return FILE_UTILS.getFileURL(file2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
            } else {
                ZipEntry zipEntry;
                if (zipFile == null) {
                    if (file.exists()) {
                        zipFile = new ZipFile(file);
                        this.zipFiles.put(file, zipFile);
                    } else {
                        return null;
                    }
                }
                if ((zipEntry = zipFile.getEntry(string)) != null) {
                    try {
                        return new URL("jar:" + FILE_UTILS.getFileURL(file) + "!/" + zipEntry);
                    }
                    catch (MalformedURLException malformedURLException) {
                        return null;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (this.isParentFirst(string)) {
            try {
                clazz = this.findBaseClass(string);
                this.log("Class " + string + " loaded from parent loader " + "(parentFirst)", 4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = this.findClass(string);
                this.log("Class " + string + " loaded from ant loader " + "(parentFirst)", 4);
            }
        } else {
            try {
                clazz = this.findClass(string);
                this.log("Class " + string + " loaded from ant loader", 4);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (this.ignoreBase) {
                    throw classNotFoundException;
                }
                clazz = this.findBaseClass(string);
                this.log("Class " + string + " loaded from parent loader", 4);
            }
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private String getClassFilename(String string) {
        return string.replace('.', '/') + ".class";
    }

    protected Class defineClassFromData(File file, byte[] byArray, String string) throws IOException {
        this.definePackage(file, string);
        return this.defineClass(string, byArray, 0, byArray.length, Project.class.getProtectionDomain());
    }

    protected void definePackage(File file, String string) throws IOException {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n);
        if (this.getPackage(string2) != null) {
            return;
        }
        java.util.jar.Manifest manifest = this.getJarManifest(file);
        if (manifest == null) {
            this.definePackage(string2, null, null, null, null, null, null, null);
        } else {
            this.definePackage(file, string2, manifest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private java.util.jar.Manifest getJarManifest(File file) throws IOException {
        if (file.isDirectory()) {
            return null;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
            java.util.jar.Manifest manifest = jarFile.getManifest();
            return manifest;
        }
        finally {
            if (jarFile != null) {
                jarFile.close();
            }
        }
    }

    protected void definePackage(File file, String string, java.util.jar.Manifest manifest) {
        Attributes attributes;
        String string2 = string.replace('.', '/') + "/";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL = null;
        Attributes attributes2 = manifest.getAttributes(string2);
        if (attributes2 != null) {
            string3 = attributes2.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes2.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string5 = attributes2.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string6 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string8 = attributes2.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string9 = attributes2.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if (string9 != null && string9.toLowerCase(Locale.ENGLISH).equals("true")) {
            try {
                uRL = new URL(FileUtils.getFileUtils().toURI(file.getAbsolutePath()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        this.definePackage(string, string3, string5, string4, string6, string8, string7, uRL);
    }

    private Class getClassFromStream(InputStream inputStream, String string, File file) throws IOException, SecurityException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = -1;
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray, 0, 8192)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return this.defineClassFromData(file, byArray2, string);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        this.log("Finding class " + string, 4);
        return this.findClassInComponents(string);
    }

    protected boolean isInPath(File file) {
        Enumeration enumeration = this.pathComponents.elements();
        while (enumeration.hasMoreElements()) {
            File file2 = (File)enumeration.nextElement();
            if (!file2.equals(file)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class findClassInComponents(String string) throws ClassNotFoundException {
        Class clazz;
        InputStream inputStream;
        block7: {
            inputStream = null;
            String string2 = this.getClassFilename(string);
            try {
                Enumeration enumeration = this.pathComponents.elements();
                while (enumeration.hasMoreElements()) {
                    File file = (File)enumeration.nextElement();
                    try {
                        inputStream = this.getResourceStream(file, string2);
                        if (inputStream == null) continue;
                        this.log("Loaded from " + file + " " + string2, 4);
                        clazz = this.getClassFromStream(inputStream, string, file);
                        break block7;
                    }
                    catch (SecurityException securityException) {
                        throw securityException;
                    }
                    catch (IOException iOException) {
                        this.log("Exception reading component " + file + " (reason: " + iOException.getMessage() + ")", 3);
                    }
                }
                throw new ClassNotFoundException(string);
            }
            catch (Throwable throwable) {
                FileUtils.close(inputStream);
                throw throwable;
            }
        }
        FileUtils.close(inputStream);
        return clazz;
    }

    private Class findBaseClass(String string) throws ClassNotFoundException {
        if (this.parent == null) {
            return this.findSystemClass(string);
        }
        return this.parent.loadClass(string);
    }

    public synchronized void cleanup() {
        Enumeration enumeration = this.zipFiles.elements();
        while (enumeration.hasMoreElements()) {
            ZipFile zipFile = (ZipFile)enumeration.nextElement();
            try {
                zipFile.close();
            }
            catch (IOException iOException) {}
        }
        this.zipFiles = new Hashtable();
        if (this.project != null) {
            this.project.removeBuildListener(this);
        }
        this.project = null;
    }

    @Override
    public void buildStarted(BuildEvent buildEvent) {
    }

    @Override
    public void buildFinished(BuildEvent buildEvent) {
        this.cleanup();
    }

    @Override
    public void subBuildFinished(BuildEvent buildEvent) {
        if (buildEvent.getProject() == this.project) {
            this.cleanup();
        }
    }

    @Override
    public void subBuildStarted(BuildEvent buildEvent) {
    }

    @Override
    public void targetStarted(BuildEvent buildEvent) {
    }

    @Override
    public void targetFinished(BuildEvent buildEvent) {
    }

    @Override
    public void taskStarted(BuildEvent buildEvent) {
    }

    @Override
    public void taskFinished(BuildEvent buildEvent) {
    }

    @Override
    public void messageLogged(BuildEvent buildEvent) {
    }

    public void addJavaLibraries() {
        Vector vector = JavaEnvUtils.getJrePackages();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.addSystemPackageRoot(string);
        }
    }

    public String toString() {
        return "AntClassLoader[" + this.getClasspath() + "]";
    }

    private class ResourceEnumeration
    implements Enumeration {
        private String resourceName;
        private int pathElementsIndex;
        private URL nextResource;

        ResourceEnumeration(String string) {
            this.resourceName = string;
            this.pathElementsIndex = 0;
            this.findNextResource();
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextResource != null;
        }

        public Object nextElement() {
            URL uRL = this.nextResource;
            this.findNextResource();
            return uRL;
        }

        private void findNextResource() {
            URL uRL = null;
            while (this.pathElementsIndex < AntClassLoader.this.pathComponents.size() && uRL == null) {
                try {
                    File file = (File)AntClassLoader.this.pathComponents.elementAt(this.pathElementsIndex);
                    uRL = AntClassLoader.this.getResourceURL(file, this.resourceName);
                    ++this.pathElementsIndex;
                }
                catch (BuildException buildException) {}
            }
            this.nextResource = uRL;
        }
    }
}

