/*
 * Decompiled with CFR 0.152.
 */
package alma.tools.idlgen;

import alma.tools.idlgen.NamingConventions;
import alma.tools.idlgen.OutputStringManipulator;
import alma.tools.idlgen.StrippingPrintWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.generator.IdlToJava;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlTypeDef;
import org.openorb.compiler.object.IdlValueBox;

public class JavaGenerator
extends IdlToJava {
    private Set m_xmlTypedefNodes;
    private Map m_struct2JavaMap;
    private Set m_nodesToBeGenerated;

    public JavaGenerator(Set set, Set set2) {
        this.m_xmlTypedefNodes = set;
        this.m_nodesToBeGenerated = set2;
        this.m_struct2JavaMap = new HashMap();
    }

    public void translate_object_content(IdlObject idlObject, File file, int n) {
        IdlObject idlObject2 = idlObject.current();
        if (idlObject2.name() == null || this.m_nodesToBeGenerated.contains(idlObject2)) {
            if (IdlCompiler.verbose) {
                System.out.println("generate " + idlObject2.getId());
            }
            super.translate_object_content(idlObject, file, n);
        } else if (IdlCompiler.verbose) {
            System.out.println("reject   " + idlObject2.getId());
        }
    }

    public void translate_interface(IdlObject idlObject, File file) {
        if (((IdlInterface)idlObject).abstract_interface()) {
            System.err.println("xml layer generation is not supported for abstract interfaces!");
        }
        String string = idlObject.name();
        PrintWriter printWriter = this.newFile(file, string);
        String string2 = this.current_pkg;
        this.addToPkg(idlObject, idlObject.name() + "Package");
        File file2 = null;
        file2 = !this.isEmptyInterface(idlObject) ? this.createDirectory(idlObject.name() + "Package", file) : file;
        idlObject.reset();
        while (!idlObject.end()) {
            switch (idlObject.current().kind()) {
                case 2: {
                    this.translate_enum(idlObject.current(), file2);
                    break;
                }
                case 3: {
                    this.translate_struct(idlObject.current(), file2);
                    break;
                }
                case 4: {
                    this.translate_union(idlObject.current(), file2);
                    break;
                }
                case 13: {
                    this.translate_typedef(idlObject.current(), file2);
                    break;
                }
                case 14: {
                    this.translate_exception(idlObject.current(), file2);
                    break;
                }
                case 25: {
                    this.translate_native(idlObject.current(), file2);
                    break;
                }
                case 7: {
                    if (((IdlInterface)idlObject).abstract_interface()) break;
                    this.translate_constant(idlObject.current(), null, printWriter);
                }
            }
            idlObject.next();
        }
        this.current_pkg = string2;
        Vector vector = ((IdlInterface)idlObject).getInheritance();
        this.addDescriptiveHeader(printWriter, idlObject);
        printWriter.print("public interface " + string);
        if (vector.size() != 0) {
            printWriter.print(" extends ");
            for (int i = 0; i < vector.size(); ++i) {
                IdlObject idlObject2 = (IdlObject)vector.elementAt(i);
                String string3 = this.fullname(idlObject2);
                if (!this.m_nodesToBeGenerated.contains(idlObject2)) {
                    string3 = string3 + "Operations";
                }
                printWriter.print(string3);
                if (i == vector.size() - 1) continue;
                printWriter.print(", ");
            }
            printWriter.println("");
        } else {
            printWriter.println("");
        }
        printWriter.println("{");
        idlObject.reset();
        while (!idlObject.end()) {
            switch (idlObject.current().kind()) {
                case 16: {
                    this.translate_operation(idlObject.current(), printWriter);
                    break;
                }
                case 17: {
                    this.translate_attribute(idlObject.current(), printWriter);
                }
            }
            idlObject.next();
        }
        printWriter.println("}");
        printWriter.close();
    }

    public void write_helper(IdlObject idlObject, File file) {
        if (idlObject.kind() == 13 && this.m_xmlTypedefNodes.contains(idlObject)) {
            this.write_holder(idlObject, file);
        }
        if (IdlCompiler.verbose) {
            System.out.println("suppressing helper class generation for " + idlObject.getId());
        }
    }

    public void write_holder(IdlObject idlObject, File file) {
        PrintWriter printWriter = this.newFile(file, idlObject.name() + "Holder");
        if (this.current_pkg != null) {
            if (this.current_pkg.equals("generated")) {
                if (IdlCompiler.use_package) {
                    printWriter.println("package " + this.current_pkg + ";");
                    printWriter.println("");
                }
            } else if (!this.current_pkg.equals("")) {
                printWriter.println("package " + this.current_pkg + ";");
                printWriter.println("");
            }
        }
        printWriter.println("//");
        printWriter.println("// Holder class for : " + idlObject.name());
        printWriter.println("//");
        printWriter.println("// @author ACS xml transparency layer generator");
        printWriter.println("//");
        printWriter.println("final public class " + idlObject.name() + "Holder");
        printWriter.println("{");
        printWriter.println("\t//");
        printWriter.println("\t// Internal " + idlObject.name() + " value");
        printWriter.println("\t//");
        printWriter.print("\tpublic ");
        if (idlObject.kind() == 27) {
            if (((IdlValueBox)idlObject).simple()) {
                idlObject.reset();
                this.translate_type(idlObject.current(), printWriter);
            } else {
                this.translate_type(idlObject, printWriter);
            }
        } else {
            this.translate_type(idlObject, printWriter);
        }
        printWriter.println(" value;");
        printWriter.println("}");
        printWriter.close();
    }

    public static NamingConventions getNamingConventions() {
        return new NamingConventions(){

            @Override
            public String getSuffix() {
                return "J";
            }
        };
    }

    public PrintWriter fileAccess(File file) {
        StrippingPrintWriter strippingPrintWriter = null;
        try {
            FileWriter fileWriter = new FileWriter(file);
            strippingPrintWriter = new StrippingPrintWriter(fileWriter, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return strippingPrintWriter;
    }

    public void translate_type(IdlObject idlObject, PrintWriter printWriter) {
        if (idlObject.kind() == 13 && this.m_xmlTypedefNodes.contains(idlObject)) {
            String string = this.getXmlBindingClass(((IdlTypeDef)idlObject).name());
            printWriter.print(string);
        } else {
            super.translate_type(idlObject, printWriter);
        }
    }

    public void translate_parameter(IdlObject idlObject, PrintWriter printWriter, int n) {
        if (idlObject.kind() == 13 && this.m_xmlTypedefNodes.contains(idlObject)) {
            if (n == 0) {
                String string = this.getXmlBindingClass(((IdlTypeDef)idlObject).name());
                printWriter.print(string);
            } else {
                printWriter.print(this.fullname(idlObject) + "Holder");
            }
        } else {
            super.translate_parameter(idlObject, printWriter, n);
        }
    }

    void setIdlStruct2JavaBindingClassMappings(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(61);
            if (n <= 0) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            this.m_struct2JavaMap.put(string3, string4);
        }
    }

    String getXmlBindingClass(String string) {
        String string2 = (String)this.m_struct2JavaMap.get(string);
        if (string2 == null) {
            String string3 = "unknown struct type " + string + " could not be mapped to a binding class.";
            System.err.println(string3);
            throw new RuntimeException(string3);
        }
        return string2;
    }

    public void addDescriptiveHeader(PrintWriter printWriter, IdlObject idlObject) {
        if (idlObject.kind() == 15) {
            IdlComment idlComment = new IdlComment();
            idlComment.add_description("XML binding class aware ACS component interface " + idlObject.name());
            idlObject.attach_comment(idlComment);
        }
        super.addDescriptiveHeader(printWriter, idlObject);
    }

    public void translate_exception(IdlObject idlObject, File file) {
    }

    public File createDirectory(String string, File file) {
        string = OutputStringManipulator.modify(string);
        return super.createDirectory(string, file);
    }
}

