/*
 * Decompiled with CFR 0.152.
 */
package alma.archive;

import alma.ACS.CBvoid;
import alma.ACS.CBvoidHelper;
import alma.ACS.CharacteristicComponentDesc;
import alma.ACS.CharacteristicComponentDescHelper;
import alma.ACS.ComponentStates;
import alma.ACS.ComponentStatesHelper;
import alma.ACS.NoSuchCharacteristic;
import alma.ACS.NoSuchCharacteristicHelper;
import alma.ACS.stringSeqHelper;
import alma.ACSBulkDataError.AVCloseReceiverErrorEx;
import alma.ACSBulkDataError.AVCloseReceiverErrorExHelper;
import alma.ACSBulkDataError.AVFlowEndpointErrorEx;
import alma.ACSBulkDataError.AVFlowEndpointErrorExHelper;
import alma.ACSBulkDataError.AVInvalidFlowNumberEx;
import alma.ACSBulkDataError.AVInvalidFlowNumberExHelper;
import alma.ACSBulkDataError.AVNotificationMechanismErrorEx;
import alma.ACSBulkDataError.AVNotificationMechanismErrorExHelper;
import alma.ACSBulkDataError.AVOpenReceiverErrorEx;
import alma.ACSBulkDataError.AVOpenReceiverErrorExHelper;
import alma.ACSBulkDataError.AVReceiverConfigErrorEx;
import alma.ACSBulkDataError.AVReceiverConfigErrorExHelper;
import alma.ACSBulkDataError.AVSetReceiverNameErrorEx;
import alma.ACSBulkDataError.AVSetReceiverNameErrorExHelper;
import alma.ACSErr.Completion;
import alma.ACSErr.CompletionHelper;
import alma.archive.ArchiveBulkReceiver;
import alma.archive.ArchiveBulkReceiverHelper;
import alma.archive.ArchiveBulkReceiverOperations;
import alma.bulkdata.BulkDataReceiverConfig;
import alma.bulkdata.BulkDataReceiverConfigHelper;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CosPropertyService.PropertySet;
import org.omg.CosPropertyService.PropertySetHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class ArchiveBulkReceiverPOA
extends Servant
implements InvokeHandler,
ArchiveBulkReceiverOperations {
    private static final Hashtable m_opsHash = new Hashtable();
    private String[] ids = new String[]{"IDL:alma/archive/ArchiveBulkReceiver:1.0", "IDL:alma/ACS/CharacteristicModel:1.0", "IDL:alma/ACS/CharacteristicComponent:1.0", "IDL:alma/ACS/PingableResource:1.0", "IDL:alma/ACS/ACSComponent:1.0", "IDL:alma/bulkdata/BulkDataReceiver:1.0"};

    public ArchiveBulkReceiver _this() {
        return ArchiveBulkReceiverHelper.narrow(this._this_object());
    }

    public ArchiveBulkReceiver _this(ORB oRB) {
        return ArchiveBulkReceiverHelper.narrow(this._this_object(oRB));
    }

    public OutputStream _invoke(String string, InputStream inputStream, ResponseHandler responseHandler) throws SystemException {
        OutputStream outputStream = null;
        Integer n = (Integer)m_opsHash.get(string);
        if (null == n) {
            throw new BAD_OPERATION(string + " not found");
        }
        switch (n) {
            case 0: {
                outputStream = responseHandler.createReply();
                outputStream.write_ulonglong(this.getTotalFileLength());
                break;
            }
            case 1: {
                outputStream = responseHandler.createReply();
                outputStream.write_ulong(this.getAvgThroughput());
                break;
            }
            case 2: {
                try {
                    outputStream = responseHandler.createReply();
                    this.openReceiver();
                }
                catch (AVOpenReceiverErrorEx aVOpenReceiverErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVOpenReceiverErrorExHelper.write((OutputStream)outputStream, (AVOpenReceiverErrorEx)aVOpenReceiverErrorEx);
                }
                break;
            }
            case 3: {
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.startNGASArchiveClient());
                break;
            }
            case 4: {
                outputStream = responseHandler.createReply();
                outputStream.write_string(this.name());
                break;
            }
            case 5: {
                outputStream = responseHandler.createReply();
                outputStream.write_ulonglong(this.getTotalSaveTime());
                break;
            }
            case 6: {
                outputStream = responseHandler.createReply();
                outputStream.write_string(this.getBRHostName());
                break;
            }
            case 7: {
                outputStream = responseHandler.createReply();
                ComponentStatesHelper.write((OutputStream)outputStream, (ComponentStates)this.componentState());
                break;
            }
            case 8: {
                try {
                    outputStream = responseHandler.createReply();
                    BulkDataReceiverConfigHelper.write((OutputStream)outputStream, (BulkDataReceiverConfig)this.getReceiverConfig());
                }
                catch (AVReceiverConfigErrorEx aVReceiverConfigErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVReceiverConfigErrorExHelper.write((OutputStream)outputStream, (AVReceiverConfigErrorEx)aVReceiverConfigErrorEx);
                }
                break;
            }
            case 9: {
                try {
                    CBvoid cBvoid = CBvoidHelper.read((InputStream)inputStream);
                    outputStream = responseHandler.createReply();
                    this.subscribeNotification(cBvoid);
                }
                catch (AVNotificationMechanismErrorEx aVNotificationMechanismErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVNotificationMechanismErrorExHelper.write((OutputStream)outputStream, (AVNotificationMechanismErrorEx)aVNotificationMechanismErrorEx);
                }
                break;
            }
            case 10: {
                outputStream = responseHandler.createReply();
                PropertySetHelper.write((OutputStream)outputStream, (PropertySet)this.get_all_characteristics());
                break;
            }
            case 11: {
                outputStream = responseHandler.createReply();
                this.resetAllThread();
                break;
            }
            case 12: {
                try {
                    outputStream = responseHandler.createReply();
                    this.closeReceiver();
                }
                catch (AVCloseReceiverErrorEx aVCloseReceiverErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVCloseReceiverErrorExHelper.write((OutputStream)outputStream, (AVCloseReceiverErrorEx)aVCloseReceiverErrorEx);
                }
                break;
            }
            case 13: {
                outputStream = responseHandler.createReply();
                outputStream.write_ulong(this.getMaxBufferUsage());
                break;
            }
            case 14: {
                outputStream = responseHandler.createReply();
                this.getThreadInfo();
                break;
            }
            case 15: {
                outputStream = responseHandler.createReply();
                this.passSupplier2cbs();
                break;
            }
            case 16: {
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.isFinish());
                break;
            }
            case 17: {
                outputStream = responseHandler.createReply();
                CharacteristicComponentDescHelper.write((OutputStream)outputStream, (CharacteristicComponentDesc)this.descriptor());
                break;
            }
            case 18: {
                outputStream = responseHandler.createReply();
                outputStream.write_boolean(this.ping());
                break;
            }
            case 19: {
                outputStream = responseHandler.createReply();
                this.shutdownNGASArchiveClient();
                break;
            }
            case 20: {
                String string2 = inputStream.read_string();
                outputStream = responseHandler.createReply();
                stringSeqHelper.write((OutputStream)outputStream, (String[])this.find_characteristic(string2));
                break;
            }
            case 21: {
                try {
                    String string3 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    this.setRecvName(string3);
                }
                catch (AVSetReceiverNameErrorEx aVSetReceiverNameErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVSetReceiverNameErrorExHelper.write((OutputStream)outputStream, (AVSetReceiverNameErrorEx)aVSetReceiverNameErrorEx);
                }
                break;
            }
            case 22: {
                try {
                    String string4 = inputStream.read_string();
                    outputStream = responseHandler.createReply();
                    outputStream.write_any(this.get_characteristic_by_name(string4));
                }
                catch (NoSuchCharacteristic noSuchCharacteristic) {
                    outputStream = responseHandler.createExceptionReply();
                    NoSuchCharacteristicHelper.write((OutputStream)outputStream, (NoSuchCharacteristic)noSuchCharacteristic);
                }
                break;
            }
            case 23: {
                try {
                    int n2 = inputStream.read_ulong();
                    outputStream = responseHandler.createReply();
                    CompletionHelper.write((OutputStream)outputStream, (Completion)this.getCbStatus(n2));
                }
                catch (AVInvalidFlowNumberEx aVInvalidFlowNumberEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVInvalidFlowNumberExHelper.write((OutputStream)outputStream, (AVInvalidFlowNumberEx)aVInvalidFlowNumberEx);
                }
                catch (AVFlowEndpointErrorEx aVFlowEndpointErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVFlowEndpointErrorExHelper.write((OutputStream)outputStream, (AVFlowEndpointErrorEx)aVFlowEndpointErrorEx);
                }
                break;
            }
            case 24: {
                outputStream = responseHandler.createReply();
                this.resetStatistics();
                break;
            }
            case 25: {
                try {
                    int n3 = inputStream.read_ulong();
                    int n4 = inputStream.read_ulong();
                    outputStream = responseHandler.createReply();
                    this.setTimeout(n3, n4);
                    break;
                }
                catch (AVInvalidFlowNumberEx aVInvalidFlowNumberEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVInvalidFlowNumberExHelper.write((OutputStream)outputStream, (AVInvalidFlowNumberEx)aVInvalidFlowNumberEx);
                    break;
                }
                catch (AVFlowEndpointErrorEx aVFlowEndpointErrorEx) {
                    outputStream = responseHandler.createExceptionReply();
                    AVFlowEndpointErrorExHelper.write((OutputStream)outputStream, (AVFlowEndpointErrorEx)aVFlowEndpointErrorEx);
                }
            }
        }
        return outputStream;
    }

    public String[] _all_interfaces(POA pOA, byte[] byArray) {
        return this.ids;
    }

    static {
        m_opsHash.put("getTotalFileLength", new Integer(0));
        m_opsHash.put("getAvgThroughput", new Integer(1));
        m_opsHash.put("openReceiver", new Integer(2));
        m_opsHash.put("startNGASArchiveClient", new Integer(3));
        m_opsHash.put("_get_name", new Integer(4));
        m_opsHash.put("getTotalSaveTime", new Integer(5));
        m_opsHash.put("getBRHostName", new Integer(6));
        m_opsHash.put("_get_componentState", new Integer(7));
        m_opsHash.put("getReceiverConfig", new Integer(8));
        m_opsHash.put("subscribeNotification", new Integer(9));
        m_opsHash.put("get_all_characteristics", new Integer(10));
        m_opsHash.put("resetAllThread", new Integer(11));
        m_opsHash.put("closeReceiver", new Integer(12));
        m_opsHash.put("getMaxBufferUsage", new Integer(13));
        m_opsHash.put("getThreadInfo", new Integer(14));
        m_opsHash.put("passSupplier2cbs", new Integer(15));
        m_opsHash.put("isFinish", new Integer(16));
        m_opsHash.put("descriptor", new Integer(17));
        m_opsHash.put("ping", new Integer(18));
        m_opsHash.put("shutdownNGASArchiveClient", new Integer(19));
        m_opsHash.put("find_characteristic", new Integer(20));
        m_opsHash.put("setRecvName", new Integer(21));
        m_opsHash.put("get_characteristic_by_name", new Integer(22));
        m_opsHash.put("getCbStatus", new Integer(23));
        m_opsHash.put("resetStatistics", new Integer(24));
        m_opsHash.put("setTimeout", new Integer(25));
    }
}

