/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.lang.reflect.Method;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.StringManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AprLifecycleListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog((Class)AprLifecycleListener.class);
    protected StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected static String SSLRandomSeed = "builtin";
    protected static final int REQUIRED_MAJOR = 1;
    protected static final int REQUIRED_MINOR = 1;
    protected static final int REQUIRED_PATCH = 3;
    protected static final int RECOMMENDED_PV = 4;

    public void lifecycleEvent(LifecycleEvent event) {
        if ("init".equals(event.getType())) {
            int major = 0;
            int minor = 0;
            int patch = 0;
            try {
                String methodName = "initialize";
                Class[] paramTypes = new Class[]{String.class};
                Object[] paramValues = new Object[]{null};
                Class<?> clazz = Class.forName("org.apache.tomcat.jni.Library");
                Method method = clazz.getMethod(methodName, paramTypes);
                method.invoke(null, paramValues);
                methodName = "randSet";
                paramValues[0] = SSLRandomSeed;
                clazz = Class.forName("org.apache.tomcat.jni.SSL");
                method = clazz.getMethod(methodName, paramTypes);
                method.invoke(null, paramValues);
                major = clazz.getField("TCN_MAJOR_VERSION").getInt(null);
                minor = clazz.getField("TCN_MINOR_VERSION").getInt(null);
                patch = clazz.getField("TCN_PATCH_VERSION").getInt(null);
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) {
                    log.info((Object)this.sm.getString("aprListener.aprInit", System.getProperty("java.library.path")));
                } else {
                    log.debug((Object)this.sm.getString("aprListener.aprInit", System.getProperty("java.library.path")), t);
                }
                return;
            }
            if (major != 1 || minor != 1 || patch < 3) {
                log.error((Object)this.sm.getString("aprListener.tcnInvalid", major + "." + minor + "." + patch, "1.1.3"));
            }
            if (patch < 4) {
                if (!log.isDebugEnabled()) {
                    log.info((Object)this.sm.getString("aprListener.tcnVersion", major + "." + minor + "." + patch, "1.1.4"));
                } else {
                    log.debug((Object)this.sm.getString("aprListener.tcnVersion", major + "." + minor + "." + patch, "1.1.4"));
                }
            }
        } else if ("after_stop".equals(event.getType())) {
            try {
                String methodName = "terminate";
                Method method = Class.forName("org.apache.tomcat.jni.Library").getMethod(methodName, null);
                method.invoke(null, (Object[])null);
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) {
                    log.info((Object)this.sm.getString("aprListener.aprDestroy"));
                }
                log.debug((Object)this.sm.getString("aprListener.aprDestroy"), t);
            }
        }
    }

    public String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public void setSSLRandomSeed(String SSLRandomSeed) {
        AprLifecycleListener.SSLRandomSeed = SSLRandomSeed;
    }
}

