/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate.test;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.exist.xupdate.test.CompareDocuments;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.InputSource;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XUpdateQueryService;

public class XUpdateTest {
    private static final String URI = "xmldb:exist:///db";
    private static final String DRIVER = "org.exist.xmldb.DatabaseImpl";
    private static final String XUPDATE_COLLECTION = "xupdate_tests";
    private static final String MODIFICATION_DIR = "src/org/exist/xupdate/test/modifications";
    private static final String RESTULT_DIR = "src/org/exist/xupdate/test/results";
    private static final String SOURCE_DIR = "src/org/exist/xupdate/test/input";
    private static final String XUPDATE_FILE = "xu.xml";
    private Collection col = null;

    public XUpdateTest() {
        this.setUp();
    }

    public void setUp() {
        try {
            Class<?> cl = Class.forName(DRIVER);
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
            this.col = DatabaseManager.getCollection((String)"xmldb:exist:///db/xupdate_tests");
            if (this.col == null) {
                Collection root = DatabaseManager.getCollection((String)URI);
                CollectionManagementService mgtService = (CollectionManagementService)root.getService("CollectionManagementService", "1.0");
                this.col = mgtService.createCollection(XUPDATE_COLLECTION);
                System.out.println("collection created.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doTest(String testName, String sourceFile) throws Exception {
        this.addDocument(sourceFile);
        Document xupdateResult = this.updateDocument("src/org/exist/xupdate/test/modifications/" + testName + ".xml");
        this.removeWhiteSpace(xupdateResult);
        DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        DocumentBuilder builder = parserFactory.newDocumentBuilder();
        Document referenceXML = builder.parse("src/org/exist/xupdate/test/results/" + testName + ".xml");
        this.removeWhiteSpace(referenceXML);
        System.out.println("\n");
        new CompareDocuments().compare(referenceXML, xupdateResult);
        this.removeDocument();
    }

    public void addDocument(String sourceFile) throws Exception {
        XMLResource document = (XMLResource)this.col.createResource(XUPDATE_FILE, "XMLResource");
        File f = new File("src/org/exist/xupdate/test/input/" + sourceFile);
        if (!f.canRead()) {
            System.err.println("can't read file " + sourceFile);
        }
        document.setContent((Object)f);
        this.col.storeResource((Resource)document);
        System.out.println("document stored.");
    }

    public void removeDocument() throws Exception {
        Resource document = this.col.getResource(XUPDATE_FILE);
        this.col.removeResource(document);
        System.out.println("document removed.");
    }

    private Document updateDocument(String updateFile) throws Exception {
        XUpdateQueryService service = (XUpdateQueryService)this.col.getService("XUpdateQueryService", "1.0");
        System.out.println("update file: " + updateFile);
        File file = new File(updateFile);
        BufferedReader br = new BufferedReader(new FileReader(file));
        char[] characters = new char[new Long(file.length()).intValue()];
        br.read(characters, 0, new Long(file.length()).intValue());
        br.close();
        String xUpdateModifications = new String(characters);
        System.out.println("modifications: " + xUpdateModifications);
        service.update(xUpdateModifications);
        XMLResource ret = (XMLResource)this.col.getResource(XUPDATE_FILE);
        String xmlString = (String)ret.getContent();
        System.out.println("Result:");
        System.out.println(xmlString);
        DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        InputSource in = new InputSource(new ByteArrayInputStream(xmlString.getBytes()));
        DocumentBuilder builder = parserFactory.newDocumentBuilder();
        return builder.parse(in);
    }

    private void removeWhiteSpace(Document document) throws Exception {
        DocumentTraversal dt = (DocumentTraversal)((Object)document);
        NodeIterator nodeIterator = dt.createNodeIterator(document, 4, null, true);
        Node node = nodeIterator.nextNode();
        while (node != null) {
            if (node.getNodeValue().trim().compareTo("") == 0) {
                node.getParentNode().removeChild(node);
            }
            node = nodeIterator.nextNode();
        }
    }
}

