/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.w3c.dom.Node;

public class Remove
extends Modification {
    public Remove(DBBroker broker, DocumentSet docs, String selectStmt, Map namespaces, Map variables) {
        super(broker, docs, selectStmt, namespaces, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long process() throws PermissionDeniedException, LockException, EXistException, XPathException {
        try {
            NodeImpl[] ql = this.selectAndLock();
            Modification.IndexListener listener = new Modification.IndexListener(ql);
            DocumentImpl doc = null;
            Collection collection = null;
            Collection prevCollection = null;
            DocumentSet modifiedDocs = new DocumentSet();
            for (int i = 0; i < ql.length; ++i) {
                NodeImpl node = ql[i];
                doc = (DocumentImpl)node.getOwnerDocument();
                if (!doc.getPermissions().validate(this.broker.getUser(), 1)) {
                    throw new PermissionDeniedException("permission to remove document denied");
                }
                collection = doc.getCollection();
                if (prevCollection != null && collection != prevCollection) {
                    this.broker.saveCollection(prevCollection);
                }
                doc.setIndexListener(listener);
                modifiedDocs.add(doc);
                Node parent = node.getParentNode();
                if (parent.getNodeType() != 1) {
                    LOG.debug((Object)("parent = " + parent.getNodeType() + "; " + parent.getNodeName()));
                    throw new EXistException("you cannot remove the document element. Use update instead");
                }
                parent.removeChild(node);
                doc.clearIndexListener();
                doc.setLastModified(System.currentTimeMillis());
                prevCollection = collection;
            }
            if (doc != null) {
                this.broker.saveCollection(collection);
            }
            this.checkFragmentation(modifiedDocs);
            long l = ql.length;
            return l;
        }
        finally {
            this.unlockDocuments();
        }
    }

    public String getName() {
        return "remove";
    }
}

