/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeImpl;
import org.exist.dom.NodeIndexListener;
import org.exist.dom.NodeSet;
import org.exist.security.PermissionDeniedException;
import org.exist.source.StringSource;
import org.exist.storage.DBBroker;
import org.exist.storage.XQueryPool;
import org.exist.storage.store.StorageAddress;
import org.exist.util.Lock;
import org.exist.util.LockException;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;
import org.w3c.dom.NodeList;

public abstract class Modification {
    protected static final Logger LOG = Logger.getLogger((Class)Modification.class);
    protected String selectStmt = null;
    protected NodeList content = null;
    protected DBBroker broker;
    protected DocumentSet docs;
    protected Map namespaces;
    protected Map variables;
    protected DocumentSet lockedDocuments = null;

    public Modification(DBBroker broker, DocumentSet docs, String selectStmt, Map namespaces, Map variables) {
        this.selectStmt = selectStmt;
        this.broker = broker;
        this.docs = docs;
        this.namespaces = new HashMap(namespaces);
        this.variables = new TreeMap(variables);
    }

    public abstract long process() throws PermissionDeniedException, LockException, EXistException, XPathException;

    public abstract String getName();

    public void setContent(NodeList nodes) {
        this.content = nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeList select(DocumentSet docs) throws PermissionDeniedException, EXistException, XPathException {
        StringSource source;
        XQuery xquery = this.broker.getXQueryService();
        XQueryPool pool = xquery.getXQueryPool();
        CompiledXQuery compiled = pool.borrowCompiledXQuery(source = new StringSource(this.selectStmt));
        XQueryContext context = compiled == null ? xquery.newContext() : compiled.getContext();
        context.setExclusiveMode(true);
        context.setStaticallyKnownDocuments(docs);
        this.declareNamespaces(context);
        this.declareVariables(context);
        if (compiled == null) {
            try {
                compiled = xquery.compile(context, source);
            }
            catch (IOException e) {
                throw new EXistException("An exception occurred while compiling the query: " + e.getMessage());
            }
        }
        Sequence resultSeq = null;
        try {
            resultSeq = xquery.execute(compiled, null);
        }
        finally {
            pool.returnCompiledXQuery(source, compiled);
        }
        if (resultSeq.getLength() != 0 && !Type.subTypeOf(resultSeq.getItemType(), -1)) {
            throw new EXistException("select expression should evaluate to a node-set; got " + Type.getTypeName(resultSeq.getItemType()));
        }
        LOG.debug((Object)("found " + resultSeq.getLength() + " for select: " + this.selectStmt));
        return resultSeq.toNodeSet();
    }

    protected void declareVariables(XQueryContext context) throws XPathException {
        Iterator i = this.variables.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            context.declareVariable(entry.getKey().toString(), entry.getValue());
        }
    }

    protected void declareNamespaces(XQueryContext context) {
        Iterator i = this.namespaces.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            context.declareNamespace((String)entry.getKey(), (String)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeImpl[] selectAndLock() throws LockException, PermissionDeniedException, EXistException, XPathException {
        Lock globalLock = this.broker.getBrokerPool().getGlobalUpdateLock();
        try {
            globalLock.acquire(0);
            NodeList nl = this.select(this.docs);
            this.lockedDocuments = ((NodeSet)nl).getDocumentSet();
            this.lockedDocuments.lock(true);
            NodeImpl[] ql = new NodeImpl[nl.getLength()];
            for (int i = 0; i < ql.length; ++i) {
                ql[i] = (NodeImpl)nl.item(i);
                DocumentImpl doc = (DocumentImpl)ql[i].getOwnerDocument();
                doc.setBroker(this.broker);
            }
            NodeImpl[] nodeImplArray = ql;
            return nodeImplArray;
        }
        finally {
            globalLock.release();
        }
    }

    protected void unlockDocuments() {
        if (this.lockedDocuments == null) {
            return;
        }
        this.lockedDocuments.unlock(true);
    }

    protected void checkFragmentation(DocumentSet docs) throws EXistException {
        Iterator i = docs.iterator();
        while (i.hasNext()) {
            DocumentImpl next = (DocumentImpl)i.next();
            if (next.getSplitCount() > this.broker.getFragmentationLimit()) {
                this.broker.defrag(next);
            }
            this.broker.consistencyCheck(next);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<xu:");
        buf.append(this.getName());
        buf.append(" select=\"");
        buf.append(this.selectStmt);
        buf.append("\">");
        buf.append("</xu:");
        buf.append(this.getName());
        buf.append(">");
        return buf.toString();
    }

    static final class NodeComparator
    implements Comparator {
        NodeComparator() {
        }

        public int compare(Object o1, Object o2) {
            NodeImpl n1 = (NodeImpl)o1;
            NodeImpl n2 = (NodeImpl)o2;
            if (n1.getInternalAddress() == n2.getInternalAddress()) {
                return 0;
            }
            if (n1.getInternalAddress() < n2.getInternalAddress()) {
                return -1;
            }
            return 1;
        }
    }

    static final class IndexListener
    implements NodeIndexListener {
        NodeImpl[] nodes;

        public IndexListener(NodeImpl[] nodes) {
            this.nodes = nodes;
        }

        public void nodeChanged(NodeImpl node) {
            long address = node.getInternalAddress();
            for (int i = 0; i < this.nodes.length; ++i) {
                if (!StorageAddress.equals(this.nodes[i].getInternalAddress(), address)) continue;
                this.nodes[i] = node;
            }
        }

        public void nodeChanged(long oldAddress, long newAddress) {
            for (int i = 0; i < this.nodes.length; ++i) {
                if (!StorageAddress.equals(this.nodes[i].getInternalAddress(), oldAddress)) continue;
                this.nodes[i].setInternalAddress(newAddress);
            }
        }
    }
}

