/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Insert
extends Modification {
    public static final int INSERT_BEFORE = 0;
    public static final int INSERT_AFTER = 1;
    private int mode = 0;

    public Insert(DBBroker broker, DocumentSet docs, String selectStmt, Map namespaces, Map variables) {
        super(broker, docs, selectStmt, namespaces, variables);
    }

    public Insert(DBBroker broker, DocumentSet docs, String selectStmt, int mode, Map namespaces, Map variables) {
        this(broker, docs, selectStmt, namespaces, variables);
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long process() throws PermissionDeniedException, LockException, EXistException, XPathException {
        NodeList children = this.content;
        if (children.getLength() == 0) {
            return 0L;
        }
        try {
            NodeImpl[] ql = this.selectAndLock();
            Modification.IndexListener listener = new Modification.IndexListener(ql);
            NodeImpl doc = null;
            Collection collection = null;
            Collection prevCollection = null;
            DocumentSet modifiedDocs = new DocumentSet();
            int len = children.getLength();
            LOG.debug((Object)("found " + len + " nodes to insert"));
            for (int i = 0; i < ql.length; ++i) {
                NodeImpl node = ql[i];
                doc = (DocumentImpl)node.getOwnerDocument();
                ((DocumentImpl)doc).setIndexListener(listener);
                collection = ((DocumentImpl)doc).getCollection();
                if (prevCollection != null && collection != prevCollection) {
                    doc.getBroker().saveCollection(prevCollection);
                }
                if (!((DocumentImpl)doc).getPermissions().validate(this.broker.getUser(), 1)) {
                    throw new PermissionDeniedException("permission to remove document denied");
                }
                modifiedDocs.add((DocumentImpl)doc);
                NodeImpl parent = (NodeImpl)node.getParentNode();
                switch (this.mode) {
                    case 0: {
                        parent.insertBefore(children, (Node)node);
                        break;
                    }
                    case 1: {
                        parent.insertAfter(children, (Node)node);
                    }
                }
                ((DocumentImpl)doc).clearIndexListener();
                ((DocumentImpl)doc).setLastModified(System.currentTimeMillis());
                prevCollection = collection;
            }
            if (doc != null) {
                doc.getBroker().saveCollection(collection);
            }
            this.checkFragmentation(modifiedDocs);
            long l = ql.length;
            return l;
        }
        finally {
            this.unlockDocuments();
        }
    }

    public String getName() {
        return this.mode == 0 ? "insert-before" : "insert-after";
    }
}

