/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.memtree.NodeImpl;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;

public class ValueSequence
extends AbstractSequence {
    private final Logger LOG = Logger.getLogger((Class)ValueSequence.class);
    private static final int INITIAL_SIZE = 64;
    private Item[] values;
    private int size = -1;
    private int itemType = 12;
    private boolean noDuplicates = false;

    public ValueSequence() {
        this.values = new Item[64];
    }

    public ValueSequence(Sequence otherSequence) {
        this.values = new Item[otherSequence.getLength()];
        this.addAll(otherSequence);
    }

    public void add(Item item) {
        ++this.size;
        this.ensureCapacity();
        this.values[this.size] = item;
        if (this.itemType == item.getType()) {
            return;
        }
        this.itemType = this.itemType == 12 ? item.getType() : Type.getCommonSuperType(item.getType(), this.itemType);
        this.noDuplicates = false;
    }

    public void addAll(Sequence otherSequence) {
        SequenceIterator iterator = otherSequence.iterate();
        while (iterator.hasNext()) {
            this.add(iterator.nextItem());
        }
    }

    public int getItemType() {
        return this.itemType == 12 ? 11 : this.itemType;
    }

    public SequenceIterator iterate() {
        return new ValueSequenceIterator();
    }

    public SequenceIterator unorderedIterator() {
        return new ValueSequenceIterator();
    }

    public int getLength() {
        return this.size + 1;
    }

    public Item itemAt(int pos) {
        return this.values[pos];
    }

    public NodeSet toNodeSet() throws XPathException {
        if (this.size == -1) {
            return NodeSet.EMPTY_SET;
        }
        if (this.itemType != 12 && Type.subTypeOf(this.itemType, -1)) {
            ExtArrayNodeSet set = new ExtArrayNodeSet();
            for (int i = 0; i <= this.size; ++i) {
                NodeValue v = (NodeValue)this.values[i];
                if (v.getImplementationType() != 1) {
                    NodeSet p = ((NodeImpl)v).toNodeSet();
                    set.addAll(p);
                    continue;
                }
                set.add((NodeProxy)v);
            }
            return set;
        }
        throw new XPathException("Type error: the sequence cannot be converted into a node set. Item type is " + Type.getTypeName(this.itemType));
    }

    private void ensureCapacity() {
        if (this.size == this.values.length) {
            int newSize = this.size * 3 / 2;
            Item[] newValues = new Item[newSize];
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.values = newValues;
        }
    }

    public void removeDuplicates() {
        if (this.noDuplicates) {
            return;
        }
        if (this.itemType != 12 && Type.subTypeOf(this.itemType, 20)) {
            return;
        }
        boolean hasNodes = false;
        for (int i = 0; i <= this.size; ++i) {
            if (!Type.subTypeOf(this.values[i].getType(), -1)) continue;
            hasNodes = true;
        }
        if (!hasNodes) {
            return;
        }
        TreeSet<Item> nodes = new TreeSet<Item>();
        int j = 0;
        for (int i = 0; i <= this.size; ++i) {
            if (Type.subTypeOf(this.values[i].getType(), -1)) {
                if (nodes.contains(this.values[i])) continue;
                Item item = this.values[i];
                this.values[j++] = item;
                nodes.add(item);
                continue;
            }
            this.values[j++] = this.values[i];
        }
        this.size = j - 1;
        this.noDuplicates = true;
    }

    private class ValueSequenceIterator
    implements SequenceIterator {
        private int pos = 0;

        public boolean hasNext() {
            return this.pos <= ValueSequence.this.size;
        }

        public Item nextItem() {
            if (this.pos <= ValueSequence.this.size) {
                return ValueSequence.this.values[this.pos++];
            }
            return null;
        }
    }
}

