/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.util.Collations;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.YearMonthDurationValue;

public class UntypedAtomicValue
extends AtomicValue {
    private String value;

    public UntypedAtomicValue(String value) {
        this.value = value;
    }

    public int getType() {
        return 20;
    }

    public String getStringValue() throws XPathException {
        return this.value;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: {
                return this;
            }
            case 22: {
                return new StringValue(this.value);
            }
            case 23: {
                if (this.value.equals("0") || this.value.equals("false")) {
                    return BooleanValue.FALSE;
                }
                if (this.value.equals("1") || this.value.equals("true")) {
                    return BooleanValue.TRUE;
                }
                throw new XPathException("cannot convert string '" + this.value + "' to boolean");
            }
            case 30: 
            case 33: 
            case 34: {
                return new DoubleValue(this.value);
            }
            case 32: {
                return new DecimalValue(this.value);
            }
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return new IntegerValue(this.value, requiredType);
            }
            case 50: {
                return new DateTimeValue(this.value);
            }
            case 52: {
                return new TimeValue(this.value);
            }
            case 51: {
                return new DateValue(this.value);
            }
            case 53: {
                return new DurationValue(this.value);
            }
            case 54: {
                return new YearMonthDurationValue(this.value);
            }
            case 55: {
                return new DayTimeDurationValue(this.value);
            }
        }
        throw new XPathException("cannot convert string '" + this.value + "' to " + Type.getTypeName(requiredType));
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 22) || Type.subTypeOf(other.getType(), 21)) {
            int cmp = Collations.compare(collator, this.value, other.getStringValue());
            switch (operator) {
                case 4: {
                    return cmp == 0;
                }
                case 5: {
                    return cmp != 0;
                }
                case 0: {
                    return cmp < 0;
                }
                case 3: {
                    return cmp <= 0;
                }
                case 1: {
                    return cmp > 0;
                }
                case 2: {
                    return cmp >= 0;
                }
            }
            throw new XPathException("Type error: cannot apply operand to string value");
        }
        throw new XPathException("Type error: operands are not comparable; expected xdt:untypedAtomic; got " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        return Collations.compare(collator, this.value, other.getStringValue());
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 21)) {
            return Collations.compare(collator, this.value, ((UntypedAtomicValue)other).value) > 0 ? this : other;
        }
        return Collations.compare(collator, this.value, other.getStringValue()) > 0 ? this : other;
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 21)) {
            return Collations.compare(collator, this.value, ((UntypedAtomicValue)other).value) < 0 ? this : other;
        }
        return Collations.compare(collator, this.value, other.getStringValue()) < 0 ? this : other;
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(StringValue.class)) {
            return 0;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 1;
        }
        if (javaClass == Character.class || javaClass == Character.TYPE) {
            return 2;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 10;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 11;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 12;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 13;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 14;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 15;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 16;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(UntypedAtomicValue.class)) {
            return this;
        }
        if (target == Object.class || target == String.class || target == CharSequence.class) {
            return this.value;
        }
        if (target == Double.TYPE || target == Double.class) {
            DoubleValue v = (DoubleValue)this.convertTo(34);
            return new Double(v.getValue());
        }
        if (target == Float.TYPE || target == Float.class) {
            FloatValue v = (FloatValue)this.convertTo(33);
            return new Float(v.value);
        }
        if (target == Long.TYPE || target == Long.class) {
            IntegerValue v = (IntegerValue)this.convertTo(37);
            return new Long(v.getInt());
        }
        if (target == Integer.TYPE || target == Integer.class) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return new Integer(v.getInt());
        }
        if (target == Short.TYPE || target == Short.class) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return new Short((short)v.getInt());
        }
        if (target == Byte.TYPE || target == Byte.class) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return new Byte((byte)v.getInt());
        }
        if (target == Boolean.TYPE || target == Boolean.class) {
            return this.effectiveBooleanValue();
        }
        if (target == Character.TYPE || target == Character.class) {
            if (this.value.length() > 1 || this.value.length() == 0) {
                throw new XPathException("cannot convert string with length = 0 or length > 1 to Java character");
            }
            return new Character(this.value.charAt(0));
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

