/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import org.apache.oro.text.perl.Perl5Util;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class TimeValue
extends AbstractDateTimeValue {
    private static final String regex = "/([0-2]\\d):([0-6][0-9]):([0-6][0-9])(\\.(\\d{1,3}))?(.*)/";
    private static final String tzre = "/(\\+|-)?([0-1]\\d):(\\d{2})/";

    public TimeValue() {
        this.calendar = new GregorianCalendar();
        this.tzOffset = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
        this.calendar.set(1, 2000);
        this.calendar.set(2, 0);
        this.calendar.set(5, 1);
        this.date = this.calendar.getTime();
    }

    public TimeValue(Calendar cal, int timezone) {
        this.tzOffset = timezone;
        this.explicitTimeZone = true;
        SimpleTimeZone zone = new SimpleTimeZone(this.tzOffset * 60000, "LLL");
        this.calendar = new GregorianCalendar(zone);
        this.calendar.setLenient(false);
        this.calendar.set(1, 2000);
        this.calendar.set(2, 0);
        this.calendar.set(5, 1);
        this.calendar.set(11, cal.get(11));
        this.calendar.set(12, cal.get(12));
        this.calendar.set(13, cal.get(13));
        this.calendar.set(14, cal.get(14));
        this.calendar.set(15, this.tzOffset * 60000);
        this.date = this.calendar.getTime();
    }

    public TimeValue(long milliseconds, int timezone) {
        this.tzOffset = timezone;
        this.explicitTimeZone = true;
        SimpleTimeZone zone = new SimpleTimeZone(this.tzOffset * 60000, "LLL");
        this.calendar = new GregorianCalendar(zone);
        this.calendar.setLenient(false);
        this.calendar.setTimeInMillis(milliseconds);
        this.calendar.set(15, this.tzOffset * 60000);
        this.date = this.calendar.getTime();
    }

    public TimeValue(String timeValue) throws XPathException {
        Perl5Util util = new Perl5Util();
        if (!util.match(regex, timeValue)) {
            throw new XPathException("Type error: string " + timeValue + " cannot be cast into an xs:time");
        }
        String part = util.group(1);
        int hour = Integer.parseInt(part);
        part = util.group(2);
        int minutes = Integer.parseInt(part);
        part = util.group(3);
        int seconds = Integer.parseInt(part);
        part = util.group(5);
        int millis = 0;
        if (part != null) {
            if (part.length() < 3) {
                part = part + "00";
            }
            if (part.length() > 3) {
                part = part.substring(0, 3);
            }
            millis = Integer.parseInt(part);
        }
        if ((part = util.group(6)) != null && part.length() > 0) {
            if (part.equals("Z")) {
                this.explicitTimeZone = true;
                this.tzOffset = 0;
            } else {
                if (!util.match(tzre, part)) {
                    throw new XPathException("Type error: error in  timezone: " + part);
                }
                this.explicitTimeZone = true;
                part = util.group(2);
                this.tzOffset = Integer.parseInt(part) * 60;
                part = util.group(3);
                if (part != null) {
                    int tzminute = Integer.parseInt(part);
                    this.tzOffset += tzminute;
                }
                if ((part = util.group(1)).equals("-")) {
                    this.tzOffset *= -1;
                }
            }
        }
        SimpleTimeZone zone = new SimpleTimeZone(this.tzOffset * 60000, "LLL");
        if (this.explicitTimeZone) {
            this.calendar = new GregorianCalendar(zone);
        } else {
            this.calendar = new GregorianCalendar();
            this.tzOffset = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
        }
        this.calendar.setLenient(false);
        this.calendar.set(2000, 0, hour == 0 ? 2 : 1, hour, minutes, seconds);
        this.calendar.set(14, millis);
        if (this.explicitTimeZone) {
            this.calendar.set(15, this.tzOffset * 60000);
        }
        try {
            this.date = this.calendar.getTime();
        }
        catch (Exception e) {
            throw new XPathException("Type error: string " + timeValue + " cannot be cast into an xs:time");
        }
    }

    public int getType() {
        return 52;
    }

    public TimeValue adjustToTimezone(int offset) {
        Date date = this.calendar.getTime();
        return new TimeValue(date.getTime(), offset);
    }

    public String getStringValue() throws XPathException {
        StringBuffer buf = new StringBuffer();
        this.formatString(buf, this.calendar.get(11), 2);
        buf.append(':');
        this.formatString(buf, this.calendar.get(12), 2);
        buf.append(':');
        this.formatString(buf, this.calendar.get(13), 2);
        int millis = this.calendar.get(14);
        if (millis != 0) {
            buf.append('.');
            String m = this.calendar.get(14) + "";
            while (m.length() < 3) {
                m = "0" + m;
            }
            while (m.endsWith("0")) {
                m = m.substring(0, m.length() - 1);
            }
            buf.append(m);
        }
        if (this.tzOffset == 0) {
            buf.append('Z');
        } else {
            buf.append(this.tzOffset < 0 ? "-" : "+");
            int tzo = this.tzOffset;
            if (tzo < 0) {
                tzo = -tzo;
            }
            int tzhours = tzo / 60;
            this.formatString(buf, tzhours, 2);
            buf.append(':');
            int tzminutes = tzo % 60;
            this.formatString(buf, tzminutes, 2);
        }
        return buf.toString();
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 52: {
                return this;
            }
            case 50: {
                return new DateTimeValue(this.calendar, this.tzOffset);
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:time to " + Type.getTypeName(requiredType));
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.getType() == 52) {
            System.out.println(this.date.getTime() + " eq " + ((TimeValue)other).date.getTime());
            int cmp = this.date.compareTo(((TimeValue)other).date);
            switch (operator) {
                case 4: {
                    return cmp == 0;
                }
                case 5: {
                    return cmp != 0;
                }
                case 0: {
                    return cmp < 0;
                }
                case 3: {
                    return cmp <= 0;
                }
                case 1: {
                    return cmp > 0;
                }
                case 2: {
                    return cmp >= 0;
                }
            }
            throw new XPathException("Unknown operator type in comparison");
        }
        throw new XPathException("Type error: cannot compare xs:time to " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 52) {
            return this.date.compareTo(((TimeValue)other).date);
        }
        throw new XPathException("Type error: cannot compare xs:time to " + Type.getTypeName(other.getType()));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 52) {
            return this.date.compareTo(((TimeValue)other).date) > 0 ? this : other;
        }
        return this.date.compareTo(((TimeValue)other.convertTo((int)52)).date) > 0 ? this : other;
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 52) {
            return this.date.compareTo(((TimeValue)other).date) < 0 ? this : other;
        }
        return this.date.compareTo(((TimeValue)other.convertTo((int)52)).date) < 0 ? this : other;
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        if (other.getType() == 52) {
            TimeValue otherTime = (TimeValue)other;
            long delta = this.calendar.getTimeInMillis() - otherTime.calendar.getTimeInMillis();
            return new DayTimeDurationValue(delta);
        }
        if (other.getType() == 55) {
            long newMillis = this.calendar.getTimeInMillis() - ((DayTimeDurationValue)other).getValueInMilliseconds();
            return new TimeValue(newMillis, this.tzOffset);
        }
        throw new XPathException("Operand to minus should be of type xs:time or xdt:dayTimeDuration; got: " + Type.getTypeName(other.getType()));
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        if (other.getType() == 55) {
            long newMillis = this.calendar.getTimeInMillis() + ((DayTimeDurationValue)other).getValueInMilliseconds();
            return new TimeValue(newMillis, this.tzOffset);
        }
        throw new XPathException("Operand to plus should be of type xdt:dayTimeDuration; got: " + Type.getTypeName(other.getType()));
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        throw new XPathException("Multiplication is not defined for xs:time values");
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        throw new XPathException("Division is not defined for xs:time values");
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(TimeValue.class)) {
            return 0;
        }
        if (javaClass == Date.class) {
            return 1;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(TimeValue.class)) {
            return this;
        }
        if (target == Date.class) {
            return this.calendar.getTime();
        }
        if (target == Object.class) {
            return this;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

