/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.dom.QName;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Type;

public class QNameValue
extends AtomicValue {
    private XQueryContext context;
    private QName qname;

    public QNameValue(XQueryContext context, QName name) {
        this.context = context;
        this.qname = name;
    }

    public int getType() {
        return 24;
    }

    public String getStringValue() throws XPathException {
        if (this.qname.needsNamespaceDecl()) {
            String prefix = this.context.getPrefixForURI(this.qname.getNamespaceURI());
            if (prefix == null) {
                throw new XPathException("namespace " + this.qname.getNamespaceURI() + " is not defined");
            }
            this.qname.setPrefix(prefix);
        }
        return this.qname.toString();
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 24: {
                return this;
            }
        }
        throw new XPathException("A QName cannot be converted to " + Type.getTypeName(requiredType));
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.getType() == 24) {
            int cmp = this.qname.compareTo(((QNameValue)other).qname);
            switch (operator) {
                case 4: {
                    return cmp == 0;
                }
                case 5: {
                    return cmp != 0;
                }
                case 1: {
                    return cmp > 0;
                }
                case 2: {
                    return cmp >= 0;
                }
                case 0: {
                    return cmp < 0;
                }
                case 3: {
                    return cmp >= 0;
                }
            }
            throw new XPathException("Type error: cannot apply operator to QName");
        }
        throw new XPathException("Type error: cannot compare QName to " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 24) {
            return this.qname.compareTo(((QNameValue)other).qname);
        }
        throw new XPathException("Type error: cannot compare QName to " + Type.getTypeName(other.getType()));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: QName");
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: QName");
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(QNameValue.class)) {
            return 0;
        }
        if (javaClass == String.class) {
            return 1;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(QNameValue.class)) {
            return this;
        }
        if (target == String.class) {
            return this.getStringValue();
        }
        if (target == Object.class) {
            return this.qname;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

