/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import org.exist.dom.NodeSet;
import org.exist.util.FastQSort;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;

public class OrderedValueSequence
extends AbstractSequence {
    private OrderSpec[] orderSpecs;
    private Entry[] items = null;
    private int count = 0;
    private long execTime = 0L;

    public OrderedValueSequence(OrderSpec[] orderSpecs, int size) {
        this.orderSpecs = orderSpecs;
        this.items = new Entry[size];
    }

    public int getItemType() {
        return 20;
    }

    public SequenceIterator iterate() {
        return new OrderedValueSequenceIterator();
    }

    public SequenceIterator unorderedIterator() {
        return new OrderedValueSequenceIterator();
    }

    public int getLength() {
        return this.items == null ? 0 : this.count;
    }

    public void add(Item item) throws XPathException {
        if (this.count == this.items.length) {
            Entry[] newItems = new Entry[this.count * 2];
            System.arraycopy(this.items, 0, newItems, 0, this.count);
            this.items = newItems;
        }
        this.items[this.count++] = new Entry(item);
    }

    public void addAll(Sequence other) throws XPathException {
        if (other.getLength() > 0) {
            SequenceIterator i = other.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (next == null) continue;
                this.add(next);
            }
        } else if (other.getLength() == 1) {
            this.add(other.itemAt(0));
        }
    }

    public void sort() {
        FastQSort.sort(this.items, 0, this.count - 1);
    }

    public Item itemAt(int pos) {
        if (this.items != null && pos > -1 && pos < this.count) {
            return this.items[pos].item;
        }
        return null;
    }

    public NodeSet toNodeSet() throws XPathException {
        throw new XPathException("Operation not supported");
    }

    public void removeDuplicates() {
    }

    private class OrderedValueSequenceIterator
    implements SequenceIterator {
        int pos = 0;

        private OrderedValueSequenceIterator() {
        }

        public boolean hasNext() {
            return this.pos < OrderedValueSequence.this.count;
        }

        public Item nextItem() {
            if (this.pos < OrderedValueSequence.this.count) {
                return ((OrderedValueSequence)OrderedValueSequence.this).items[this.pos++].item;
            }
            return null;
        }
    }

    private class Entry
    implements Comparable {
        Item item;
        AtomicValue[] values;

        public Entry(Item item) throws XPathException {
            long start = System.currentTimeMillis();
            this.item = item;
            this.values = new AtomicValue[OrderedValueSequence.this.orderSpecs.length];
            for (int i = 0; i < OrderedValueSequence.this.orderSpecs.length; ++i) {
                Sequence seq = OrderedValueSequence.this.orderSpecs[i].getSortExpression().eval(null);
                this.values[i] = AtomicValue.EMPTY_VALUE;
                if (seq.getLength() == 1) {
                    this.values[i] = seq.itemAt(0).atomize();
                    continue;
                }
                if (seq.getLength() <= 1) continue;
                throw new XPathException("expected a single value for order expression " + OrderedValueSequence.this.orderSpecs[i].getSortExpression().pprint() + " ; found: " + seq.getLength());
            }
            OrderedValueSequence.this.execTime = OrderedValueSequence.this.execTime + (System.currentTimeMillis() - start);
        }

        public int compareTo(Object o) {
            Entry other = (Entry)o;
            int cmp = 0;
            for (int i = 0; i < this.values.length; ++i) {
                try {
                    AtomicValue a = this.values[i];
                    AtomicValue b = other.values[i];
                    cmp = a == AtomicValue.EMPTY_VALUE && b != AtomicValue.EMPTY_VALUE ? ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? -1 : 1) : (b == AtomicValue.EMPTY_VALUE && a != AtomicValue.EMPTY_VALUE ? ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? 1 : -1) : a.compareTo(OrderedValueSequence.this.orderSpecs[i].getCollator(), b));
                    if ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 1) != 0) {
                        cmp *= -1;
                    }
                    if (cmp == 0) continue;
                    break;
                }
                catch (XPathException e) {
                    // empty catch block
                }
            }
            return cmp;
        }
    }
}

