/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Type;

public abstract class NumericValue
extends ComputableValue {
    public abstract String getStringValue() throws XPathException;

    public abstract AtomicValue convertTo(int var1) throws XPathException;

    public double getDouble() throws XPathException {
        return ((DoubleValue)this.convertTo(32)).getValue();
    }

    public long getLong() throws XPathException {
        return ((IntegerValue)this.convertTo(31)).getValue();
    }

    public int getInt() throws XPathException {
        return (int)((IntegerValue)this.convertTo(31)).getValue();
    }

    public boolean isNaN() {
        return false;
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 30)) {
            double otherVal = ((NumericValue)other).getDouble();
            double val = this.getDouble();
            switch (operator) {
                case 4: {
                    return val == otherVal;
                }
                case 5: {
                    return val != otherVal;
                }
                case 1: {
                    return val > otherVal;
                }
                case 2: {
                    return val >= otherVal;
                }
                case 0: {
                    return val < otherVal;
                }
                case 3: {
                    return val <= otherVal;
                }
            }
            throw new XPathException("Type error: cannot apply operator to numeric value");
        }
        throw new XPathException("Type error: cannot compare operands: " + Type.getTypeName(this.getType()) + " and " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 30)) {
            double otherVal = ((NumericValue)other).getDouble();
            double val = this.getDouble();
            if (val == otherVal) {
                return 0;
            }
            if (val > otherVal) {
                return 1;
            }
            return -1;
        }
        throw new XPathException("cannot compare numeric value to non-numeric value");
    }

    public abstract NumericValue negate() throws XPathException;

    public abstract NumericValue ceiling() throws XPathException;

    public abstract NumericValue floor() throws XPathException;

    public abstract NumericValue round() throws XPathException;

    public abstract NumericValue mod(NumericValue var1) throws XPathException;

    public abstract NumericValue abs() throws XPathException;

    public abstract AtomicValue max(Collator var1, AtomicValue var2) throws XPathException;

    public abstract AtomicValue min(Collator var1, AtomicValue var2) throws XPathException;
}

