/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class FloatValue
extends NumericValue {
    public static final FloatValue NaN = new FloatValue(Float.NaN);
    public static final FloatValue ZERO = new FloatValue(0.0f);
    protected float value;

    public FloatValue(float value) {
        this.value = value;
    }

    public FloatValue(String stringValue) throws XPathException {
        try {
            this.value = Float.parseFloat(stringValue);
        }
        catch (NumberFormatException e) {
            throw new XPathException("cannot convert string '" + stringValue + "' into a float");
        }
    }

    public String getStringValue() throws XPathException {
        return Float.toString(this.value);
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return this.value != 0.0f;
    }

    public boolean isNaN() {
        return this.value == Float.NaN;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 30: 
            case 33: {
                return this;
            }
            case 34: {
                return new DoubleValue(this.value);
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return new IntegerValue((long)this.value, requiredType);
            }
            case 23: {
                return (double)this.value == 0.0 || (double)this.value == Double.NaN ? BooleanValue.FALSE : BooleanValue.TRUE;
            }
        }
        throw new XPathException("cannot convert double value '" + this.value + "' into " + Type.getTypeName(requiredType));
    }

    public NumericValue negate() throws XPathException {
        return new FloatValue(-this.value);
    }

    public NumericValue ceiling() throws XPathException {
        return new FloatValue((float)Math.ceil(this.value));
    }

    public NumericValue floor() throws XPathException {
        return new FloatValue((float)Math.floor(this.value));
    }

    public NumericValue round() throws XPathException {
        return new FloatValue(Math.round(this.value));
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(this.value - ((FloatValue)other).value);
        }
        return this.minus((ComputableValue)other.convertTo(this.getType()));
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(this.value + ((FloatValue)other).value);
        }
        return this.plus((ComputableValue)other.convertTo(this.getType()));
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(this.value * ((FloatValue)other).value);
        }
        return this.mult((ComputableValue)other.convertTo(this.getType()));
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(this.value / ((FloatValue)other).value);
        }
        return this.div((ComputableValue)other.convertTo(this.getType()));
    }

    public NumericValue mod(NumericValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(this.value % ((FloatValue)other).value);
        }
        return this.mod((NumericValue)other.convertTo(this.getType()));
    }

    public NumericValue abs() throws XPathException {
        return new FloatValue(Math.abs(this.value));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(Math.max(this.value, ((FloatValue)other).value));
        }
        return ((FloatValue)this.convertTo(other.getType())).max(collator, other);
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 33)) {
            return new FloatValue(Math.min(this.value, ((FloatValue)other).value));
        }
        return ((FloatValue)this.convertTo(other.getType())).min(collator, other);
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(FloatValue.class)) {
            return 0;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 3;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 4;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 5;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 6;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 2;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 1;
        }
        if (javaClass == String.class) {
            return 7;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 8;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(FloatValue.class)) {
            return this;
        }
        if (target == Double.class || target == Double.TYPE) {
            return new Double(this.value);
        }
        if (target == Float.class || target == Float.TYPE) {
            return new Float(this.value);
        }
        if (target == Long.class || target == Long.TYPE) {
            return new Long(((IntegerValue)this.convertTo(37)).getValue());
        }
        if (target == Integer.class || target == Integer.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return new Integer((int)v.getValue());
        }
        if (target == Short.class || target == Short.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return new Short((short)v.getValue());
        }
        if (target == Byte.class || target == Byte.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return new Byte((byte)v.getValue());
        }
        if (target == String.class) {
            return this.getStringValue();
        }
        if (target == Boolean.class) {
            return this.effectiveBooleanValue();
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

