/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.math.BigDecimal;
import java.text.Collator;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class DoubleValue
extends NumericValue {
    public static final DoubleValue NaN = new DoubleValue(Double.NaN);
    public static final DoubleValue ZERO = new DoubleValue(0.0);
    private double value;

    public DoubleValue(double value) {
        this.value = value;
    }

    public DoubleValue(String stringValue) throws XPathException {
        try {
            this.value = Double.parseDouble(stringValue);
        }
        catch (NumberFormatException e) {
            throw new XPathException("cannot convert string '" + stringValue + "' into a double");
        }
    }

    public int getType() {
        return 34;
    }

    public String getStringValue() {
        String sign;
        int len;
        if (!Double.isInfinite(this.value) && (this.value >= 9.007199254740992E15 || -this.value >= 9.007199254740992E15)) {
            return new BigDecimal(this.value).toString();
        }
        String s = Double.toString(this.value);
        if (s.charAt((len = s.length()) - 2) == '.' && s.charAt(len - 1) == '0') {
            if (s.equals("-0.0")) {
                return "0";
            }
            return s;
        }
        int e = s.indexOf(69);
        if (e < 0) {
            if (s.equals("Infinity")) {
                return "INF";
            }
            if (s.equals("-Infinity")) {
                return "-INF";
            }
            while (s.charAt(len - 1) == '0' && s.charAt(len - 2) != '.') {
                s = s.substring(0, --len);
            }
            return s;
        }
        int exp = Integer.parseInt(s.substring(e + 1));
        if (s.charAt(0) == '-') {
            sign = "-";
            s = s.substring(1);
            --e;
        } else {
            sign = "";
        }
        int nDigits = e - 2;
        if (exp >= nDigits) {
            return sign + s.substring(0, 1) + s.substring(2, e) + DoubleValue.zeros(exp - nDigits);
        }
        if (exp > 0) {
            return sign + s.substring(0, 1) + s.substring(2, 2 + exp) + "." + s.substring(2 + exp, e);
        }
        while (s.charAt(e - 1) == '0') {
            --e;
        }
        return sign + "0." + DoubleValue.zeros(-1 - exp) + s.substring(0, 1) + s.substring(2, e);
    }

    private static String zeros(int n) {
        char[] buf = new char[n];
        for (int i = 0; i < n; ++i) {
            buf[i] = 48;
        }
        return new String(buf);
    }

    public double getValue() {
        return this.value;
    }

    public Item itemAt(int pos) {
        return pos == 0 ? this : null;
    }

    public boolean isNaN() {
        return this.value == Double.NaN;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 30: 
            case 34: {
                return this;
            }
            case 33: {
                if (this.value < (double)1.4E-45f || this.value > 3.4028234663852886E38) {
                    throw new XPathException("Value is out of range for type xs:float");
                }
                return new FloatValue((float)this.value);
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 32: {
                return new DecimalValue(new BigDecimal(this.value));
            }
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return new IntegerValue((long)this.value, requiredType);
            }
            case 23: {
                return this.value == 0.0 || this.value == Double.NaN ? BooleanValue.FALSE : BooleanValue.TRUE;
            }
        }
        throw new XPathException("cannot convert double value '" + this.value + "' into " + Type.getTypeName(requiredType));
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return this.value != 0.0 && this.value != Double.NaN;
    }

    public double getDouble() throws XPathException {
        return this.value;
    }

    public int getInt() throws XPathException {
        return (int)Math.round(this.value);
    }

    public long getLong() throws XPathException {
        return Math.round(this.value);
    }

    public void setValue(double val) {
        this.value = val;
    }

    public NumericValue ceiling() throws XPathException {
        return new DoubleValue(Math.ceil(this.value));
    }

    public NumericValue floor() throws XPathException {
        return new DoubleValue(Math.floor(this.value));
    }

    public NumericValue round() throws XPathException {
        return new DoubleValue(Math.round(this.value));
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(this.value - ((DoubleValue)other).value);
        }
        return this.minus((ComputableValue)other.convertTo(this.getType()));
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(this.value + ((DoubleValue)other).value);
        }
        return this.plus((ComputableValue)other.convertTo(this.getType()));
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(this.value * ((DoubleValue)other).value);
        }
        return ((ComputableValue)this.convertTo(other.getType())).mult(other);
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(this.value / ((DoubleValue)other).value);
        }
        return this.div((ComputableValue)other.convertTo(this.getType()));
    }

    public NumericValue mod(NumericValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(this.value % ((DoubleValue)other).value);
        }
        return this.mod((NumericValue)other.convertTo(this.getType()));
    }

    public NumericValue negate() throws XPathException {
        return new DoubleValue(-this.value);
    }

    public NumericValue abs() throws XPathException {
        return new DoubleValue(Math.abs(this.value));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(Math.max(this.value, ((DoubleValue)other).value));
        }
        return new DoubleValue(Math.max(this.value, ((DoubleValue)other.convertTo((int)this.getType())).value));
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 34)) {
            return new DoubleValue(Math.min(this.value, ((DoubleValue)other).value));
        }
        return new DoubleValue(Math.min(this.value, ((DoubleValue)other.convertTo((int)this.getType())).value));
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(DoubleValue.class)) {
            return 0;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 3;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 4;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 5;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 6;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 1;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 2;
        }
        if (javaClass == String.class) {
            return 7;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 8;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(DoubleValue.class)) {
            return this;
        }
        if (target == Double.class || target == Double.TYPE) {
            return new Double(this.value);
        }
        if (target == Float.class || target == Float.TYPE) {
            return new Float(this.value);
        }
        if (target == Long.class || target == Long.TYPE) {
            return new Long(((IntegerValue)this.convertTo(37)).getValue());
        }
        if (target == Integer.class || target == Integer.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return new Integer((int)v.getValue());
        }
        if (target == Short.class || target == Short.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return new Short((short)v.getValue());
        }
        if (target == Byte.class || target == Byte.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return new Byte((byte)v.getValue());
        }
        if (target == String.class) {
            return this.getStringValue();
        }
        if (target == Boolean.class) {
            return this.effectiveBooleanValue();
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

