/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import org.apache.oro.text.perl.Perl5Util;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.YearMonthDurationValue;

public class DateValue
extends AbstractDateTimeValue {
    private static final String regex = "/(\\+|-)?(\\d{4})-([0-1]\\d)-(\\d{2})(.*)/";
    private static final String tzre = "/(\\+|-)?([0-1]\\d):(\\d{2})/";

    public DateValue() {
        this.calendar = new GregorianCalendar();
        this.tzOffset = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
        this.date = this.calendar.getTime();
    }

    public DateValue(String dateString) throws XPathException {
        Perl5Util util = new Perl5Util();
        if (!util.match(regex, dateString)) {
            throw new XPathException("Type error: string " + dateString + " cannot be cast into an xs:date");
        }
        String part = util.group(1);
        int era = 1;
        if (part != null && part.equals("-")) {
            era = -1;
        }
        part = util.group(2);
        int year = Integer.parseInt(part) * era;
        part = util.group(3);
        int month = Integer.parseInt(part);
        part = util.group(4);
        int day = Integer.parseInt(part);
        this.tzOffset = 0;
        part = util.group(5);
        if (part != null && part.length() > 0) {
            if (part.equals("Z")) {
                this.explicitTimeZone = true;
                this.tzOffset = 0;
            } else {
                if (!util.match(tzre, part)) {
                    throw new XPathException("Type error: error in  timezone: " + part);
                }
                this.explicitTimeZone = true;
                part = util.group(2);
                this.tzOffset = Integer.parseInt(part) * 60;
                part = util.group(3);
                if (part != null) {
                    int tzminute = Integer.parseInt(part);
                    this.tzOffset += tzminute;
                }
                if ((part = util.group(1)).equals("-")) {
                    this.tzOffset *= -1;
                }
            }
        }
        SimpleTimeZone zone = new SimpleTimeZone(this.tzOffset * 60000, "LLL");
        if (this.explicitTimeZone) {
            this.calendar = new GregorianCalendar(zone);
        } else {
            this.calendar = new GregorianCalendar();
            this.tzOffset = (this.calendar.get(15) + this.calendar.get(16)) / 60000;
        }
        this.calendar.setLenient(false);
        this.calendar.set(year, month - 1, day, 0, 0, 0);
        this.calendar.set(14, 0);
        if (this.explicitTimeZone) {
            this.calendar.set(15, this.tzOffset * 60000);
        }
        try {
            this.date = this.calendar.getTime();
        }
        catch (Exception e) {
            throw new XPathException("Type error: string " + dateString + " cannot be cast into an xs:date");
        }
    }

    public DateValue(Calendar cal, int timezone) {
        this.tzOffset = timezone;
        this.explicitTimeZone = true;
        SimpleTimeZone zone = new SimpleTimeZone(this.tzOffset * 60000, "LLL");
        this.calendar = new GregorianCalendar(zone);
        this.calendar.setLenient(false);
        this.calendar.set(cal.get(1), cal.get(2), cal.get(5));
        this.calendar.set(15, this.tzOffset * 60000);
        this.date = this.calendar.getTime();
    }

    public DateValue(long milliseconds, int timezone) {
        this.tzOffset = timezone;
        this.explicitTimeZone = true;
        SimpleTimeZone zone = new SimpleTimeZone(this.tzOffset * 60000, "LLL");
        this.calendar = new GregorianCalendar(zone);
        this.calendar.setLenient(false);
        this.calendar.setTimeInMillis(milliseconds);
        this.calendar.set(15, this.tzOffset * 60000);
        this.date = this.calendar.getTime();
    }

    public int getType() {
        return 51;
    }

    public String getStringValue() throws XPathException {
        StringBuffer buf = new StringBuffer();
        int year = this.calendar.get(1);
        if (year < 0) {
            buf.append('-');
            year *= -1;
        }
        this.formatString(buf, year, year > 9999 ? (this.calendar.get(1) + "").length() : 4);
        buf.append('-');
        this.formatString(buf, this.calendar.get(2) + 1, 2);
        buf.append('-');
        this.formatString(buf, this.calendar.get(5), 2);
        if (this.tzOffset == 0) {
            buf.append('Z');
        } else {
            buf.append(this.tzOffset < 0 ? "-" : "+");
            int tzo = this.tzOffset;
            if (tzo < 0) {
                tzo = -tzo;
            }
            int tzhours = tzo / 60;
            this.formatString(buf, tzhours, 2);
            buf.append(':');
            int tzminutes = tzo % 60;
            this.formatString(buf, tzminutes, 2);
        }
        return buf.toString();
    }

    public DateValue adjustToTimezone(int offset) {
        Date date = this.calendar.getTime();
        return new DateValue(date.getTime(), offset);
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 51: {
                return this;
            }
            case 50: {
                return new DateTimeValue(this.calendar, this.tzOffset);
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:date to " + Type.getTypeName(requiredType));
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.getType() == 51) {
            int cmp = this.date.compareTo(((DateValue)other).date);
            switch (operator) {
                case 4: {
                    return cmp == 0;
                }
                case 5: {
                    return cmp != 0;
                }
                case 0: {
                    return cmp < 0;
                }
                case 3: {
                    return cmp <= 0;
                }
                case 1: {
                    return cmp > 0;
                }
                case 2: {
                    return cmp >= 0;
                }
            }
            throw new XPathException("Unknown operator type in comparison");
        }
        throw new XPathException("Type error: cannot compare xs:date to " + Type.getTypeName(other.getType()));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 51) {
            return this.date.compareTo(((DateValue)other).date);
        }
        throw new XPathException("Type error: cannot compare xs:date to " + Type.getTypeName(other.getType()));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 51) {
            return this.date.compareTo(((DateValue)other).date) > 0 ? this : other;
        }
        return this.date.compareTo(((DateValue)other.convertTo((int)51)).date) > 0 ? this : other;
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 51) {
            return this.date.compareTo(((DateValue)other).date) < 0 ? this : other;
        }
        return this.date.compareTo(((DateValue)other.convertTo((int)51)).date) < 0 ? this : other;
    }

    public ComputableValue minus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 54: {
                YearMonthDurationValue value = (YearMonthDurationValue)other;
                Calendar ncal = (Calendar)this.calendar.clone();
                ncal.add(1, value.negative ? value.year : -value.year);
                ncal.add(2, value.negative ? value.month : -value.month);
                return new DateValue(ncal, this.tzOffset);
            }
            case 55: {
                DayTimeDurationValue dtv = (DayTimeDurationValue)other;
                Calendar ncal = (Calendar)this.calendar.clone();
                ncal.add(5, dtv.day);
                return new DateValue(ncal, this.tzOffset);
            }
            case 51: {
                return new DayTimeDurationValue(this.calendar.getTimeInMillis() - ((DateValue)other).calendar.getTimeInMillis());
            }
        }
        throw new XPathException("Operand to plus should be of type xdt:yearMonthDuration or xdt:dayTimeDuration; got: " + Type.getTypeName(other.getType()));
    }

    public ComputableValue plus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 54: {
                YearMonthDurationValue value = (YearMonthDurationValue)other;
                Calendar ncal = (Calendar)this.calendar.clone();
                ncal.add(1, value.negative ? -value.year : value.year);
                ncal.add(2, value.negative ? -value.month : value.month);
                return new DateValue(ncal, this.tzOffset);
            }
            case 55: {
                DayTimeDurationValue dtv = (DayTimeDurationValue)other;
                Calendar ncal = (Calendar)this.calendar.clone();
                ncal.add(5, dtv.negative ? -dtv.day : dtv.day);
                return new DateValue(ncal, this.tzOffset);
            }
        }
        throw new XPathException("Operand to plus should be of type xdt:yearMonthDuration or xdt:dayTimeDuration; got: " + Type.getTypeName(other.getType()));
    }

    public ComputableValue mult(ComputableValue other) throws XPathException {
        return null;
    }

    public ComputableValue div(ComputableValue other) throws XPathException {
        return null;
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(DateValue.class)) {
            return 0;
        }
        if (javaClass == Date.class) {
            return 1;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(DateValue.class)) {
            return this;
        }
        if (target == Date.class) {
            return this.calendar.getTime();
        }
        if (target == Object.class) {
            return this;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

