/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.text.Collator;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class BooleanValue
extends AtomicValue {
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);
    private boolean value;

    public static final BooleanValue valueOf(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public BooleanValue(boolean bool) {
        this.value = bool;
    }

    public int getType() {
        return 23;
    }

    public String getStringValue() throws XPathException {
        return this.value ? "true" : "false";
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 23: {
                return this;
            }
            case 30: 
            case 31: {
                return new IntegerValue(this.value ? 1L : 0L);
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
        }
        throw new XPathException("cannot convert boolean '" + this.value + "' to " + requiredType);
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 23)) {
            boolean otherVal = ((BooleanValue)other).getValue();
            switch (operator) {
                case 4: {
                    return this.value == otherVal;
                }
                case 5: {
                    return this.value != otherVal;
                }
                case 0: {
                    return !this.value && otherVal;
                }
                case 1: {
                    return this.value && !otherVal;
                }
            }
            throw new XPathException("Type error: cannot apply this operator to a boolean value");
        }
        throw new XPathException("Type error: cannot convert operand to boolean");
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        boolean otherVal = other.effectiveBooleanValue();
        if (otherVal == this.value) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return -1;
    }

    public boolean effectiveBooleanValue() throws XPathException {
        return this.value;
    }

    public boolean getValue() {
        return this.value;
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 23) {
            boolean otherValue = ((BooleanValue)other).value;
            return this.value && !otherValue ? this : other;
        }
        throw new XPathException("Invalid argument to aggregate function: expected boolean, got: " + Type.getTypeName(other.getType()));
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 23) {
            boolean otherValue = ((BooleanValue)other).value;
            return !this.value && otherValue ? this : other;
        }
        throw new XPathException("Invalid argument to aggregate function: expected boolean, got: " + Type.getTypeName(other.getType()));
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(BooleanValue.class)) {
            return 0;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 1;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(BooleanValue.class)) {
            return this;
        }
        if (target == Boolean.class || target == Boolean.TYPE || target == Object.class) {
            return this.value;
        }
        if (target == String.class || target == CharSequence.class) {
            StringValue v = (StringValue)this.convertTo(22);
            return v.value;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

