/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Collator;
import org.exist.xquery.Constants;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class AnyURIValue
extends AtomicValue {
    private String uri;

    public AnyURIValue(String s) throws XPathException {
        try {
            URI uri = new URI(s);
        }
        catch (URISyntaxException e) {
            throw new XPathException("Type error: the given string " + s + " cannot be cast to xs:anyURI");
        }
        this.uri = s;
    }

    public int getType() {
        return 25;
    }

    public String getStringValue() throws XPathException {
        return this.uri;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 25: {
                return this;
            }
            case 22: {
                return new StringValue(this.uri);
            }
        }
        throw new XPathException("Type error: cannot cast xs:anyURI to " + Type.getTypeName(requiredType));
    }

    public boolean compareTo(Collator collator, int operator, AtomicValue other) throws XPathException {
        if (other.getType() == 25) {
            String otherURI = other.getStringValue();
            int cmp = this.uri.compareTo(otherURI);
            switch (operator) {
                case 4: {
                    return cmp == 0;
                }
                case 5: {
                    return cmp != 0;
                }
            }
            throw new XPathException("Type error: cannot apply operator " + Constants.OPS[operator] + " to xs:anyURI");
        }
        return this.compareTo(collator, operator, other.convertTo(25));
    }

    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 25) {
            String otherURI = other.getStringValue();
            return this.uri.compareTo(otherURI);
        }
        return this.compareTo(collator, other.convertTo(25));
    }

    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("max is not supported for values of type xs:anyURI");
    }

    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("min is not supported for values of type xs:anyURI");
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(AnyURIValue.class)) {
            return 0;
        }
        if (javaClass == URI.class) {
            return 1;
        }
        if (javaClass == URL.class) {
            return 2;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 3;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(AnyURIValue.class)) {
            return this;
        }
        if (target == URI.class) {
            try {
                return new URI(this.uri);
            }
            catch (URISyntaxException e) {
                throw new XPathException("failed to convert " + this.uri + " into a Java URI: " + e.getMessage(), e);
            }
        }
        if (target == URL.class) {
            try {
                return new URL(this.uri);
            }
            catch (MalformedURLException e) {
                throw new XPathException("failed to convert " + this.uri + " into a Java URL: " + e.getMessage(), e);
            }
        }
        if (target == String.class || target == CharSequence.class) {
            return this.uri;
        }
        if (target == Object.class) {
            return this.uri;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }
}

