/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeProxy;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public abstract class AbstractSequence
implements Sequence {
    protected AbstractSequence() {
    }

    public abstract int getItemType();

    public abstract SequenceIterator iterate();

    public abstract SequenceIterator unorderedIterator();

    public abstract int getLength();

    public int getCardinality() {
        switch (this.getLength()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 6;
    }

    public AtomicValue convertTo(int requiredType) throws XPathException {
        Item first = this.itemAt(0);
        if (Type.subTypeOf(first.getType(), 20)) {
            return ((AtomicValue)first).convertTo(requiredType);
        }
        return new StringValue(first.getStringValue()).convertTo(requiredType);
    }

    public String getStringValue() throws XPathException {
        if (this.getLength() == 0) {
            return "";
        }
        Item first = this.iterate().nextItem();
        return first.getStringValue();
    }

    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException e) {
            return super.toString();
        }
    }

    public abstract void add(Item var1) throws XPathException;

    public void addAll(Sequence other) throws XPathException {
        SequenceIterator i = other.iterate();
        while (i.hasNext()) {
            this.add(i.nextItem());
        }
    }

    public abstract Item itemAt(int var1);

    public DocumentSet getDocumentSet() {
        return DocumentSet.EMPTY_DOCUMENT_SET;
    }

    public boolean effectiveBooleanValue() throws XPathException {
        int len = this.getLength();
        if (len == 0) {
            return false;
        }
        if (len > 1) {
            return true;
        }
        Item first = this.itemAt(0);
        if (first instanceof StringValue) {
            return ((StringValue)first).effectiveBooleanValue();
        }
        if (first instanceof BooleanValue) {
            return ((BooleanValue)first).getValue();
        }
        if (first instanceof NumericValue) {
            return ((NumericValue)first).effectiveBooleanValue();
        }
        return true;
    }

    public int conversionPreference(Class javaClass) {
        if (javaClass.isAssignableFrom(Sequence.class)) {
            return 0;
        }
        if (javaClass.isAssignableFrom(List.class) || javaClass.isArray()) {
            return 1;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        if (this.getLength() > 0) {
            return this.itemAt(0).conversionPreference(javaClass);
        }
        return Integer.MAX_VALUE;
    }

    public Object toJavaObject(Class target) throws XPathException {
        if (target.isAssignableFrom(Sequence.class)) {
            return this;
        }
        if (target.isArray()) {
            Class<?> componentType = target.getComponentType();
            Object array = Array.newInstance(componentType, this.getLength());
            if (!target.isInstance(array)) {
                return null;
            }
            int index = 0;
            SequenceIterator i = this.iterate();
            while (i.hasNext()) {
                Item item = i.nextItem();
                Object obj = item.toJavaObject(componentType);
                Array.set(array, index, obj);
                ++index;
            }
            return array;
        }
        if (target.isAssignableFrom(List.class)) {
            ArrayList<Item> l = new ArrayList<Item>(this.getLength());
            SequenceIterator i = this.iterate();
            while (i.hasNext()) {
                l.add(i.nextItem());
            }
            return l;
        }
        if (this.getLength() > 0) {
            return this.itemAt(0).toJavaObject(target);
        }
        return null;
    }

    public void setSelfAsContext() {
        SequenceIterator i = this.unorderedIterator();
        while (i.hasNext()) {
            Item next = i.nextItem();
            if (!Type.subTypeOf(next.getType(), -1) || !(next instanceof NodeProxy)) continue;
            NodeProxy n = (NodeProxy)next;
            n.addContextNode(n);
        }
    }

    public boolean isCached() {
        return false;
    }

    public void setIsCached(boolean cached) {
    }
}

