/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.exist.xmldb.XQueryService;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;

public class XQueryUseCase {
    private static final String URI = "xmldb:exist:///db";
    private static final String baseDir = "samples/xquery/use-cases";
    private Collection root = null;

    protected void setUp() throws Exception {
        Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
        Database database = (Database)cl.newInstance();
        database.setProperty("create-database", "true");
        DatabaseManager.registerDatabase((Database)database);
        this.root = DatabaseManager.getCollection((String)URI, (String)"admin", null);
    }

    public void doTest(String useCase) throws Exception {
        CollectionManagementService service = (CollectionManagementService)this.root.getService("CollectionManagementService", "1.0");
        this.root = service.createCollection(useCase);
        File file = new File(baseDir + File.separatorChar + useCase);
        if (!file.canRead() || !file.isDirectory()) {
            throw new RuntimeException("Cannot read data for use-case " + useCase);
        }
        this.setupData(file);
        this.processQueries(file);
    }

    protected void processQueries(File file) throws Exception {
        File[] files = file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().startsWith("q") && pathname.getName().endsWith(".xq");
            }
        });
        for (int i = 0; i < files.length; ++i) {
            System.err.println("processing use-case: " + files[i].getAbsolutePath());
            System.err.println("========================================================================");
            String query = this.readQuery(files[i]);
            System.err.println(query);
            System.err.println("_________________________________________________________________________________");
            XQueryService service = (XQueryService)this.root.getService("XQueryService", "1.0");
            try {
                ResourceSet results = service.query(query);
                int j = 0;
                while ((long)j < results.getSize()) {
                    String output = (String)results.getResource((long)j).getContent();
                    System.err.println(output);
                    ++j;
                }
            }
            catch (Exception e) {
                Throwable cause = e.getCause();
                if (cause == null) {
                    cause = e;
                }
                System.err.println("Exception: " + e.getClass() + " - " + cause);
                for (int j = 0; j < 4; ++j) {
                    StackTraceElement el = cause.getStackTrace()[j];
                    System.err.println(el);
                }
                e.getStackTrace();
                throw e;
            }
            System.err.println("========================================================================");
        }
    }

    protected void setupData(File file) throws Exception {
        File[] files = file.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".xml");
            }
        });
        for (int i = 0; i < files.length; ++i) {
            XMLResource res = (XMLResource)this.root.createResource(files[i].getName(), "XMLResource");
            res.setContent((Object)files[i]);
            this.root.storeResource((Resource)res);
        }
    }

    protected String readQuery(File f) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] t = new byte[512];
        FileInputStream is = new FileInputStream(f);
        int count = 0;
        while ((count = ((InputStream)is).read(t)) != -1) {
            os.write(t, 0, count);
        }
        return new String(os.toString("UTF-8"));
    }
}

