/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.test;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exist.xmldb.XPathQueryServiceImpl;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Database;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceIterator;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;
import org.xmldb.api.modules.XMLResource;
import org.xmldb.api.modules.XPathQueryService;

public class XPathQueryTest
extends TestCase {
    private static final String URI = "xmldb:exist:///db";
    private static final String nested = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><test><c></c><b><c><b></b></c></b><b></b><c></c></test>";
    private static final String numbers = "<test><item id='1'><price>5.6</price><stock>22</stock></item><item id='2'><price>7.4</price><stock>43</stock></item><item id='3'><price>18.4</price><stock>5</stock></item><item id='4'><price>65.54</price><stock>16</stock></item></test>";
    private static final String namespaces = "<test xmlns='http://www.foo.com'><section><title>Test Document</title><c:comment xmlns:c='http://www.other.com'>This is my comment</c:comment></section></test>";
    private static final String strings = "<test><string>Hello World!</string><string value='Hello World!'/><string>Hello</string></test>";
    private static final String nested2 = "<RootElement><ChildA><ChildB id=\"2\"/></ChildA></RootElement>";
    private static final String ids = "<!DOCTYPE test [<!ELEMENT test (a*, b*)><!ELEMENT a EMPTY><!ELEMENT b (name)><!ELEMENT name (#PCDATA)><!ATTLIST a ref IDREF #IMPLIED><!ATTLIST b id ID #IMPLIED>]><test><a ref=\"id1\"/><a ref=\"id1\"/><b id=\"id1\"><name>one</name></b></test>";
    private Collection testCollection;

    public XPathQueryTest(String name) {
        super(name);
    }

    protected void setUp() {
        try {
            Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
            Database database = (Database)cl.newInstance();
            database.setProperty("create-database", "true");
            DatabaseManager.registerDatabase((Database)database);
            Collection root = DatabaseManager.getCollection((String)URI, (String)"admin", null);
            CollectionManagementService service = (CollectionManagementService)root.getService("CollectionManagementService", "1.0");
            this.testCollection = service.createCollection("test");
            XPathQueryTest.assertNotNull((Object)this.testCollection);
        }
        catch (ClassNotFoundException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (XMLDBException e) {
            e.printStackTrace();
        }
    }

    public void testStarAxis() {
        try {
            XPathQueryService service = this.storeXMLStringAndGetQueryService("numbers.xml", numbers);
            ResourceSet result = service.queryResource("numbers.xml", "/*/item");
            System.out.println("testStarAxis 1: ========");
            this.printResult(result);
            XPathQueryTest.assertEquals((String)"XPath: /*/item", (long)4L, (long)result.getSize());
            result = service.queryResource("numbers.xml", "/test/*");
            System.out.println("testStarAxis  2: ========");
            this.printResult(result);
            XPathQueryTest.assertEquals((String)"XPath: /test/*", (long)4L, (long)result.getSize());
            result = service.queryResource("numbers.xml", "/test/descendant-or-self::*");
            System.out.println("testStarAxis  3: ========");
            this.printResult(result);
            XPathQueryTest.assertEquals((String)"XPath: /test/descendant-or-self::*", (long)12L, (long)result.getSize());
            System.out.println("testStarAxis 4: ========");
            this.printResult(result);
            XPathQueryTest.assertEquals((String)"XPath: /*/*", (long)12L, (long)result.getSize());
        }
        catch (XMLDBException e) {
            System.out.println("testStarAxis(): XMLDBException: " + (Object)((Object)e));
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    public void testParentSelfAxis() {
        try {
            XPathQueryService service = this.storeXMLStringAndGetQueryService("nested2.xml", nested2);
            this.queryResource(service, "nested2.xml", "/RootElement/descendant::*/parent::ChildA", 1);
            this.queryResource(service, "nested2.xml", "/RootElement/descendant::*[self::ChildB]/parent::RootElement", 0);
            this.queryResource(service, "nested2.xml", "/RootElement/descendant::*[self::ChildA]/parent::RootElement", 1);
        }
        catch (XMLDBException e) {
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    public void testNumbers() {
        try {
            XPathQueryService service = this.storeXMLStringAndGetQueryService("numbers.xml", numbers);
            ResourceSet result = this.queryResource(service, "numbers.xml", "sum(/test/item/price)", 1);
            XPathQueryTest.assertEquals((Object)"96.94", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "round(sum(/test/item/price))", 1);
            XPathQueryTest.assertEquals((Object)"97.0", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "floor(sum(/test/item/stock))", 1);
            XPathQueryTest.assertEquals((Object)"86.0", (Object)result.getResource(0L).getContent());
            this.queryResource(service, "numbers.xml", "/test/item[round(price + 3) > 60]", 1);
            result = this.queryResource(service, "numbers.xml", "min( 123456789123456789123456789, 123456789123456789123456789123456789123456789 )", 1);
            XPathQueryTest.assertEquals((String)"minimum of big integers", (Object)"123456789123456789123456789", (Object)result.getResource(0L).getContent());
        }
        catch (XMLDBException e) {
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    public void testStrings() {
        try {
            XPathQueryService service = this.storeXMLStringAndGetQueryService("strings.xml", strings);
            ResourceSet result = this.queryResource(service, "strings.xml", "substring(/test/string[1], 1, 5)", 1);
            XPathQueryTest.assertEquals((Object)"Hello", (Object)result.getResource(0L).getContent());
            this.queryResource(service, "strings.xml", "/test/string[starts-with(string(.), 'Hello')]", 2);
            result = this.queryResource(service, "strings.xml", "count(/test/item/price)", 1, "Query should return an empty set (wrong document)");
            XPathQueryTest.assertEquals((Object)"0", (Object)result.getResource(0L).getContent());
        }
        catch (XMLDBException e) {
            System.out.println("testStrings(): XMLDBException: " + (Object)((Object)e));
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    public void testBoolean() {
        try {
            System.out.println("Testing effective boolean value of expressions ...");
            XPathQueryService service = this.storeXMLStringAndGetQueryService("numbers.xml", numbers);
            ResourceSet result = this.queryResource(service, "numbers.xml", "boolean(1.0)", 1);
            XPathQueryTest.assertEquals((String)"boolean value of 1.0 should be true", (Object)"true", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean(0.0)", 1);
            XPathQueryTest.assertEquals((String)"boolean value of 0.0 should be false", (Object)"false", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean(xs:double(0.0))", 1);
            XPathQueryTest.assertEquals((String)"boolean value of double 0.0 should be false", (Object)"false", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean(xs:double(1.0))", 1);
            XPathQueryTest.assertEquals((String)"boolean value of double 1.0 should be true", (Object)"true", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean(xs:float(1.0))", 1);
            XPathQueryTest.assertEquals((String)"boolean value of float 1.0 should be true", (Object)"true", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean(xs:float(0.0))", 1);
            XPathQueryTest.assertEquals((String)"boolean value of float 0.0 should be false", (Object)"false", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean(xs:integer(0))", 1);
            XPathQueryTest.assertEquals((String)"boolean value of integer 0 should be false", (Object)"false", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean(xs:integer(1))", 1);
            XPathQueryTest.assertEquals((String)"boolean value of integer 1 should be true", (Object)"true", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "'true' cast as xs:boolean", 1);
            XPathQueryTest.assertEquals((String)"boolean value of 'true' cast to xs:boolean should be true", (Object)"true", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "'false' cast as xs:boolean", 1);
            XPathQueryTest.assertEquals((String)"boolean value of 'false' cast to xs:boolean should be false", (Object)"false", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean('Hello')", 1);
            XPathQueryTest.assertEquals((String)"boolean value of string 'Hello' should be true", (Object)"true", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean('')", 1);
            XPathQueryTest.assertEquals((String)"boolean value of empty string should be false", (Object)"false", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean(())", 1);
            XPathQueryTest.assertEquals((String)"boolean value of empty sequence should be false", (Object)"false", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean(('Hello'))", 1);
            XPathQueryTest.assertEquals((String)"boolean value of sequence with non-empty string should be true", (Object)"true", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean((0.0, 0.0))", 1);
            XPathQueryTest.assertEquals((String)"boolean value of sequence with two elements should be true", (Object)"true", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean(//item[@id = '1']/price)", 1);
            XPathQueryTest.assertEquals((String)"boolean value of 5.6 should be true", (Object)"true", (Object)result.getResource(0L).getContent());
            result = this.queryResource(service, "numbers.xml", "boolean(current-time())", 1);
            XPathQueryTest.assertEquals((String)"boolean value of current-time() should be true", (Object)"true", (Object)result.getResource(0L).getContent());
        }
        catch (XMLDBException e) {
            System.out.println("testBoolean(): XMLDBException: " + (Object)((Object)e));
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    public void testNot() {
        try {
            XPathQueryService service = this.storeXMLStringAndGetQueryService("strings.xml", strings);
            this.queryResource(service, "strings.xml", "/test/string[not(@value)]", 2);
            ResourceSet result = this.queryResource(service, "strings.xml", "not(/test/abcd)", 1);
            Resource r = result.getResource(0L);
            XPathQueryTest.assertEquals((String)"true", (String)r.getContent().toString());
            result = this.queryResource(service, "strings.xml", "not(/test)", 1);
            r = result.getResource(0L);
            XPathQueryTest.assertEquals((String)"false", (String)r.getContent().toString());
            result = this.queryResource(service, "strings.xml", "/test/string[not(@id)]", 3);
            r = result.getResource(0L);
            XPathQueryTest.assertEquals((String)"<string>Hello World!</string>", (String)r.getContent().toString());
            this.queryResource(service, "strings.xml", "document()/blah[not(blah)]", 0);
            this.queryResource(service, "strings.xml", "//*[string][not(@value)]", 1);
            this.queryResource(service, "strings.xml", "//*[string][not(@blah)]", 1);
            this.queryResource(service, "strings.xml", "//*[blah][not(@blah)]", 0);
        }
        catch (XMLDBException e) {
            System.out.println("testStrings(): XMLDBException: " + (Object)((Object)e));
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    public void testIds() {
        try {
            XPathQueryService service = this.storeXMLStringAndGetQueryService("ids.xml", ids);
            this.queryResource(service, "ids.xml", "//a/id(@ref)", 1);
            this.queryResource(service, "ids.xml", "id(//a/@ref)", 1);
            ResourceSet result = this.queryResource(service, "ids.xml", "//a/id(@ref)/name", 1);
            Resource r = result.getResource(0L);
            XPathQueryTest.assertEquals((String)"<name>one</name>", (String)r.getContent().toString());
        }
        catch (XMLDBException e) {
            System.out.println("testIds(): XMLDBException: " + (Object)((Object)e));
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    public void testQueryResource() {
        try {
            XMLResource doc = (XMLResource)this.testCollection.createResource("strings.xml", "XMLResource");
            doc.setContent((Object)strings);
            this.testCollection.storeResource((Resource)doc);
            doc = (XMLResource)this.testCollection.createResource("strings2.xml", "XMLResource");
            doc.setContent((Object)strings);
            this.testCollection.storeResource((Resource)doc);
            XPathQueryService query = (XPathQueryService)this.testCollection.getService("XPathQueryService", "1.0");
            ResourceSet result = query.queryResource("strings2.xml", "/test/string[. = 'Hello World!']");
            XPathQueryTest.assertEquals((long)1L, (long)result.getSize());
            result = query.query("/test/string[. = 'Hello World!']");
            XPathQueryTest.assertEquals((long)2L, (long)result.getSize());
        }
        catch (XMLDBException e) {
            System.out.println("testQueryResource(): XMLDBException: " + (Object)((Object)e));
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    private ResourceSet queryResource(XPathQueryService service, String resource, String query, int expected) throws XMLDBException {
        return this.queryResource(service, resource, query, expected, null);
    }

    private ResourceSet queryResource(XPathQueryService service, String resource, String query, int expected, String message) throws XMLDBException {
        ResourceSet result = service.queryResource(resource, query);
        if (message == null) {
            XPathQueryTest.assertEquals((long)expected, (long)result.getSize());
        } else {
            XPathQueryTest.assertEquals((String)message, (long)expected, (long)result.getSize());
        }
        return result;
    }

    private XPathQueryService storeXMLStringAndGetQueryService(String documentName, String content) throws XMLDBException {
        XMLResource doc = (XMLResource)this.testCollection.createResource(documentName, "XMLResource");
        doc.setContent((Object)content);
        this.testCollection.storeResource((Resource)doc);
        XPathQueryService service = (XPathQueryService)this.testCollection.getService("XPathQueryService", "1.0");
        return service;
    }

    public void testNamespaces() {
        try {
            XPathQueryService service = this.storeXMLStringAndGetQueryService("namespaces.xml", namespaces);
            service.setNamespace("t", "http://www.foo.com");
            ResourceSet result = service.queryResource("namespaces.xml", "//t:section");
            XPathQueryTest.assertEquals((long)1L, (long)result.getSize());
            result = service.queryResource("namespaces.xml", "/t:test//c:comment");
            XPathQueryTest.assertEquals((long)1L, (long)result.getSize());
            result = service.queryResource("namespaces.xml", "//c:*");
            XPathQueryTest.assertEquals((long)1L, (long)result.getSize());
            result = service.queryResource("namespaces.xml", "//*:comment");
            XPathQueryTest.assertEquals((long)1L, (long)result.getSize());
        }
        catch (XMLDBException e) {
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    public void testNestedElements() {
        try {
            XPathQueryService service = this.storeXMLStringAndGetQueryService("nested.xml", nested);
            ResourceSet result = service.queryResource("nested.xml", "//c");
            this.printResult(result);
            XPathQueryTest.assertEquals((long)3L, (long)result.getSize());
        }
        catch (XMLDBException e) {
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    public void testStaticVariables() {
        ResourceSet result = null;
        try {
            XMLResource doc = (XMLResource)this.testCollection.createResource("numbers.xml", "XMLResource");
            doc.setContent((Object)numbers);
            this.testCollection.storeResource((Resource)doc);
            XPathQueryService service = (XPathQueryService)this.testCollection.getService("XPathQueryService", "1.0");
            XPathQueryServiceImpl service2 = (XPathQueryServiceImpl)service;
            service2.declareVariable("name", "MONTAGUE");
            service2.declareVariable("name", "43");
            result = service2.query(doc, "//item[stock=$name]");
            System.out.println("testStaticVariables 1: ========");
            this.printResult(result);
            result = service2.query("$name");
            XPathQueryTest.assertEquals((long)1L, (long)result.getSize());
            System.out.println("testStaticVariables 2: ========");
            this.printResult(result);
            result = service2.query(doc, "//item[stock=43]");
            XPathQueryTest.assertEquals((long)1L, (long)result.getSize());
            System.out.println("testStaticVariables 3: ========");
            this.printResult(result);
            result = service2.query(doc, "//item");
            XPathQueryTest.assertEquals((long)4L, (long)result.getSize());
        }
        catch (XMLDBException e) {
            System.out.println("testStaticVariables(): XMLDBException: " + (Object)((Object)e));
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    private void printResult(ResourceSet result) throws XMLDBException {
        ResourceIterator i = result.getIterator();
        while (i.hasMoreResources()) {
            Resource r = i.nextResource();
            System.out.println(r.getContent());
        }
    }

    public void testMembersAsResource() {
        try {
            XPathQueryService service = this.storeXMLStringAndGetQueryService("numbers.xml", numbers);
            ResourceSet result = service.query("//item/price");
            Resource r = result.getMembersAsResource();
            String content = (String)r.getContent();
            System.out.println(content);
            Pattern p = Pattern.compile(".*(<price>.*){4}", 32);
            Matcher m = p.matcher(content);
            XPathQueryTest.assertTrue((String)"get whole document numbers.xml", (boolean)m.matches());
        }
        catch (XMLDBException e) {
            XPathQueryTest.fail((String)e.getMessage());
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Class)XPathQueryTest.class);
    }
}

