/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.test;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.StringReader;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.NodeSet;
import org.exist.security.PermissionDeniedException;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.Configuration;
import org.exist.util.LockException;
import org.exist.xquery.PathExpr;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.parser.XQueryLexer;
import org.exist.xquery.parser.XQueryParser;
import org.exist.xquery.parser.XQueryTreeParser;
import org.exist.xquery.value.Sequence;
import org.xml.sax.SAXException;

public class LexerTest
extends TestCase {
    private boolean localDb = false;
    private static final String xml = "<text><body><p>\u660e &#x660E;</p><p>&#xC5F4; &#xB2E8;&#xACC4;</p><p>\u4ed6\u4e3a\u8fd9\u9879\u5de5\u7a0b\u6295\u5165\u4e86\u5341\u4e09\u5e74\u65f6\u95f4\u3002</p></body></text>";

    public LexerTest(String arg0) {
        super(arg0);
    }

    private void configure() {
        String file = "conf.xml";
        String home = System.getProperty("exist.home");
        if (home == null) {
            home = System.getProperty("user.dir");
        }
        try {
            Configuration config = new Configuration(file, home);
            BrokerPool.configure(1, 5, config);
        }
        catch (Exception e) {
            e.printStackTrace();
            LexerTest.fail((String)e.getMessage());
        }
        this.localDb = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQuery() throws XPathException {
        String query = "document()//p[. = '\u4ed6\u4e3a\u8fd9\u9879\u5de5\u7a0b\u6295\u5165\u4e86\u5341\u4e09\u5e74\u65f6\u95f4\u3002']";
        BrokerPool pool = null;
        try {
            pool = BrokerPool.getInstance();
        }
        catch (EXistException e1) {
            e1.printStackTrace();
            LexerTest.fail((String)e1.getMessage());
        }
        User user = pool.getSecurityManager().getUser("admin");
        DBBroker broker = null;
        try {
            broker = pool.get(user);
            Collection collection = broker.getCollection("/db/test");
            collection.addDocument(broker, "test.xml", xml);
            XQueryContext context = new XQueryContext(broker);
            XQueryLexer lexer = new XQueryLexer(context, new StringReader(query));
            XQueryParser xparser = new XQueryParser(lexer);
            XQueryTreeParser treeParser = new XQueryTreeParser(context);
            xparser.xpath();
            if (xparser.foundErrors()) {
                System.err.println(xparser.getErrorMessage());
                return;
            }
            AST ast = xparser.getAST();
            System.out.println("generated AST: " + ast.toStringTree());
            PathExpr expr = new PathExpr(context);
            treeParser.xpath(ast, expr);
            if (treeParser.foundErrors()) {
                System.err.println(treeParser.getErrorMessage());
                return;
            }
            Sequence result = expr.eval(null, null);
            NodeSet resultSet = (NodeSet)result;
            System.out.println("----------------------------------");
            System.out.println("found: " + resultSet.getLength());
        }
        catch (RecognitionException e) {
            e.printStackTrace();
        }
        catch (TokenStreamException e) {
            e.printStackTrace();
        }
        catch (EXistException e) {
            e.printStackTrace();
        }
        catch (PermissionDeniedException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (TriggerException e) {
            e.printStackTrace();
        }
        catch (LockException e) {
            e.printStackTrace();
        }
        finally {
            pool.release(broker);
        }
        if (this.localDb) {
            try {
                BrokerPool.stop();
            }
            catch (EXistException e2) {
                e2.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Class)LexerTest.class);
    }

    protected void setUp() throws Exception {
        if (!BrokerPool.isConfigured()) {
            this.configure();
        }
    }
}

