/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.xmldb;

import java.util.Iterator;
import org.exist.dom.QName;
import org.exist.security.User;
import org.exist.xmldb.LocalCollection;
import org.exist.xmldb.UserManagementService;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;
import org.xmldb.api.base.XMLDBException;

public class XMLDBUserAccess
extends BasicFunction {
    public static final FunctionSignature fnExistsUser = new FunctionSignature(new QName("exists-user", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns true if user exists. Requires username.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(23, 2));
    public static final FunctionSignature fnUserGroups = new FunctionSignature(new QName("get-user-groups", "http://exist-db.org/xquery/xmldb", "xmldb"), "Receives the sequence of groups the specified user is a member of.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 6));
    public static final FunctionSignature fnUserHome = new FunctionSignature(new QName("get-user-home", "http://exist-db.org/xquery/xmldb", "xmldb"), "Returns the home collection of the specified user or the empty sequence if no home collection is assigned to the user.", new SequenceType[]{new SequenceType(22, 2)}, new SequenceType(22, 3));

    public XMLDBUserAccess(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Loose catch block
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence sequence;
        LocalCollection collection;
        String userName;
        block17: {
            User user;
            block15: {
                ValueSequence valueSequence;
                block16: {
                    block13: {
                        BooleanValue booleanValue;
                        block14: {
                            userName = args[0].getStringValue();
                            collection = null;
                            collection = new LocalCollection(this.context.getUser(), this.context.getBroker().getBrokerPool(), "/db");
                            UserManagementService ums = (UserManagementService)collection.getService("UserManagementService", "1.0");
                            user = ums.getUser(userName);
                            if (!this.isCalledAs("exists-user")) break block13;
                            booleanValue = null == user ? BooleanValue.FALSE : BooleanValue.TRUE;
                            Object var11_11 = null;
                            if (null == collection) break block14;
                            try {
                                collection.close();
                            }
                            catch (XMLDBException e) {
                                // empty catch block
                            }
                        }
                        return booleanValue;
                    }
                    if (user == null) {
                        throw new XPathException(this.getASTNode(), "User not found: " + userName);
                    }
                    if (!this.isCalledAs("get-user-groups")) break block15;
                    ValueSequence groups = new ValueSequence();
                    Iterator i = user.getGroups();
                    while (i.hasNext()) {
                        String group = (String)i.next();
                        groups.add(new StringValue(group));
                    }
                    valueSequence = groups;
                    Object var11_12 = null;
                    if (null == collection) break block16;
                    try {
                        collection.close();
                    }
                    catch (XMLDBException e) {
                        // empty catch block
                    }
                }
                return valueSequence;
            }
            String home = user.getHome();
            sequence = null == home ? Sequence.EMPTY_SEQUENCE : new StringValue(home);
            Object var11_13 = null;
            if (null == collection) break block17;
            try {
                collection.close();
            }
            catch (XMLDBException e) {
                // empty catch block
            }
        }
        return sequence;
        catch (XMLDBException xe) {
            try {
                throw new XPathException(this.getASTNode(), "Failed to query user " + userName, xe);
            }
            catch (Throwable throwable) {
                block18: {
                    Object var11_14 = null;
                    if (null == collection) break block18;
                    try {
                        collection.close();
                    }
                    catch (XMLDBException e) {}
                }
                throw throwable;
            }
        }
    }
}

